/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.functions.Round;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public final class Int64Value
extends IntegerValue {
    public static final Int64Value MINUS_ONE = new Int64Value(-1L);
    public static final Int64Value ZERO = new Int64Value(0L);
    public static final Int64Value PLUS_ONE = new Int64Value(1L);
    public static final Int64Value MAX_LONG = new Int64Value(Long.MAX_VALUE);
    public static final Int64Value MIN_LONG = new Int64Value(Long.MIN_VALUE);
    private final long value;
    private static final Int64Value[] SMALL_INTEGERS = new Int64Value[]{new Int64Value(0L), new Int64Value(1L), new Int64Value(2L), new Int64Value(3L), new Int64Value(4L), new Int64Value(5L), new Int64Value(6L), new Int64Value(7L), new Int64Value(8L), new Int64Value(9L), new Int64Value(10L), new Int64Value(11L), new Int64Value(12L), new Int64Value(13L), new Int64Value(14L), new Int64Value(15L), new Int64Value(16L), new Int64Value(17L), new Int64Value(18L), new Int64Value(19L), new Int64Value(20L)};
    private static final byte[] DIGITS = StringConstants.bytes("0123456789");
    private static final byte[] DIGIT_TENS = StringConstants.bytes("0000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999");
    private static final byte[] DIGIT_ONES = StringConstants.bytes("0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
    private static final long[] powersOfTen = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public Int64Value(long value) {
        super(BuiltInAtomicType.INTEGER);
        this.value = value;
    }

    public Int64Value(long value, AtomicType typeLabel) {
        super(typeLabel);
        this.value = value;
    }

    public Int64Value(long val, BuiltInAtomicType typeLabel, boolean check) throws XPathException {
        super(typeLabel);
        this.value = val;
        if (check && !Int64Value.checkRange(this.value, typeLabel)) {
            throw new XPathException("Integer value " + val + " is out of range for the requested type " + typeLabel.getDescription()).withErrorCode("XPTY0004").asTypeError();
        }
    }

    public static Int64Value makeIntegerValue(long value) {
        if (value <= 20L && value >= 0L) {
            return SMALL_INTEGERS[(int)value];
        }
        return new Int64Value(value);
    }

    public static Int64Value makeDerived(long val, AtomicType type) {
        return new Int64Value(val, type);
    }

    public static Int64Value signum(long val) {
        if (val == 0L) {
            return ZERO;
        }
        return val < 0L ? MINUS_ONE : PLUS_ONE;
    }

    @Override
    public int asSubscript() {
        if (this.value > 0L && this.value <= Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return -1;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        if (typeLabel.getPrimitiveType() == 533) {
            return new Int64Value(this.value, typeLabel);
        }
        return new BigDecimalValue(this.value).copyAsSubType(typeLabel);
    }

    @Override
    public ValidationFailure validateAgainstSubType(BuiltInAtomicType type) {
        if (Int64Value.checkRange(this.value, type)) {
            return null;
        }
        ValidationFailure err = new ValidationFailure("Value " + this.value + " cannot be converted to integer subtype " + type.getDescription());
        err.setErrorCode("FORG0001");
        return err;
    }

    @Override
    public int hashCode() {
        if (this.value > Integer.MIN_VALUE && this.value < Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return Double.valueOf(this.getDoubleValue()).hashCode();
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.value != 0L;
    }

    @Override
    public int compareTo(XPathComparable other) {
        if (other instanceof NumericValue) {
            if (other instanceof Int64Value) {
                return Long.compare(this.value, ((Int64Value)other).value);
            }
            if (other instanceof BigIntegerValue) {
                return BigInteger.valueOf(this.value).compareTo(((BigIntegerValue)other).asBigInteger());
            }
            if (other instanceof BigDecimalValue) {
                return BigDecimal.valueOf(this.value).compareTo(((BigDecimalValue)other).getDecimalValue());
            }
            return super.compareTo(other);
        }
        throw new ClassCastException("Cannot compare xs:integer to " + String.valueOf(other));
    }

    @Override
    public int compareTo(long other) {
        return Long.compare(this.value, other);
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        if (this.value == Long.MIN_VALUE) {
            return StringConstants.MIN_LONG;
        }
        int size = this.value < 0L ? Int64Value.stringSize(-this.value) + 1 : Int64Value.stringSize(this.value);
        byte[] buf = new byte[size];
        Int64Value.getDigits(this.value, size, buf);
        return new Twine8(buf);
    }

    private static void getDigits(long i, int index, byte[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DIGIT_ONES[r];
            buf[--charPos] = DIGIT_TENS[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DIGIT_ONES[r];
            buf[--charPos] = DIGIT_TENS[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = DIGITS[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    private static int stringSize(long x) {
        for (int w = 0; w < 18; ++w) {
            if (x >= powersOfTen[w]) continue;
            return w + 1;
        }
        return 19;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public float getFloatValue() {
        return this.value;
    }

    @Override
    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public NumericValue negate() {
        if (this.value == Long.MIN_VALUE) {
            return BigIntegerValue.makeIntegerValue(BigInteger.valueOf(this.value)).negate();
        }
        return new Int64Value(-this.value);
    }

    @Override
    public NumericValue floor() {
        return this;
    }

    @Override
    public NumericValue ceiling() {
        return this;
    }

    @Override
    public NumericValue round(int scale) {
        if (scale >= 0 || this.value == 0L) {
            return this;
        }
        if (scale < -15) {
            return new BigIntegerValue(this.value).round(scale);
        }
        long absolute = Math.abs(this.value);
        long factor = 1L;
        for (long i = 1L; i <= (long)(-scale); ++i) {
            factor *= 10L;
        }
        long modulus = absolute % factor;
        long rval = absolute - modulus;
        long d = modulus * 2L;
        if (this.value > 0L) {
            if (d >= factor) {
                rval += factor;
            }
        } else {
            if (d > factor) {
                rval += factor;
            }
            rval = -rval;
        }
        return new Int64Value(rval);
    }

    @Override
    public NumericValue round(int scale, Round.RoundingRule roundingRule) {
        if (scale >= 0 || this.value == 0L) {
            return this;
        }
        if (scale < -15) {
            return new BigIntegerValue(this.value).round(scale, roundingRule);
        }
        boolean negative = this.value < 0L;
        long factor = 1L;
        for (long i = 1L; i <= (long)(-scale); ++i) {
            factor *= 10L;
        }
        long towardsZero = this.value / factor * factor;
        if (towardsZero == this.value) {
            return this;
        }
        long awayFromZero = negative ? towardsZero - factor : towardsZero + factor;
        long floor = negative ? awayFromZero : towardsZero;
        long ceiling = negative ? towardsZero : awayFromZero;
        long midpoint = floor + (ceiling - floor) / 2L;
        boolean midway = this.value == midpoint;
        long nearest = this.value > midpoint ? ceiling : floor;
        switch (roundingRule) {
            case FLOOR: {
                return Int64Value.makeIntegerValue(floor);
            }
            case TOWARD_ZERO: {
                return Int64Value.makeIntegerValue(towardsZero);
            }
            case CEILING: {
                return Int64Value.makeIntegerValue(ceiling);
            }
            case AWAY_FROM_ZERO: {
                return Int64Value.makeIntegerValue(awayFromZero);
            }
            case HALF_TO_FLOOR: {
                return Int64Value.makeIntegerValue(midway ? floor : nearest);
            }
            default: {
                return Int64Value.makeIntegerValue(midway ? ceiling : nearest);
            }
            case HALF_TOWARD_ZERO: {
                return Int64Value.makeIntegerValue(midway ? towardsZero : nearest);
            }
            case HALF_AWAY_FROM_ZERO: {
                return Int64Value.makeIntegerValue(midway ? awayFromZero : nearest);
            }
            case HALF_TO_EVEN: 
        }
        return Int64Value.makeIntegerValue(midway ? (floor / factor % 2L == 0L ? floor : ceiling) : nearest);
    }

    @Override
    public int signum() {
        if (this.value > 0L) {
            return 1;
        }
        if (this.value == 0L) {
            return 0;
        }
        return -1;
    }

    @Override
    public NumericValue abs() {
        if (this.value > 0L) {
            return this;
        }
        if (this.value == Long.MIN_VALUE) {
            return new BigIntegerValue(new BigInteger("9223372036854775808"));
        }
        return Int64Value.makeIntegerValue(-this.value);
    }

    @Override
    public IntegerValue plus(IntegerValue other) {
        if (other instanceof Int64Value) {
            long topa = this.value >> 60 & 0xFL;
            if (topa != 0L && topa != 15L) {
                return new BigIntegerValue(this.value).plus(new BigIntegerValue(((Int64Value)other).value));
            }
            long topb = ((Int64Value)other).value >> 60 & 0xFL;
            if (topb != 0L && topb != 15L) {
                return new BigIntegerValue(this.value).plus(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value + ((Int64Value)other).value);
        }
        return new BigIntegerValue(this.value).plus(other);
    }

    @Override
    public IntegerValue minus(IntegerValue other) {
        if (other instanceof Int64Value) {
            long topa = this.value >> 60 & 0xFL;
            if (topa != 0L && topa != 15L) {
                return new BigIntegerValue(this.value).minus(new BigIntegerValue(((Int64Value)other).value));
            }
            long topb = ((Int64Value)other).value >> 60 & 0xFL;
            if (topb != 0L && topb != 15L) {
                return new BigIntegerValue(this.value).minus(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value - ((Int64Value)other).value);
        }
        return new BigIntegerValue(this.value).minus(other);
    }

    @Override
    public IntegerValue times(IntegerValue other) {
        if (other instanceof Int64Value) {
            if (this.isLong() || ((Int64Value)other).isLong()) {
                return new BigIntegerValue(this.value).times(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value * ((Int64Value)other).value);
        }
        return new BigIntegerValue(this.value).times(other);
    }

    @Override
    public NumericValue div(IntegerValue other) throws XPathException {
        if (other instanceof Int64Value) {
            long quotient = ((Int64Value)other).value;
            if (quotient == 0L) {
                throw new XPathException("Integer division by zero", "FOAR0001");
            }
            if (this.isLong() || ((Int64Value)other).isLong()) {
                return new BigIntegerValue(this.value).div(new BigIntegerValue(quotient));
            }
            if (this.value % quotient == 0L) {
                return Int64Value.makeIntegerValue(this.value / quotient);
            }
            return Calculator.decimalDivide(new BigDecimalValue(this.value), new BigDecimalValue(quotient));
        }
        return new BigIntegerValue(this.value).div(other);
    }

    @Override
    public IntegerValue mod(IntegerValue other) throws XPathException {
        if (other instanceof Int64Value) {
            long quotient = ((Int64Value)other).value;
            if (quotient == 0L) {
                throw new XPathException("Integer modulo zero", "FOAR0001");
            }
            if (this.isLong() || ((Int64Value)other).isLong()) {
                return new BigIntegerValue(this.value).mod(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value % quotient);
        }
        return new BigIntegerValue(this.value).mod(other);
    }

    @Override
    public IntegerValue idiv(IntegerValue other) throws XPathException {
        if (other.signum() == 0) {
            throw new XPathException("Integer division by zero", "FOAR0001");
        }
        if (other instanceof Int64Value) {
            if (this.isLong() || ((Int64Value)other).isLong()) {
                return new BigIntegerValue(this.value).idiv(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value / ((Int64Value)other).value);
        }
        return new BigIntegerValue(this.value).idiv(other);
    }

    private boolean isLong() {
        long top = this.value >> 31;
        return top != 0L;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }
}

