/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.ComponentBody;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.IAccumulatorManager;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.NestedIntegerValue;
import net.sf.saxon.z.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesheetPackage
extends StylesheetModule
implements GlobalVariableManager {
    private NestedIntegerValue packageVersionOLD = null;
    private PackageVersion packageVersion = null;
    private String packageName;
    private List<StylesheetPackage> usedPackages = new ArrayList<StylesheetPackage>();
    protected HashSet<String> schemaIndex = new HashSet(10);
    private XQueryFunctionLibrary queryFunctions;
    private FunctionLibraryList functionLibrary;
    private FunctionLibraryList stylesheetFunctionLibrary;
    private ExecutableFunctionLibrary overriding;
    private ExecutableFunctionLibrary underriding;
    private DecimalValue version;
    private HashMap<StructuredQName, ComponentDeclaration> globalVariableIndex = new HashMap(20);
    private HashMap<SymbolicName, Component> componentIndex = new HashMap(20);
    private List<Component> hiddenComponents = new ArrayList<Component>();
    private HashMap<StructuredQName, ComponentDeclaration> templateIndex = new HashMap(20);
    private HashMap<SymbolicName, ComponentDeclaration> functionIndex = new HashMap(8);
    private HashMap<StructuredQName, Integer> localParameterNumbers = null;
    private KeyManager keyManager;
    private DecimalFormatManager decimalFormatManager;
    private RuleManager ruleManager;
    private IAccumulatorManager accumulatorManager = null;
    private int numberOfAliases = 0;
    private List<ComponentDeclaration> namespaceAliasList = new ArrayList<ComponentDeclaration>(5);
    private HashMap<String, NamespaceBinding> namespaceAliasMap;
    private Set<String> aliasResultUriSet;
    private boolean needsDynamicOutputProperties = false;
    private int largestPatternStackFrame = 0;
    private HashMap<DocumentURI, XSLModuleRoot> moduleCache = new HashMap(4);
    private SpaceStrippingRule stripperRules;
    private CharacterMapIndex characterMapIndex = new CharacterMapIndex();
    private List<Action> fixupActions = new ArrayList<Action>();
    private List<Action> completionActions = new ArrayList<Action>();
    private boolean createsSecondaryResultDocuments = false;

    public StylesheetPackage(XSLPackage sourceElement) {
        super(sourceElement, 0);
        this.keyManager = new KeyManager(sourceElement.getConfiguration());
        this.decimalFormatManager = new DecimalFormatManager();
        this.ruleManager = new RuleManager();
        try {
            this.setInputTypeAnnotations(sourceElement.getInputTypeAnnotationsAttribute());
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    public Component getComponent(SymbolicName name) {
        return this.componentIndex.get(name);
    }

    public void removeGlobalVariable(ComponentDeclaration decl) {
        StructuredQName name = decl.getSourceElement().getObjectName();
        SymbolicName sName = new SymbolicName(206, name);
        if (this.globalVariableIndex.get(name) == decl) {
            this.componentIndex.remove(sName);
            this.globalVariableIndex.remove(name);
        }
    }

    @Override
    public StylesheetPackage getPrincipalStylesheetModule() {
        return this;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.decimalFormatManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void addFixupAction(Action action) {
        this.fixupActions.add(action);
    }

    public void addCompletionAction(Action action) {
        this.completionActions.add(action);
    }

    public FunctionLibraryList createFunctionLibrary(Compilation compilation) {
        Configuration config = this.getConfiguration();
        FunctionLibraryList stylesheetFunctions = new FunctionLibraryList();
        stylesheetFunctions.addFunctionLibrary(new StylesheetFunctionLibrary(this, true));
        stylesheetFunctions.addFunctionLibrary(new StylesheetFunctionLibrary(this, false));
        this.stylesheetFunctionLibrary = stylesheetFunctions;
        FunctionLibraryList functionLibrary = new FunctionLibraryList();
        int functionSet = 3;
        if (DecimalValue.THREE.equals(this.getVersion())) {
            functionSet |= 0x50;
        }
        functionLibrary.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(functionSet));
        functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, true));
        functionLibrary.addFunctionLibrary(config.getVendorFunctionLibrary());
        functionLibrary.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        CompilerInfo info = compilation.getCompilerInfo();
        if (info.getExtensionFunctionLibrary() != null) {
            functionLibrary.addFunctionLibrary(info.getExtensionFunctionLibrary());
        }
        this.queryFunctions = new XQueryFunctionLibrary(config);
        functionLibrary.addFunctionLibrary(this.queryFunctions);
        functionLibrary.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(functionLibrary);
        for (StylesheetPackage pack : this.usedPackages) {
            FunctionLibraryList lib = pack.getStylesheetFunctionLibrary();
            functionLibrary.addFunctionLibrary(lib);
        }
        this.functionLibrary = functionLibrary;
        return this.functionLibrary;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public FunctionLibraryList getStylesheetFunctionLibrary() {
        return this.stylesheetFunctionLibrary;
    }

    public CharacterMapIndex getCharacterMapIndex() {
        return this.characterMapIndex;
    }

    public void declareXQueryFunction(XQueryFunction function) throws XPathException {
        this.queryFunctions.declareFunction(function);
    }

    public void putStylesheetDocument(DocumentURI key, XSLStylesheet module) {
        this.moduleCache.put(key, module);
    }

    public XSLModuleRoot getStylesheetDocument(DocumentURI key) {
        XSLModuleRoot sheet = this.moduleCache.get(key);
        if (sheet != null) {
            XPathException warning = new XPathException("Stylesheet module " + key + " is included or imported more than once. " + "This is permitted, but may lead to errors or unexpected behavior");
            sheet.issueWarning(warning);
        }
        return sheet;
    }

    public void preprocess() throws XPathException {
        ComponentDeclaration decl2;
        this.spliceUsePackages((XSLPackage)this.getRootElement(), this.getRootElement().getCompilation());
        this.importSchemata();
        this.buildIndexes();
        this.checkForSchemaAwareness();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        for (ComponentDeclaration decl2 : this.topLevel) {
            StyleElement inst = decl2.getSourceElement();
            if (inst.isActionCompleted(16)) continue;
            inst.setActionCompleted(16);
            inst.fixupReferences();
        }
        XSLPackage top = (XSLPackage)this.getStylesheetElement();
        decl2 = new ComponentDeclaration(this, top);
        if (!top.isActionCompleted(1)) {
            top.setActionCompleted(1);
            this.getRootElement().validate(decl2);
            top.validate(null);
            for (ComponentDeclaration d : this.topLevel) {
                d.getSourceElement().validateSubtree(d, false);
            }
        }
        for (ComponentDeclaration d : this.topLevel) {
            StyleElement inst = d.getSourceElement();
            if (!(inst instanceof XSLCharacterMap)) continue;
            XSLCharacterMap xcm = (XSLCharacterMap)inst;
            IntHashMap<String> map = new IntHashMap<String>();
            xcm.assemble(map);
            this.characterMapIndex.putCharacterMap(xcm.getCharacterMapName(), new CharacterMap(map));
        }
    }

    protected void spliceUsePackages(XSLPackage xslpackage, Compilation compilation) throws XPathException {
        CompilerInfo info = compilation.getCompilerInfo();
        if (info.isVersionWarning() && xslpackage.getEffectiveVersion().compareTo(compilation.getStyleNodeFactory(true).getXsltProcessorVersion()) != 0) {
            XPathException w = new XPathException("Running an XSLT " + xslpackage.getEffectiveVersion() + " stylesheet with an XSLT " + xslpackage.getCompilation().getStyleNodeFactory(true).getXsltProcessorVersion() + " processor");
            w.setLocator(xslpackage);
            compilation.reportWarning(w);
        }
        this.spliceIncludes();
    }

    protected void importSchemata() throws XPathException {
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            ComponentDeclaration decl = (ComponentDeclaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLImportSchema)) continue;
            XPathException xe = new XPathException("xsl:import-schema requires Saxon-EE");
            xe.setErrorCode("XTSE1650");
            xe.setLocator(decl.getSourceElement());
            throw xe;
        }
    }

    private void buildIndexes() throws XPathException {
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            ComponentDeclaration decl = (ComponentDeclaration)this.topLevel.get(i);
            decl.getSourceElement().index(decl, this);
        }
        Configuration config = this.getConfiguration();
        for (String ns : this.schemaIndex) {
            config.sealNamespace(ns);
        }
    }

    public void processAllAttributes() throws XPathException {
        this.getRootElement().processDefaultCollationAttribute();
        this.getRootElement().prepareAttributes();
        for (XSLModuleRoot xss : this.moduleCache.values()) {
            xss.prepareAttributes();
        }
        for (ComponentDeclaration decl : this.topLevel) {
            StyleElement inst = decl.getSourceElement();
            if (inst.isActionCompleted(32)) continue;
            inst.setActionCompleted(32);
            try {
                inst.processAllAttributes();
            }
            catch (XPathException err) {
                decl.getSourceElement().compileError(err);
            }
        }
    }

    protected void indexFunction(ComponentDeclaration decl) throws XPathException {
        SymbolicName sName;
        XSLFunction sourceFunction = (XSLFunction)decl.getSourceElement();
        UserFunction compiledFunction = sourceFunction.getCompiledFunction();
        Component declaringComponent = compiledFunction.getDeclaringComponent();
        if (declaringComponent == null) {
            compiledFunction.makeDeclaringComponent(sourceFunction.getVisibility(), this);
            declaringComponent = compiledFunction.getDeclaringComponent();
        }
        if ((sName = sourceFunction.getSymbolicName()) != null) {
            Component other = this.componentIndex.get(sName);
            if (other == null) {
                this.componentIndex.put(sName, declaringComponent);
                this.functionIndex.put(sName, decl);
            } else if (other.getDeclaringPackage() == this) {
                ComponentDeclaration otherFunction;
                int otherPrecedence;
                int thisPrecedence = decl.getPrecedence();
                if (thisPrecedence == (otherPrecedence = (otherFunction = this.functionIndex.get(sName)).getPrecedence())) {
                    sourceFunction.compileError("Duplicate named function (see line " + otherFunction.getSourceElement().getLineNumber() + " of " + otherFunction.getSourceElement().getSystemId() + ')', "XTSE0770");
                } else if (thisPrecedence >= otherPrecedence) {
                    this.componentIndex.put(sName, declaringComponent);
                    this.functionIndex.put(sName, decl);
                }
            } else {
                this.componentIndex.put(sName, declaringComponent);
                this.functionIndex.put(sName, decl);
            }
        }
    }

    private ComponentDeclaration getFunctionDeclaration(SymbolicName name) {
        return this.functionIndex.get(name);
    }

    protected UserFunction getFunction(SymbolicName name) {
        if (name.getArity() == -1) {
            int maximumArity = 20;
            for (int a = 0; a < maximumArity; ++a) {
                SymbolicName sn = new SymbolicName(155, name.getComponentName(), a);
                ComponentDeclaration decl = this.getFunctionDeclaration(sn);
                if (decl == null) continue;
                return ((XSLFunction)decl.getSourceElement()).getCompiledFunction();
            }
            return null;
        }
        Component component = this.componentIndex.get(name);
        return component == null ? null : (UserFunction)component.getProcedure();
    }

    protected void indexVariableDeclaration(ComponentDeclaration decl) throws XPathException {
        XSLGlobalVariable var = (XSLGlobalVariable)decl.getSourceElement();
        StructuredQName qName = var.getSourceBinding().getVariableQName();
        if (qName != null) {
            ComponentDeclaration other = this.globalVariableIndex.get(qName);
            if (other == null) {
                this.globalVariableIndex.put(qName, decl);
                this.componentIndex.put(new SymbolicName(206, qName), var.getCompiledProcedure().getDeclaringComponent());
            } else {
                int otherPrecedence;
                int thisPrecedence = decl.getPrecedence();
                if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                    StyleElement v2 = other.getSourceElement();
                    if (v2 == var) {
                        var.compileError("Global variable " + qName.getDisplayName() + " is declared more than once " + "(caused by including the containing module more than once)", "XTSE0630");
                    } else {
                        var.compileError("Duplicate global variable declaration (see line " + v2.getLineNumber() + " of " + v2.getSystemId() + ')', "XTSE0630");
                    }
                } else if (thisPrecedence < otherPrecedence && var != other.getSourceElement()) {
                    var.setRedundant(true);
                } else if (var != other.getSourceElement()) {
                    ((XSLGlobalVariable)other.getSourceElement()).setRedundant(true);
                    this.globalVariableIndex.put(qName, decl);
                    this.componentIndex.put(new SymbolicName(206, qName), var.getCompiledProcedure().getDeclaringComponent());
                }
            }
        }
    }

    public SourceBinding getGlobalVariableBinding(StructuredQName qName) {
        ComponentDeclaration decl = this.globalVariableIndex.get(qName);
        return decl == null ? null : ((XSLGlobalVariable)decl.getSourceElement()).getSourceBinding();
    }

    public int allocateUniqueParameterNumber(StructuredQName qName) {
        Integer x;
        HashMap<StructuredQName, Integer> params = this.localParameterNumbers;
        if (params == null) {
            params = this.localParameterNumbers = new HashMap(50);
        }
        if ((x = params.get(qName)) == null) {
            x = params.size();
            params.put(qName, x);
        }
        return x;
    }

    protected void indexNamedTemplate(ComponentDeclaration decl) throws XPathException {
        SymbolicName sName;
        XSLTemplate sourceTemplate = (XSLTemplate)decl.getSourceElement();
        Template compiledTemplate = sourceTemplate.getCompiledTemplate();
        Component declaringComponent = compiledTemplate.getDeclaringComponent();
        if (declaringComponent == null) {
            compiledTemplate.makeDeclaringComponent(sourceTemplate.getVisibility(), this);
            declaringComponent = compiledTemplate.getDeclaringComponent();
        }
        if ((sName = sourceTemplate.getSymbolicName()) != null) {
            Component other = this.componentIndex.get(sName);
            if (other == null) {
                this.componentIndex.put(sName, declaringComponent);
                this.templateIndex.put(sName.getComponentName(), decl);
            } else if (other.getDeclaringPackage() == this) {
                ComponentDeclaration otherTemplate;
                int otherPrecedence;
                int thisPrecedence = decl.getPrecedence();
                if (thisPrecedence == (otherPrecedence = (otherTemplate = this.templateIndex.get(sName.getComponentName())).getPrecedence())) {
                    sourceTemplate.compileError("Duplicate named template (see line " + otherTemplate.getSourceElement().getLineNumber() + " of " + otherTemplate.getSourceElement().getSystemId() + ')', "XTSE0660");
                } else if (thisPrecedence >= otherPrecedence) {
                    this.componentIndex.put(sName, declaringComponent);
                    this.templateIndex.put(sName.getComponentName(), decl);
                }
            } else {
                this.componentIndex.put(sName, declaringComponent);
                this.templateIndex.put(sName.getComponentName(), decl);
            }
        }
    }

    public Template getNamedTemplate(StructuredQName name) {
        Component component = this.componentIndex.get(new SymbolicName(200, name));
        return component == null ? null : (Template)component.getProcedure();
    }

    protected void indexAttributeSet(ComponentDeclaration decl) throws XPathException {
        SymbolicName sName;
        XSLAttributeSet sourceAttributeSet = (XSLAttributeSet)decl.getSourceElement();
        AttributeSet compiledAttributeSet = sourceAttributeSet.getCompiledProcedure();
        Component declaringComponent = compiledAttributeSet.getDeclaringComponent();
        if (declaringComponent == null) {
            compiledAttributeSet.makeDeclaringComponent(sourceAttributeSet.getVisibility(), this);
            declaringComponent = compiledAttributeSet.getDeclaringComponent();
        }
        if ((sName = sourceAttributeSet.getSymbolicName()) != null) {
            Component other = this.componentIndex.get(sName);
            if (other == null) {
                this.componentIndex.put(sName, declaringComponent);
            } else if (other.getDeclaringPackage() == this) {
                int thisPrecedence = decl.getPrecedence();
            } else {
                this.componentIndex.put(sName, declaringComponent);
            }
        }
    }

    private void checkForSchemaAwareness() {
        Compilation compilation = this.getRootElement().getCompilation();
        if (!compilation.isSchemaAware() && this.getConfiguration().isLicensedFeature(2)) {
            for (ComponentDeclaration decl : this.topLevel) {
                StyleElement node = decl.getSourceElement();
                if (!(node instanceof XSLImportSchema)) continue;
                compilation.setSchemaAware(true);
                return;
            }
        }
    }

    public IAccumulatorManager getAccumulatorManager() {
        return this.accumulatorManager;
    }

    public void setAccumulatorManager(IAccumulatorManager accumulatorManager) {
        this.accumulatorManager = accumulatorManager;
    }

    protected void addNamespaceAlias(ComponentDeclaration node) {
        this.namespaceAliasList.add(node);
        ++this.numberOfAliases;
    }

    protected NamespaceBinding getNamespaceAlias(String uri) {
        return this.namespaceAliasMap.get(uri);
    }

    protected boolean isAliasResultNamespace(String uri) {
        return this.aliasResultUriSet.contains(uri);
    }

    private void collectNamespaceAliases() throws XPathException {
        this.namespaceAliasMap = new HashMap(this.numberOfAliases);
        this.aliasResultUriSet = new HashSet<String>(this.numberOfAliases);
        HashSet<String> aliasesAtThisPrecedence = new HashSet<String>();
        int currentPrecedence = -1;
        for (int i = 0; i < this.numberOfAliases; ++i) {
            ComponentDeclaration decl = this.namespaceAliasList.get(i);
            XSLNamespaceAlias xna = (XSLNamespaceAlias)decl.getSourceElement();
            String scode = xna.getStylesheetURI();
            NamespaceBinding resultBinding = xna.getResultNamespaceBinding();
            int prec = decl.getPrecedence();
            if (currentPrecedence != prec) {
                currentPrecedence = prec;
                aliasesAtThisPrecedence.clear();
            }
            if (aliasesAtThisPrecedence.contains(scode) && !this.namespaceAliasMap.get(scode).getURI().equals(resultBinding.getURI())) {
                xna.compileError("More than one alias is defined for the same namespace", "XTSE0810");
            }
            if (this.namespaceAliasMap.get(scode) == null) {
                this.namespaceAliasMap.put(scode, resultBinding);
                this.aliasResultUriSet.add(resultBinding.getURI());
            }
            aliasesAtThisPrecedence.add(scode);
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public Properties gatherOutputProperties(StructuredQName formatQName) throws XPathException {
        boolean found = formatQName == null;
        Configuration config = this.getConfiguration();
        Properties details = new Properties(config.getDefaultSerializationProperties());
        HashMap<String, Integer> precedences = new HashMap<String, Integer>(10);
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            ComponentDeclaration decl = (ComponentDeclaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLOutput)) continue;
            XSLOutput xo = (XSLOutput)decl.getSourceElement();
            if (!(formatQName == null ? xo.getFormatQName() == null : formatQName.equals(xo.getFormatQName()))) continue;
            found = true;
            xo.gatherOutputProperties(details, precedences, decl.getPrecedence());
        }
        if (!found) {
            this.compileError("Requested output format " + formatQName.getDisplayName() + " has not been defined", "XTDE1460");
        }
        return details;
    }

    protected void compile(Compilation compilation) throws XPathException {
        block20: {
            try {
                StyleElement node;
                StyleElement snode;
                Configuration config = this.getConfiguration();
                try {
                    Iterator<XQueryFunction> qf = this.queryFunctions.getFunctionDefinitions();
                    while (qf.hasNext()) {
                        XQueryFunction xQueryFunction = qf.next();
                        xQueryFunction.fixupReferences();
                    }
                }
                catch (XPathException e) {
                    this.getRootElement().compileError(e);
                }
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    snode = componentDeclaration.getSourceElement();
                    if (!(snode instanceof XSLTemplate)) continue;
                    ((XSLTemplate)snode).register(componentDeclaration);
                }
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    snode = componentDeclaration.getSourceElement();
                    if (snode.isActionCompleted(2)) continue;
                    snode.setActionCompleted(2);
                    snode.compileDeclaration(compilation, componentDeclaration);
                }
                for (ComponentDeclaration componentDeclaration : this.functionIndex.values()) {
                    node = componentDeclaration.getSourceElement();
                    if (node.isActionCompleted(4)) continue;
                    node.setActionCompleted(4);
                    ((XSLFunction)node).typeCheckBody();
                }
                if (compilation.getErrorCount() > 0) {
                    return;
                }
                this.optimizeTopLevel();
                for (ComponentDeclaration componentDeclaration : this.functionIndex.values()) {
                    node = componentDeclaration.getSourceElement();
                    if (node.isActionCompleted(8)) continue;
                    node.setActionCompleted(8);
                    ((StylesheetComponent)((Object)node)).optimize(componentDeclaration);
                }
                if (config.isTiming() && config.isGenerateByteCode(50)) {
                    config.getStandardErrorOutput().println("Generating byte code...");
                }
                this.getDecimalFormatManager().checkConsistency();
                this.overriding = new ExecutableFunctionLibrary(config);
                this.underriding = new ExecutableFunctionLibrary(config);
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    if (!(componentDeclaration.getSourceElement() instanceof XSLFunction)) continue;
                    XSLFunction func = (XSLFunction)componentDeclaration.getSourceElement();
                    if (func.isOverrideExtensionFunction()) {
                        this.overriding.addFunction(func.getCompiledFunction());
                        continue;
                    }
                    this.underriding.addFunction(func.getCompiledFunction());
                }
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    ComponentBody componentBody;
                    StyleElement inst = componentDeclaration.getSourceElement();
                    if (!(inst instanceof StylesheetComponent) || (componentBody = ((StylesheetComponent)((Object)inst)).getCompiledProcedure()) == null) continue;
                    componentBody.allocateAllBindingSlots(this);
                }
                for (Component component : this.componentIndex.values()) {
                    ComponentBody proc = component.getProcedure();
                    if (proc == null || !(proc instanceof GlobalVariable) || !((GlobalVariable)proc).getVariableQName().hasURI("http://saxon.sf.net/generated-global-variable")) continue;
                    proc.allocateAllBindingSlots(this);
                }
                KeyManager keyMan = this.getKeyManager();
                for (KeyDefinitionSet keySet : keyMan.getAllKeyDefinitionSets()) {
                    if (!keySet.getKeyName().hasURI("http://saxon.sf.net/")) continue;
                    for (KeyDefinition keyDef : keySet.getKeyDefinitions()) {
                        keyDef.makeDeclaringComponent(Visibility.PRIVATE, this);
                        keyDef.allocateAllBindingSlots(this);
                    }
                }
                IAccumulatorManager iAccumulatorManager = this.getAccumulatorManager();
                if (iAccumulatorManager != null) {
                    for (ComponentBody componentBody : iAccumulatorManager.getAllAccumulators()) {
                        componentBody.allocateAllBindingSlots(this);
                    }
                }
                Optimizer opt = config.obtainOptimizer();
                for (ComponentDeclaration decl : this.topLevel) {
                    StyleElement inst = decl.getSourceElement();
                    if (!(inst instanceof StylesheetComponent)) continue;
                    ((StylesheetComponent)((Object)inst)).generateByteCode(opt);
                }
            }
            catch (RuntimeException err) {
                if (compilation.getErrorCount() != 0) break block20;
                throw err;
            }
        }
    }

    public void optimizeTopLevel() throws XPathException {
        for (ComponentDeclaration decl : this.topLevel) {
            StyleElement node = decl.getSourceElement();
            if (node instanceof StylesheetComponent && !(node instanceof XSLFunction) && !node.isActionCompleted(8)) {
                node.setActionCompleted(8);
                ((StylesheetComponent)((Object)node)).optimize(decl);
            }
            if (!(node instanceof XSLTemplate)) continue;
            ((XSLTemplate)node).allocatePatternSlotNumbers();
        }
    }

    public void updatePreparedStylesheet(PreparedStylesheet pss) throws XPathException {
        GlobalVariable gv;
        pss.setStylesheetFunctionLibrary(this.stylesheetFunctionLibrary);
        FunctionLibraryList libraryList = new FunctionLibraryList();
        for (FunctionLibrary lib : this.functionLibrary.getLibraryList()) {
            if (lib instanceof StylesheetFunctionLibrary) {
                if (((StylesheetFunctionLibrary)lib).isOverrideExtensionFunction()) {
                    libraryList.addFunctionLibrary(this.overriding);
                    pss.getStylesheetFunctions().addFunctionLibrary(this.overriding);
                    continue;
                }
                libraryList.addFunctionLibrary(this.underriding);
                pss.getStylesheetFunctions().addFunctionLibrary(this.underriding);
                continue;
            }
            libraryList.addFunctionLibrary(lib);
        }
        pss.setFunctionLibrary(libraryList);
        pss.setKeyManager(this.keyManager);
        pss.setAccumulatorManager(this.accumulatorManager);
        pss.setStripsWhitespace(this.stripsWhitespace());
        pss.setPatternSlotSpace(this.largestPatternStackFrame);
        pss.setStripsInputTypeAnnotations(this.getInputTypeAnnotations() == 1);
        pss.setStripperRules(this.stripperRules);
        pss.setCreatesSecondaryResult(this.createsSecondaryResultDocuments);
        for (ComponentDeclaration decl : this.topLevel) {
            XSLCharacterMap t;
            if (!(decl.getSourceElement() instanceof XSLCharacterMap) || (t = (XSLCharacterMap)decl.getSourceElement()).isRedundant()) continue;
            StructuredQName structuredQName = t.getCharacterMapName();
            IntHashMap<String> charMap = new IntHashMap<String>();
            t.assemble(charMap);
            CharacterMap map = new CharacterMap(charMap);
            if (pss.getCharacterMapIndex() == null) {
                pss.setCharacterMapIndex(new CharacterMapIndex());
            }
            pss.getCharacterMapIndex().putCharacterMap(structuredQName, map);
        }
        this.ruleManager.computeRankings();
        this.ruleManager.invertStreamableTemplates(this.getConfiguration().obtainOptimizer());
        pss.setRuleManager(this.ruleManager);
        Properties props = this.gatherOutputProperties(null);
        props.setProperty("{http://saxon.sf.net/}stylesheet-version", this.getVersion().getStringValue());
        pss.setDefaultOutputProperties(props);
        HashSet<StructuredQName> outputNames = new HashSet<StructuredQName>(5);
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            XSLOutput out;
            StructuredQName qName;
            if (!(componentDeclaration.getSourceElement() instanceof XSLOutput) || (qName = (out = (XSLOutput)componentDeclaration.getSourceElement()).getFormatQName()) == null) continue;
            outputNames.add(qName);
        }
        if (outputNames.isEmpty()) {
            if (this.needsDynamicOutputProperties) {
                throw new XPathException("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations", "XTDE1460");
            }
        } else {
            for (StructuredQName structuredQName : outputNames) {
                Properties oprops = this.gatherOutputProperties(structuredQName);
                if (!this.needsDynamicOutputProperties) continue;
                pss.setOutputProperties(structuredQName, oprops);
            }
        }
        for (Map.Entry entry : this.templateIndex.entrySet()) {
            pss.putNamedTemplate((StructuredQName)entry.getKey(), ((XSLTemplate)((ComponentDeclaration)entry.getValue()).getSourceElement()).getCompiledTemplate());
        }
        pss.setComponentIndex(this.componentIndex);
        for (Component component : this.componentIndex.values()) {
            if (!(component.getProcedure() instanceof GlobalVariable)) continue;
            gv = (GlobalVariable)component.getProcedure();
            pss.registerGlobalVariable(gv);
            if (gv.isUnused()) continue;
            int slot = pss.getGlobalVariableMap().allocateSlotNumber(gv.getVariableQName());
            gv.setBinderySlotNumber(slot);
        }
        for (Component component : this.hiddenComponents) {
            if (!(component.getProcedure() instanceof GlobalVariable)) continue;
            gv = (GlobalVariable)component.getProcedure();
            pss.registerGlobalVariable(gv);
            if (gv.isUnused()) continue;
            int slot = pss.getGlobalVariableMap().allocateSlotNumber(gv.getVariableQName());
            gv.setBinderySlotNumber(slot);
        }
        for (StylesheetPackage stylesheetPackage : this.usedPackages) {
        }
        this.topLevel = null;
        this.templateIndex = null;
        this.completionActions = null;
    }

    protected boolean isImportedSchema(String targetNamespace) {
        return this.schemaIndex.contains(targetNamespace);
    }

    protected void addImportedSchema(String targetNamespace) {
        this.schemaIndex.add(targetNamespace);
    }

    protected HashSet<String> getImportedSchemaTable() {
        return this.schemaIndex;
    }

    protected boolean getAttributeSets(StructuredQName name, List<ComponentDeclaration> list) throws XPathException {
        boolean found = false;
        for (ComponentDeclaration decl : this.topLevel) {
            XSLAttributeSet t;
            if (!(decl.getSourceElement() instanceof XSLAttributeSet) || !(t = (XSLAttributeSet)decl.getSourceElement()).getAttributeSetName().equals(name)) continue;
            t.incrementReferenceCount();
            list.add(decl);
            found = true;
        }
        return found;
    }

    public boolean stripsWhitespace() {
        for (ComponentDeclaration aTopLevel : this.topLevel) {
            StyleElement s = aTopLevel.getSourceElement();
            if (s.getFingerprint() != 198) continue;
            return true;
        }
        return false;
    }

    public void setStripperRules(SpaceStrippingRule rules) {
        this.stripperRules = rules;
    }

    public SpaceStrippingRule getStripperRules() {
        return this.stripperRules == null ? NoElementsSpaceStrippingRule.getInstance() : this.stripperRules;
    }

    public void setNeedsDynamicOutputProperties(boolean b) {
        this.needsDynamicOutputProperties = b;
    }

    public ComponentDeclaration getCharacterMap(StructuredQName name) {
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            XSLCharacterMap t;
            ComponentDeclaration decl = (ComponentDeclaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLCharacterMap) || !(t = (XSLCharacterMap)decl.getSourceElement()).getCharacterMapName().equals(name)) continue;
            return decl;
        }
        return null;
    }

    public void allocatePatternSlots(int n) {
        if (n > this.largestPatternStackFrame) {
            this.largestPatternStackFrame = n;
        }
    }

    protected void compileError(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        this.compileError(tce);
    }

    protected void compileError(XPathException error) throws XPathException {
        error.setIsStaticError(true);
        this.getRootElement().compileError(error);
    }

    public void addUsedPackage(StylesheetPackage pack) throws XPathException {
        this.usedPackages.add(pack);
        for (Map.Entry<SymbolicName, Component> e : pack.componentIndex.entrySet()) {
            Component c = e.getValue();
            Visibility oldV = c.getVisibility();
            Visibility newV = oldV == Visibility.PRIVATE ? Visibility.HIDDEN : oldV;
            final Component d = new Component(c.getProcedure(), newV, this, c.getDeclaringPackage());
            d.setOriginalComponent(c);
            d.setComponentBindings(c.getComponentBindings());
            if (newV == Visibility.HIDDEN) {
                this.hiddenComponents.add(d);
            } else if (this.componentIndex.get(e.getKey()) != null) {
                XPathException err = new XPathException("Duplicate " + e.getKey(), "XTSE3050");
                err.setLocator(c.getProcedure());
                this.compileError(err);
            } else {
                this.componentIndex.put(e.getKey(), d);
            }
            this.addCompletionAction(new Action(){

                public void doAction() throws XPathException {
                    List<ComponentBinding> bindings = d.getComponentBindings();
                    ArrayList<ComponentBinding> newBindings = new ArrayList<ComponentBinding>(bindings.size());
                    for (ComponentBinding binding : bindings) {
                        Visibility vis = binding.getTarget().getVisibility();
                        block0 : switch (vis) {
                            case ABSTRACT: 
                            case PUBLIC: {
                                SymbolicName name = binding.getSymbolicName();
                                ComponentBinding b2 = new ComponentBinding(name);
                                b2.setTarget((Component)StylesheetPackage.this.componentIndex.get(name), false);
                                newBindings.add(b2);
                                break;
                            }
                            case FINAL: {
                                newBindings.add(binding);
                                break;
                            }
                            case PRIVATE: {
                                SymbolicName name = binding.getSymbolicName();
                                ComponentBinding b2 = new ComponentBinding(name);
                                for (Component c : StylesheetPackage.this.hiddenComponents) {
                                    if (c.getOriginalComponent() != binding.getTarget()) continue;
                                    b2.setTarget(c, true);
                                    newBindings.add(b2);
                                    break block0;
                                }
                                break;
                            }
                        }
                    }
                    d.setComponentBindings(newBindings);
                }
            });
        }
        if (pack.isCreatesSecondaryResultDocuments()) {
            this.setCreatesSecondaryResultDocuments(true);
        }
    }

    public Iterable<StylesheetPackage> getUsedPackages() {
        return this.usedPackages;
    }

    public void setVersion(DecimalValue version) {
        this.version = version;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public DecimalValue getVersion() {
        return this.version;
    }

    public PackageVersion getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(PackageVersion version) {
        this.packageVersion = version;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isRootPackage() {
        return true;
    }

    protected void fixup() throws XPathException {
        for (Action a : this.fixupActions) {
            a.doAction();
        }
    }

    protected void complete() throws XPathException {
        for (Action a : this.completionActions) {
            a.doAction();
        }
    }

    public void explain(ExpressionPresenter presenter) {
        presenter.startElement("package");
        presenter.emitAttribute("name", this.packageName);
        presenter.emitAttribute("version", this.version.getStringValue());
        if (this.packageVersion != null) {
            presenter.emitAttribute("package-version", this.packageVersion.getStringValue());
        }
        presenter.endElement();
    }

    public SlotManager getSlotManager() {
        return null;
    }

    @Override
    public Collection<StructuredQName> getGlobalVariableNames() {
        return this.globalVariableIndex.keySet();
    }

    @Override
    public GlobalVariable getGlobalVariable(StructuredQName name) {
        ComponentDeclaration decl = this.globalVariableIndex.get(name);
        if (decl != null) {
            return ((XSLGlobalVariable)decl.getSourceElement()).getCompiledVariable();
        }
        return null;
    }

    @Override
    public void addGlobalVariable(GlobalVariable variable) {
        variable.makeDeclaringComponent(Visibility.PRIVATE, this);
        if (variable.getPackageData() == null) {
            variable.setPackageData(this.makePackageData());
        }
        this.componentIndex.put(new SymbolicName(206, variable.getVariableQName()), variable.getDeclaringComponent());
    }

    private PackageData makePackageData() {
        PackageData pd = new PackageData(this.getConfiguration());
        pd.setAllowXPath30(false);
        pd.setHostLanguage(50);
        return pd;
    }

    public void setCreatesSecondaryResultDocuments(boolean flag) {
        this.createsSecondaryResultDocuments = flag;
    }

    public boolean isCreatesSecondaryResultDocuments() {
        return this.createsSecondaryResultDocuments;
    }

    public static abstract class Action {
        public abstract void doAction() throws XPathException;
    }
}

