/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.util.SpringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.test.MockExternalContext;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String[] CONFIG_FILES = new String[]{"internal.xml", "webflow-config.xml"};
    private static final CommandLineArgs COMMAND_LINE_ARGS = new CommandLineArgs();

    private Main() {
    }

    public static void main(@Nonnull String[] args) {
        MockExternalContext mockCtx;
        JCommander jc = new JCommander((Object)COMMAND_LINE_ARGS, args);
        if (COMMAND_LINE_ARGS.help) {
            jc.setProgramName(Main.class.getName());
            jc.usage();
            return;
        }
        ApplicationContext appCtx = Main.buildApplicationContext();
        FlowExecutor flowExecutor = (FlowExecutor)appCtx.getBean("flowExecutor", FlowExecutor.class);
        FlowExecutionResult result = flowExecutor.launchExecution("cli-flow", null, (ExternalContext)(mockCtx = new MockExternalContext()));
        if (result.isEnded()) {
            if ("end".equals(result.getOutcome().getId())) {
                System.out.print(mockCtx.getMockResponseWriter().toString());
            } else {
                System.err.println("Flow did not end successfully.");
            }
        } else {
            System.err.println("Flow did not end.");
        }
    }

    private static ApplicationContext buildApplicationContext() {
        File configDirectory = new File(COMMAND_LINE_ARGS.configDir);
        if (!(configDirectory.exists() && configDirectory.isDirectory() && configDirectory.canRead())) {
            Main.errorAndExit("Configuration directory " + configDirectory + " does not exist, is not a directory, or is not readable", null);
        }
        ArrayList<String> configNames = new ArrayList<String>();
        for (String cfile : CONFIG_FILES) {
            configNames.add(cfile);
        }
        configNames.addAll(COMMAND_LINE_ARGS.springExts);
        ArrayList<FileSystemResource> configs = new ArrayList<FileSystemResource>();
        for (String cfile : configNames) {
            File config = cfile.startsWith(File.separator) ? new File(cfile) : new File(configDirectory.getPath() + File.separator + cfile);
            if (config.isDirectory() || !config.canRead()) {
                Main.errorAndExit("Configuration file " + config.getAbsolutePath() + " is a directory or is not readable", null);
            }
            FileSystemResource r = new FileSystemResource(config.getPath());
            configs.add(r);
        }
        return SpringSupport.newContext((String)Main.class.getName(), configs, Collections.emptyList(), null);
    }

    private static void errorAndExit(@Nonnull String errorMessage, @Nullable Exception e) {
        if (e == null) {
            LOG.error(errorMessage);
        } else {
            LOG.error(errorMessage, (Throwable)e);
        }
        System.out.flush();
        System.exit(1);
    }

    private static class CommandLineArgs {
        public static final String HELP = "--help";
        public static final String CONFIG_DIR = "--configDir";
        public static final String SPRING_EXT = "--springExt";
        public static final String REQUESTER = "--requester";
        public static final String ISSUER = "--issuer";
        public static final String PRINCIPAL = "--principal";
        public static final String AUTHN_METHOD = "--authnMethod";
        public static final String INTERNAL_ENC = "--internal";
        public static final String SAML1_ENC = "--saml1";
        public static final String SAML2_ENC = "--saml2";
        @Parameter(names={"--help"}, description="Display program usage", help=true)
        private boolean help;
        @Parameter(names={"--configDir"}, description="Configuration directory")
        private String configDir = System.getenv("IDP_HOME") + "/conf";
        @Parameter(names={"--springExt"}, description="Spring extension file to load")
        private List<String> springExts = new ArrayList<String>();
        @Parameter(names={"--requester"}, description="Attribute requester identity")
        private String requester;
        @Parameter(names={"--issuer"}, description="Attribute issuer identity")
        private String issuer;
        @Parameter(names={"--principal"}, required=false, description="Identity of attribute subject")
        private String principal;
        @Parameter(names={"--authnMethod"}, description="Authentication method of attribute subject")
        private String authnMethod;
        @Parameter(names={"--internal"}, description="Show results without external encoding")
        private boolean internalEncoding;
        @Parameter(names={"--saml1"}, description="Show results with SAML 1.1 encoding")
        private boolean saml1Encoding;
        @Parameter(names={"--saml2"}, description="Show results with SAML 2.0 encoding")
        private boolean saml2Encoding = true;

        private CommandLineArgs() {
        }
    }
}

