/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.cli;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class OutputAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OutputAttributes.class);

    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        AttributeContext attributeContext = (AttributeContext)profileRequestContext.getSubcontext(AttributeContext.class, false);
        if (attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return ActionSupport.buildEvent((Object)((Object)this), (String)"InvalidAttributeContext");
        }
        try {
            Writer writer = springRequestContext.getExternalContext().getResponseWriter();
            for (IdPAttribute a : attributeContext.getIdPAttributes().values()) {
                writer.write("Attribute: " + a.getId() + "\n");
                if (a.getDisplayNames().containsKey(Locale.getDefault())) {
                    writer.write("\tDisplay name: " + (String)a.getDisplayNames().get(Locale.getDefault()) + "\n");
                }
                if (!a.getValues().isEmpty()) {
                    writer.write("\tValues:\n");
                    for (IdPAttributeValue av : a.getValues()) {
                        writer.write("\t\t" + av.getValue().toString() + "\n");
                    }
                    continue;
                }
                writer.write("\t(no values)\n");
            }
        }
        catch (IOException e) {
            this.log.error(this.getLogPrefix() + " I/O error writing attributes to output context", (Throwable)e);
            return ActionSupport.buildEvent((Object)((Object)this), (String)"InputOutputError");
        }
        return ActionSupport.buildProceedEvent((Object)((Object)this));
    }
}

