/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.UnsupportedAttributeTypeException;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RegexSplitAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegexSplitAttributeDefinition.class);
    @Nullable
    private Pattern regexp;

    @Nullable
    @NonnullAfterInit
    public Pattern getRegularExpression() {
        return this.regexp;
    }

    public void setRegularExpression(@Nonnull Pattern expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.regexp = (Pattern)Constraint.isNotNull((Object)expression, (String)"Regular expression cannot be null");
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ArrayList<IdPAttributeValue> resultantValues = new ArrayList<IdPAttributeValue>();
        IdPAttribute resultantAttribute = new IdPAttribute(this.getId());
        List dependencyValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies());
        for (IdPAttributeValue dependencyValue : dependencyValues) {
            if (!(dependencyValue instanceof StringAttributeValue)) {
                throw new ResolutionException((Exception)new UnsupportedAttributeTypeException(this.getLogPrefix() + "This attribute definition only operates on attribute values of type " + StringAttributeValue.class.getName() + "; was given " + dependencyValue.getClass().getName()));
            }
            this.log.debug("{} Applying regexp '{}' to input value '{}'", new Object[]{this.getLogPrefix(), this.regexp.pattern(), dependencyValue.getValue()});
            Matcher matcher = this.regexp.matcher((String)dependencyValue.getValue());
            if (matcher.matches()) {
                this.log.debug("{} Computed the value '{}' by apply regexp '{}' to input value '{}'", new Object[]{this.getLogPrefix(), matcher.group(1), this.regexp.pattern(), dependencyValue.getValue()});
                resultantValues.add(StringAttributeValue.valueOf((String)matcher.group(1)));
                continue;
            }
            this.log.debug("{} Regexp '{}' did not match anything in input value '{}'", new Object[]{this.getLogPrefix(), this.regexp.pattern(), dependencyValue.getValue()});
        }
        if (!resultantValues.isEmpty()) {
            resultantAttribute.setValues(resultantValues);
        }
        return resultantAttribute;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.regexp) {
            throw new ComponentInitializationException("Attribute definition '" + this.getId() + "': no regular expression was configured");
        }
        if (this.getDependencies().isEmpty()) {
            throw new ComponentInitializationException("Attribute definition '" + this.getId() + "': no dependencies were configured");
        }
    }
}

