/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.UnsupportedAttributeTypeException;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@ThreadSafe
public class ScopedAttributeDefinition
extends AbstractAttributeDefinition {
    @NonnullAfterInit
    private String scope;

    @NonnullAfterInit
    public String getScope() {
        return this.scope;
    }

    public void setScope(@Nonnull @NotEmpty String newScope) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scope = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newScope), (String)"Scope can not be null or empty");
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        IdPAttribute resultantAttribute = new IdPAttribute(this.getId());
        List dependencyValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies());
        ArrayList<ScopedStringAttributeValue> valueList = new ArrayList<ScopedStringAttributeValue>(dependencyValues.size());
        for (IdPAttributeValue dependencyValue : dependencyValues) {
            if (!(dependencyValue instanceof StringAttributeValue)) {
                throw new ResolutionException((Exception)new UnsupportedAttributeTypeException(this.getLogPrefix() + "This attribute definition only supports attribute value types of " + StringAttributeValue.class.getName() + " not values of type " + dependencyValue.getClass().getName()));
            }
            valueList.add(new ScopedStringAttributeValue((String)dependencyValue.getValue(), this.scope));
        }
        resultantAttribute.setValues(valueList);
        return resultantAttribute;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.scope) {
            throw new ComponentInitializationException(this.getLogPrefix() + "': no scope was configured");
        }
        if (this.getDependencies().isEmpty()) {
            throw new ComponentInitializationException(this.getLogPrefix() + "': no dependencies were configured");
        }
    }
}

