/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import com.google.common.base.Function;
import edu.internet2.middleware.shibboleth.common.attribute.provider.V2SAMLProfileRequestContext;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedIdPAttributeImpl;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScriptedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedAttributeDefinition.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> prcLookupStrategy = new ParentContextLookup();

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript definitionScript) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.script = (EvaluableScript)Constraint.isNotNull((Object)definitionScript, (String)"Attribute definition script cannot be null");
    }

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.prcLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no script was configured");
        }
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)resolutionContext, (String)"AttributeResolutionContext cannot be null");
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        ScriptContext context = this.getScriptContext(resolutionContext, workContext);
        try {
            this.script.eval(context);
        }
        catch (ScriptException e) {
            throw new ResolutionException(this.getLogPrefix() + " unable to execute script", (Exception)e);
        }
        Object result = context.getAttribute(this.getId());
        if (null == result) {
            this.log.info("{} no value returned", (Object)this.getLogPrefix());
            return null;
        }
        if (result instanceof ScriptedIdPAttributeImpl) {
            ScriptedIdPAttributeImpl scriptedAttribute = (ScriptedIdPAttributeImpl)result;
            return scriptedAttribute.getResultingAttribute();
        }
        throw new ResolutionException(this.getLogPrefix() + " returned variable was of wrong type (" + result.getClass().toString() + ")");
    }

    @Nonnull
    private ScriptContext getScriptContext(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        Map dependencyAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies());
        if (dependencyAttributes.containsKey(this.getId())) {
            this.log.debug("{} to-be-populated attribute is a dependency.  Not created", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} adding to-be-populated attribute to script context", (Object)this.getLogPrefix());
            IdPAttribute newAttribute = new IdPAttribute(this.getId());
            scriptContext.setAttribute(this.getId(), new ScriptedIdPAttributeImpl(newAttribute, this.getLogPrefix()), 100);
        }
        this.log.debug("{} adding contexts to script context", (Object)this.getLogPrefix());
        scriptContext.setAttribute("resolutionContext", resolutionContext, 100);
        scriptContext.setAttribute("workContext", workContext, 100);
        ProfileRequestContext prc = (ProfileRequestContext)this.prcLookupStrategy.apply((Object)resolutionContext);
        if (null == prc) {
            this.log.error("{} ProfileRequestContext could not be located", (Object)this.getLogPrefix());
        }
        scriptContext.setAttribute("profileContext", prc, 100);
        this.log.debug("{} adding emulated V2 request context to script context", (Object)this.getLogPrefix());
        scriptContext.setAttribute("requestContext", new V2SAMLProfileRequestContext(resolutionContext, this.getId()), 100);
        for (Map.Entry dependencyAttribute : dependencyAttributes.entrySet()) {
            this.log.debug("{} adding dependent attribute '{}' with the following values to the script context: {}", new Object[]{this.getLogPrefix(), dependencyAttribute.getKey(), dependencyAttribute.getValue()});
            IdPAttribute pseudoAttribute = new IdPAttribute((String)dependencyAttribute.getKey());
            pseudoAttribute.setValues((Collection)dependencyAttribute.getValue());
            scriptContext.setAttribute((String)dependencyAttribute.getKey(), new ScriptedIdPAttributeImpl(pseudoAttribute, this.getLogPrefix()), 100);
        }
        return scriptContext;
    }
}

