/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StaticAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StaticAttributeDefinition.class);
    @NonnullAfterInit
    private IdPAttribute value;

    public void setValue(@Nullable IdPAttribute newAttribute) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.value = newAttribute;
    }

    @NonnullAfterInit
    public IdPAttribute getValue() {
        return this.value;
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.log.debug("{} resolving static attribute {}", (Object)this.getLogPrefix(), (Object)this.value);
        return this.value;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.value) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no attribute value set");
        }
    }
}

