/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.dc.MappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.impl.ExecutableSearch;
import net.shibboleth.idp.attribute.resolver.dc.impl.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.impl.Validator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchDataConnector<T extends ExecutableSearch>
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSearchDataConnector.class);
    private ExecutableSearchBuilder<T> searchBuilder;
    private Validator connectorValidator;
    private MappingStrategy mappingStrategy;
    private Cache<String, Map<String, IdPAttribute>> resultsCache;

    public ExecutableSearchBuilder<T> getExecutableSearchBuilder() {
        return this.searchBuilder;
    }

    public void setExecutableSearchBuilder(@Nonnull ExecutableSearchBuilder<T> builder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.searchBuilder = (ExecutableSearchBuilder)Constraint.isNotNull(builder, (String)"Executable search builder can not be null");
    }

    public Validator getValidator() {
        return this.connectorValidator;
    }

    public void setValidator(@Nonnull Validator validator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.connectorValidator = (Validator)Constraint.isNotNull((Object)validator, (String)"Validator can not be null");
    }

    public MappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(@Nonnull MappingStrategy strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.mappingStrategy = (MappingStrategy)Constraint.isNotNull((Object)strategy, (String)"Mapping strategy can not be null");
    }

    @Nonnull
    public Cache<String, Map<String, IdPAttribute>> getResultsCache() {
        return this.resultsCache;
    }

    public void setResultsCache(@Nullable Cache<String, Map<String, IdPAttribute>> cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (cache != null) {
            cache.invalidateAll();
        }
        this.resultsCache = cache;
    }

    @Nullable
    protected abstract Map<String, IdPAttribute> retrieveAttributes(@Nonnull T var1) throws ResolutionException;

    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Map dependsAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies());
        T executable = this.searchBuilder.build(resolutionContext, dependsAttributes);
        Map<String, IdPAttribute> resolvedAttributes = null;
        if (this.resultsCache != null) {
            String cacheKey = executable.getResultCacheKey();
            resolvedAttributes = (Map<String, IdPAttribute>)this.resultsCache.getIfPresent((Object)cacheKey);
            this.log.trace("{} Cache found, resolved attributes {} using cache {}", new Object[]{this.getLogPrefix(), resolvedAttributes, this.resultsCache});
            if (resolvedAttributes == null) {
                resolvedAttributes = this.retrieveAttributes(executable);
                this.log.trace("{} Resolved attributes {}", (Object)this.getLogPrefix(), resolvedAttributes);
                this.resultsCache.put((Object)cacheKey, resolvedAttributes != null ? resolvedAttributes : Collections.emptyMap());
            }
        } else {
            resolvedAttributes = this.retrieveAttributes(executable);
            this.log.trace("{} Resolved attributes: {}", (Object)this.getLogPrefix(), (Object)resolvedAttributes);
        }
        return resolvedAttributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.searchBuilder == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No executable search builder was configured");
        }
        if (this.connectorValidator == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No validator was configured");
        }
        if (this.mappingStrategy == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No mapping strategy was configured");
        }
    }
}

