/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.impl.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.impl.Validator;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ExecutableSearchFilter;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.StringAttributeValueMappingStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPDataConnector
extends AbstractSearchDataConnector<ExecutableSearchFilter> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPDataConnector.class);
    private ConnectionFactory connectionFactory;
    private SearchExecutor searchExecutor;

    public LDAPDataConnector() {
        this.setValidator(new DefaultValidator());
        this.setMappingStrategy(new StringAttributeValueMappingStrategy());
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(@Nonnull ConnectionFactory factory) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.connectionFactory = (ConnectionFactory)Constraint.isNotNull((Object)factory, (String)"LDAP connection factory can not be null");
    }

    public SearchExecutor getSearchExecutor() {
        return this.searchExecutor;
    }

    public void setSearchExecutor(@Nonnull SearchExecutor executor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.searchExecutor = (SearchExecutor)Constraint.isNotNull((Object)executor, (String)"LDAP search executor can not be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.connectionFactory == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No connection factory was configured");
        }
        if (this.searchExecutor == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No search executor was configured");
        }
        try {
            this.getValidator().validate();
        }
        catch (ValidationException e) {
            this.log.error("{} Invalid connector configuration", (Object)this.getLogPrefix(), (Object)e);
            throw new ComponentInitializationException(this.getLogPrefix() + " Invalid connector configuration", (Exception)e);
        }
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> retrieveAttributes(ExecutableSearchFilter filter) throws ResolutionException {
        if (filter == null) {
            throw new ResolutionException(this.getLogPrefix() + " Search filter cannot be null");
        }
        try {
            SearchResult result = filter.execute(this.searchExecutor, this.connectionFactory);
            this.log.trace("{} Search returned {}", (Object)this.getLogPrefix(), (Object)result);
            return this.getMappingStrategy().map((Object)result);
        }
        catch (LdapException e) {
            throw new ResolutionException(this.getLogPrefix() + " Unable to execute LDAP search", (Exception)((Object)e));
        }
    }

    public class SearchValidator
    implements Validator {
        private final SearchFilter validateFilter;

        public SearchValidator(SearchFilter filter) {
            this.validateFilter = filter;
        }

        @Override
        public void validate() throws ValidationException {
            try {
                LDAPDataConnector.this.searchExecutor.search(LDAPDataConnector.this.connectionFactory, this.validateFilter);
            }
            catch (LdapException e) {
                throw new ValidationException((Exception)((Object)e));
            }
        }
    }

    public class DefaultValidator
    implements Validator {
        @Override
        public void validate() throws ValidationException {
            try (Connection connection = null;){
                connection = LDAPDataConnector.this.connectionFactory.getConnection();
                if (connection == null) {
                    throw new LdapException(LDAPDataConnector.this.getLogPrefix() + " Unable to retrieve connection from connection factory");
                }
                connection.open();
            }
        }
    }
}

