/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import edu.internet2.middleware.shibboleth.common.attribute.provider.V2SAMLProfileRequestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.AbstractExecutableStatementBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.velocity.Template;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatedExecutableStatementBuilder
extends AbstractExecutableStatementBuilder {
    private final Logger log = LoggerFactory.getLogger(TemplatedExecutableStatementBuilder.class);
    private Template template;
    private String templateText;
    private VelocityEngine engine;
    private ReferenceInsertionEventHandler eventHandler = new EscapingReferenceInsertionEventHandler();
    private boolean v2Compatibility;

    @NonnullAfterInit
    public Template getTemplate() {
        return this.template;
    }

    @NonnullAfterInit
    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(@Nullable String velocityTemplate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.templateText = StringSupport.trimOrNull((String)velocityTemplate);
    }

    @Nullable
    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(@Nonnull VelocityEngine velocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.engine = velocityEngine;
    }

    @Nullable
    public ReferenceInsertionEventHandler getReferenceInsertionEventHandler() {
        return this.eventHandler;
    }

    public void setReferenceInsertionEventHandler(@Nullable ReferenceInsertionEventHandler handler) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.eventHandler = handler;
    }

    public boolean isV2Compatibility() {
        return this.v2Compatibility;
    }

    public void setV2Compatibility(boolean compat) {
        this.v2Compatibility = compat;
    }

    protected String merge(@Nonnull VelocityContext context) {
        String result = this.template.merge((Context)context);
        this.log.debug("Template text {} yields {}", (Object)this.templateText, (Object)result);
        return result;
    }

    @Override
    protected String getSQLQuery(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) {
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating search filter using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        if (this.isV2Compatibility()) {
            V2SAMLProfileRequestContext requestContext = new V2SAMLProfileRequestContext(resolutionContext, null);
            this.log.trace("Adding v2 request context {}", (Object)requestContext);
            context.put("requestContext", (Object)requestContext);
        }
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue<?>>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue<?> value : entry.getValue()) {
                    values.add(value.getValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        if (this.eventHandler != null) {
            EventCartridge cartridge = new EventCartridge();
            cartridge.addEventHandler((EventHandler)this.eventHandler);
            cartridge.attachToContext((Context)context);
        }
        return this.merge(context);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.engine) {
            throw new ComponentInitializationException("TemplatedExecutableStatementBuilder: no velocity engine was configured");
        }
        if (null == this.templateText) {
            throw new ComponentInitializationException("TemplatedExecutableStatementBuilder: no template text must be non null");
        }
        this.template = Template.fromTemplate((VelocityEngine)this.engine, (String)this.templateText);
    }

    protected static class EscapingReferenceInsertionEventHandler
    implements ReferenceInsertionEventHandler {
        protected EscapingReferenceInsertionEventHandler() {
        }

        public Object referenceInsert(String reference, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Object[]) {
                ArrayList<Object> encodedValues = new ArrayList<Object>();
                for (Object o : (Object[])value) {
                    encodedValues.add(this.encode(o));
                }
                return encodedValues.toArray();
            }
            if (value instanceof Collection) {
                ArrayList<Object> encodedValues = new ArrayList<Object>();
                for (Object o : (Collection)value) {
                    encodedValues.add(this.encode(o));
                }
                return encodedValues;
            }
            return this.encode(value);
        }

        private Object encode(Object value) {
            if (value instanceof String) {
                return StringEscapeUtils.escapeSql((String)((String)value));
            }
            return value;
        }
    }
}

