/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.LegacyPrincipalDecoder;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolvedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolvedDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AttributeResolverImpl
extends AbstractServiceableComponent<AttributeResolver>
implements AttributeResolver,
LegacyPrincipalDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverImpl.class);
    @Nonnull
    private final Map<String, AttributeDefinition> attributeDefinitions;
    @Nonnull
    private final Map<String, DataConnector> dataConnectors;
    @NonnullAfterInit
    private final String logPrefix;
    @Nullable
    private final LegacyPrincipalDecoder principalConnector;

    public AttributeResolverImpl(@Nonnull @NotEmpty String resolverId, @Nullable @NullableElements Collection<AttributeDefinition> definitions, @Nullable @NullableElements Collection<DataConnector> connectors, @Nullable LegacyPrincipalDecoder principalResolver) {
        Map<String, DataConnector> checkedConnectors;
        Map<String, AttributeDefinition> checkedDefinitions;
        this.setId(resolverId);
        this.logPrefix = "Attribute Resolver '" + this.getId() + "':";
        if (definitions != null) {
            checkedDefinitions = new HashMap(definitions.size());
            for (AttributeDefinition definition : definitions) {
                if (definition == null) continue;
                if (checkedDefinitions.containsKey(definition.getId())) {
                    throw new IllegalArgumentException(this.logPrefix + " Duplicate Attribute Definition with id '" + definition.getId() + "'");
                }
                checkedDefinitions.put(definition.getId(), definition);
            }
        } else {
            checkedDefinitions = Collections.emptyMap();
        }
        this.attributeDefinitions = ImmutableMap.copyOf(checkedDefinitions);
        if (connectors != null) {
            checkedConnectors = new HashMap(connectors.size());
            for (DataConnector connector : connectors) {
                if (connector == null) continue;
                if (checkedConnectors.containsKey(connector.getId())) {
                    throw new IllegalArgumentException(this.logPrefix + " Duplicate Data Connector Definition with id '" + connector.getId() + "'");
                }
                checkedConnectors.put(connector.getId(), connector);
            }
        } else {
            checkedConnectors = Collections.emptyMap();
        }
        this.dataConnectors = ImmutableMap.copyOf(checkedConnectors);
        this.principalConnector = principalResolver;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, DataConnector> getDataConnectors() {
        return this.dataConnectors;
    }

    public void resolveAttributes(@Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        this.log.debug("{} Initiating attribute resolution", (Object)this.logPrefix);
        if (this.attributeDefinitions.size() == 0) {
            this.log.debug("{} No attribute definition available, no attributes were resolved", (Object)this.logPrefix);
            return;
        }
        Collection<String> attributeIds = this.getToBeResolvedAttributeIds(resolutionContext);
        this.log.debug("{} Attempting to resolve the following attribute definitions {}", (Object)this.logPrefix, attributeIds);
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, true);
        for (String attributeId : attributeIds) {
            this.resolveAttributeDefinition(attributeId, resolutionContext);
        }
        this.log.debug("{} Finalizing resolved attributes", (Object)this.logPrefix);
        this.finalizeResolvedAttributes(resolutionContext);
        resolutionContext.removeSubcontext((BaseContext)workContext);
        this.log.debug("{} Final resolved attribute collection: {}", (Object)this.logPrefix, resolutionContext.getResolvedIdPAttributes().keySet());
    }

    @Nonnull
    @NonnullElements
    protected Collection<String> getToBeResolvedAttributeIds(@Nonnull AttributeResolutionContext resolutionContext) {
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        if (resolutionContext.getRequestedIdPAttributeNames().isEmpty()) {
            LazyList attributeIds = new LazyList();
            attributeIds.addAll(this.attributeDefinitions.keySet());
            return attributeIds;
        }
        return resolutionContext.getRequestedIdPAttributeNames();
    }

    protected void resolveAttributeDefinition(@Nonnull String attributeId, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Constraint.isNotNull((Object)attributeId, (String)"Attribute ID can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        this.log.trace("{} Beginning to resolve attribute definition '{}'", (Object)this.logPrefix, (Object)attributeId);
        if (workContext.getResolvedIdPAttributeDefinitions().containsKey(attributeId)) {
            this.log.trace("{} Attribute definition '{}' was already resolved, nothing to do", (Object)this.logPrefix, (Object)attributeId);
            return;
        }
        AttributeDefinition definition = this.attributeDefinitions.get(attributeId);
        if (definition == null) {
            this.log.debug("{} No attribute definition was registered with ID '{}', nothing to do", (Object)this.logPrefix, (Object)attributeId);
            return;
        }
        this.resolveDependencies((ResolverPlugin<?>)definition, resolutionContext);
        this.log.trace("{} Resolving attribute definition {}", (Object)this.logPrefix, (Object)attributeId);
        IdPAttribute resolvedAttribute = (IdPAttribute)definition.resolve(resolutionContext);
        if (null == resolvedAttribute) {
            this.log.debug("{} Attribute definition '{}' produced no attribute", (Object)this.logPrefix, (Object)attributeId);
        } else {
            this.log.debug("{} Attribute definition '{}' produced an attribute with {} values", new Object[]{this.logPrefix, attributeId, resolvedAttribute.getValues().size()});
        }
        workContext.recordAttributeDefinitionResolution(definition, resolvedAttribute);
    }

    protected void resolveDataConnector(@Nonnull String connectorId, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Map resolvedAttributes;
        Constraint.isNotNull((Object)connectorId, (String)"Data connector ID can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        if (workContext.getResolvedDataConnectors().containsKey(connectorId)) {
            this.log.trace("{} Data connector '{}' was already resolved, nothing to do", (Object)this.logPrefix, (Object)connectorId);
            return;
        }
        DataConnector connector = this.dataConnectors.get(connectorId);
        if (connector == null) {
            this.log.debug("{} No data connector was registered with ID '{}', nothing to do", (Object)this.logPrefix, (Object)connectorId);
            return;
        }
        this.resolveDependencies((ResolverPlugin<?>)connector, resolutionContext);
        try {
            this.log.debug("{} Resolving data connector {}", (Object)this.logPrefix, (Object)connectorId);
            resolvedAttributes = (Map)connector.resolve(resolutionContext);
        }
        catch (ResolutionException e) {
            String failoverDataConnectorId = connector.getFailoverDataConnectorId();
            if (null != failoverDataConnectorId) {
                this.log.debug("{} Data connector '{}' failed to resolve, invoking failover data connector '{}'.  Reason for failure:", new Object[]{this.logPrefix, connectorId, failoverDataConnectorId, e});
                this.resolveDataConnector(failoverDataConnectorId, resolutionContext);
                ResolvedDataConnector resolvedFailoverConector = (ResolvedDataConnector)workContext.getResolvedDataConnectors().get(failoverDataConnectorId);
                if (null == resolvedFailoverConector) {
                    throw new ResolutionException("The resolution of failover conector" + failoverDataConnectorId + " was not recorded");
                }
                resolvedAttributes = resolvedFailoverConector.getResolvedAttributes();
            }
            throw e;
        }
        if (null != resolvedAttributes) {
            this.log.debug("{} Data connector '{}' resolved the following attributes: {}", new Object[]{this.logPrefix, connectorId, resolvedAttributes.keySet()});
        } else {
            this.log.debug("{} Data connector '{}' produced no attributes", (Object)this.logPrefix, (Object)connectorId);
        }
        workContext.recordDataConnectorResolution(connector, resolvedAttributes);
    }

    protected void resolveDependencies(@Nonnull ResolverPlugin<?> plugin, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        Constraint.isNotNull(plugin, (String)"Plugin dependency can not be null");
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        if (plugin.getDependencies().isEmpty()) {
            return;
        }
        this.log.debug("{} Resolving dependencies for '{}'", (Object)this.logPrefix, (Object)plugin.getId());
        for (ResolverPluginDependency dependency : plugin.getDependencies()) {
            String pluginId = dependency.getDependencyPluginId();
            if (this.attributeDefinitions.containsKey(pluginId)) {
                this.resolveAttributeDefinition(pluginId, resolutionContext);
                continue;
            }
            if (this.dataConnectors.containsKey(pluginId)) {
                this.resolveDataConnector(pluginId, resolutionContext);
                continue;
            }
            throw new ResolutionException("Plugin '" + plugin.getId() + "' contains a depedency on plugin '" + pluginId + "' which does not exist.");
        }
        this.log.debug("{} Finished resolving dependencies for {}", (Object)this.logPrefix, (Object)plugin.getId());
    }

    protected void finalizeResolvedAttributes(@Nonnull AttributeResolutionContext resolutionContext) {
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context cannot be null");
        AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
        LazySet resolvedAttributes = new LazySet();
        for (ResolvedAttributeDefinition definition : workContext.getResolvedIdPAttributeDefinitions().values()) {
            IdPAttribute resolvedAttribute = definition.getResolvedAttribute();
            if (null == resolvedAttribute) {
                this.log.debug("{} Removing result of attribute definition '{}', it is null", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            if (definition.isDependencyOnly()) {
                this.log.debug("{} Removing result of attribute definition '{}', is marked as dependency only", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            if (resolvedAttribute.getValues().size() == 0) {
                this.log.debug("{} Removing result of attribute definition '{}', contains no values", (Object)this.logPrefix, (Object)definition.getId());
                continue;
            }
            this.log.debug("{} De-duping attribute definition {} result", (Object)this.logPrefix, (Object)definition.getId());
            Iterator valueIter = resolvedAttribute.getValues().iterator();
            HashSet<IdPAttributeValue> monitor = new HashSet<IdPAttributeValue>(resolvedAttribute.getValues().size());
            while (valueIter.hasNext()) {
                IdPAttributeValue value = (IdPAttributeValue)valueIter.next();
                if (monitor.add(value)) continue;
                this.log.debug("{} Removing duplicate value {} of attribute '{}' from resolution result", new Object[]{this.logPrefix, value, resolvedAttribute.getId()});
            }
            resolvedAttribute.setValues(monitor);
            this.log.debug("{} Attribute '{}' has {} values after post-processing", new Object[]{this.logPrefix, resolvedAttribute.getId(), monitor.size()});
            resolvedAttributes.add((Object)resolvedAttribute);
        }
        resolutionContext.setResolvedIdPAttributes((Collection)resolvedAttributes);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        HashSet<String> dependencyVerifiedPlugins = new HashSet<String>();
        for (DataConnector dataConnector : this.dataConnectors.values()) {
            this.log.debug("{} Checking if data connector '{}' is has a circular dependency", (Object)this.logPrefix, (Object)dataConnector.getId());
            this.checkPlugInDependencies(dataConnector.getId(), (ResolverPlugin<?>)dataConnector, (Set<String>)dependencyVerifiedPlugins);
        }
        for (AttributeDefinition attributeDefinition : this.attributeDefinitions.values()) {
            this.log.debug("{} Checking if attribute definition '{}' has a circular dependency", (Object)this.logPrefix, (Object)attributeDefinition.getId());
            this.checkPlugInDependencies(attributeDefinition.getId(), (ResolverPlugin<?>)attributeDefinition, (Set<String>)dependencyVerifiedPlugins);
        }
    }

    protected void checkPlugInDependencies(String circularCheckPluginId, ResolverPlugin<?> plugin, Set<String> checkedPlugins) throws ComponentInitializationException {
        String pluginId = plugin.getId();
        for (ResolverPluginDependency dependency : plugin.getDependencies()) {
            if (checkedPlugins.contains(pluginId)) continue;
            if (circularCheckPluginId.equals(dependency.getDependencyPluginId())) {
                throw new ComponentInitializationException(this.logPrefix + " Plugin '" + circularCheckPluginId + "' and plugin '" + dependency.getDependencyPluginId() + "' have a circular dependecy on each other.");
            }
            ResolverPlugin dependencyPlugin = (ResolverPlugin)this.dataConnectors.get(dependency.getDependencyPluginId());
            if (dependencyPlugin == null) {
                dependencyPlugin = (ResolverPlugin)this.attributeDefinitions.get(dependency.getDependencyPluginId());
            }
            if (dependencyPlugin == null) {
                throw new ComponentInitializationException(this.logPrefix + " Plugin '" + plugin.getId() + "' has a dependency on plugin '" + dependency.getDependencyPluginId() + "' which doesn't exist");
            }
            this.checkPlugInDependencies(circularCheckPluginId, dependencyPlugin, checkedPlugins);
            checkedPlugins.add(pluginId);
        }
    }

    @Nonnull
    public AttributeResolver getComponent() {
        return this;
    }

    @Nullable
    public String canonicalize(@Nonnull SubjectCanonicalizationContext context) throws ResolutionException {
        if (null == this.principalConnector) {
            return null;
        }
        return this.principalConnector.canonicalize(context);
    }

    public boolean hasValidConnectors() {
        return this.principalConnector.hasValidConnectors();
    }
}

