/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.mapped.impl;

import com.google.common.base.MoreObjects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class SourceValue {
    private final String value;
    private final boolean ignoreCase;
    private final Pattern pattern;
    private final boolean partialMatch;

    public SourceValue(@Nullable String theValue, @Nullable Boolean theIgnoreCase, @Nullable Boolean thePartialMatch) {
        this.value = StringSupport.trimOrNull((String)theValue);
        this.ignoreCase = null != theIgnoreCase ? theIgnoreCase : false;
        this.partialMatch = null != thePartialMatch ? thePartialMatch : false;
        if (!this.partialMatch && this.value != null) {
            int flags = 0;
            if (this.ignoreCase) {
                flags = 2;
            }
            this.pattern = Pattern.compile(this.value, flags);
        } else {
            this.pattern = null;
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isPartialMatch() {
        return this.partialMatch;
    }

    @Nullable
    public String getValue() {
        Constraint.isTrue((boolean)this.isPartialMatch(), (String)"getValue is only meaningful for a partialMatch, use getPattern()");
        return this.value;
    }

    @Nonnull
    public Pattern getPattern() {
        Constraint.isFalse((boolean)this.isPartialMatch(), (String)"getPattern is only meaningful for a non partial Match, use getValue()");
        return this.pattern;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("IsIgnoreCase", this.isIgnoreCase()).add("isPartialMatch", this.isPartialMatch()).toString();
    }
}

