/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryValidator
implements Validator {
    private final Logger log = LoggerFactory.getLogger(ConnectionFactoryValidator.class);
    private final ConnectionFactory connectionFactory;
    private final boolean throwOnValidateError;

    public ConnectionFactoryValidator(ConnectionFactory factory) {
        this(factory, true);
    }

    public ConnectionFactoryValidator(ConnectionFactory factory, boolean throwOnError) {
        this.connectionFactory = factory;
        this.throwOnValidateError = throwOnError;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public boolean isThrowValidateError() {
        return this.throwOnValidateError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws ValidationException {
        try (Connection connection = null;){
            connection = this.connectionFactory.getConnection();
            if (connection == null) {
                this.log.error("Unable to retrieve connections from configured connection factory");
                if (this.throwOnValidateError) {
                    throw new LdapException("Unable to retrieve connection from connection factory");
                }
            }
            connection.open();
        }
    }
}

