/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import com.google.common.base.Function;
import edu.internet2.middleware.shibboleth.common.attribute.provider.V2SAMLProfileRequestContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.DelegatedWorkContext;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedIdPAttributeImpl;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScriptedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedAttributeDefinition.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @NonnullAfterInit
    private AttributeDefinitionScriptEvaluator scriptEvaluator;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> prcLookupStrategy = new ParentContextLookup();
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> scLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @Nullable
    private Object customObject;

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    @Nullable
    public void setCustomObject(Object object) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.customObject = object;
    }

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript definitionScript) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.script = (EvaluableScript)Constraint.isNotNull((Object)definitionScript, (String)"Attribute definition script cannot be null");
    }

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.prcLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.scLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no script was configured");
        }
        this.scriptEvaluator = new AttributeDefinitionScriptEvaluator(this.script);
        this.scriptEvaluator.setCustomObject(this.customObject);
        this.scriptEvaluator.setLogPrefix(this.getLogPrefix());
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)resolutionContext, (String)"AttributeResolutionContext cannot be null");
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        return this.scriptEvaluator.execute(resolutionContext, workContext);
    }

    private class AttributeDefinitionScriptEvaluator
    extends AbstractScriptEvaluator {
        public AttributeDefinitionScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
        }

        @Nullable
        protected IdPAttribute execute(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
            try {
                return (IdPAttribute)this.evaluate(new Object[]{resolutionContext, workContext});
            }
            catch (RuntimeException e) {
                throw new ResolutionException(this.getLogPrefix() + "Script did not run successfully", (Exception)e);
            }
        }

        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
            Map dependencyAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)((AttributeResolverWorkContext)input[1]), (Collection)ScriptedAttributeDefinition.this.getDependencies());
            if (dependencyAttributes.containsKey(ScriptedAttributeDefinition.this.getId())) {
                ScriptedAttributeDefinition.this.log.debug("{} The attribute ID to be populated is a dependency, not created", (Object)this.getLogPrefix());
            } else {
                ScriptedAttributeDefinition.this.log.debug("{} Adding to-be-populated attribute to script context", (Object)this.getLogPrefix());
                IdPAttribute newAttribute = new IdPAttribute(ScriptedAttributeDefinition.this.getId());
                scriptContext.setAttribute(ScriptedAttributeDefinition.this.getId(), new ScriptedIdPAttributeImpl(newAttribute, this.getLogPrefix()), 100);
            }
            ScriptedAttributeDefinition.this.log.debug("{} Adding contexts to script context", (Object)this.getLogPrefix());
            scriptContext.setAttribute("resolutionContext", input[0], 100);
            scriptContext.setAttribute("workContext", (Object)new DelegatedWorkContext((AttributeResolverWorkContext)input[1], this.getLogPrefix()), 100);
            ProfileRequestContext prc = (ProfileRequestContext)ScriptedAttributeDefinition.this.prcLookupStrategy.apply((Object)((AttributeResolutionContext)input[0]));
            if (null == prc) {
                ScriptedAttributeDefinition.this.log.error("{} ProfileRequestContext could not be located", (Object)this.getLogPrefix());
            }
            scriptContext.setAttribute("profileContext", prc, 100);
            SubjectContext sc = (SubjectContext)ScriptedAttributeDefinition.this.scLookupStrategy.apply((Object)prc);
            if (null == sc) {
                ScriptedAttributeDefinition.this.log.debug("{} Could not locate SubjectContext", (Object)this.getLogPrefix());
            } else {
                List subjects = sc.getSubjects();
                if (null == subjects) {
                    ScriptedAttributeDefinition.this.log.debug("{} Could not locate Subjects", (Object)this.getLogPrefix());
                } else {
                    scriptContext.setAttribute("subjects", subjects.toArray(new Subject[subjects.size()]), 100);
                }
            }
            ScriptedAttributeDefinition.this.log.debug("{} Adding emulated V2 request context to script context", (Object)this.getLogPrefix());
            scriptContext.setAttribute("requestContext", new V2SAMLProfileRequestContext((AttributeResolutionContext)input[0], ScriptedAttributeDefinition.this.getId()), 100);
            for (Map.Entry dependencyAttribute : dependencyAttributes.entrySet()) {
                ScriptedAttributeDefinition.this.log.trace("{} Adding dependent attribute '{}' with the following values to the script context: {}", new Object[]{this.getLogPrefix(), dependencyAttribute.getKey(), dependencyAttribute.getValue()});
                IdPAttribute pseudoAttribute = new IdPAttribute((String)dependencyAttribute.getKey());
                pseudoAttribute.setValues((Collection)dependencyAttribute.getValue());
                scriptContext.setAttribute((String)dependencyAttribute.getKey(), new ScriptedIdPAttributeImpl(pseudoAttribute, this.getLogPrefix()), 100);
            }
        }

        @Nullable
        protected Object finalizeContext(@Nonnull ScriptContext scriptContext, @Nullable Object scriptResult) throws ScriptException {
            Object result = scriptContext.getAttribute(ScriptedAttributeDefinition.this.getId());
            if (null == result) {
                ScriptedAttributeDefinition.this.log.info("{} No value returned", (Object)this.getLogPrefix());
                return null;
            }
            if (result instanceof ScriptedIdPAttributeImpl) {
                ScriptedIdPAttributeImpl scriptedAttribute = (ScriptedIdPAttributeImpl)result;
                try {
                    return scriptedAttribute.getResultingAttribute();
                }
                catch (ResolutionException e) {
                    throw new ScriptException((Exception)((Object)e));
                }
            }
            throw new ScriptException(this.getLogPrefix() + " returned variable was of wrong type (" + result.getClass().toString() + ")");
        }
    }
}

