/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.mapped.impl;

import com.google.common.base.MoreObjects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class SourceValue
extends AbstractInitializableComponent {
    @Nullable
    private String value;
    private boolean ignoreCase;
    @Nullable
    private Pattern pattern;
    private boolean partialMatch;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.partialMatch && this.value != null) {
            int flags = 0;
            if (this.ignoreCase) {
                flags = 2;
            }
            this.pattern = Pattern.compile(this.value, flags);
        } else {
            this.pattern = null;
        }
    }

    public void setIgnoreCase(@Nullable Boolean theIgnoreCase) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoreCase = null != theIgnoreCase ? theIgnoreCase : false;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setPartialMatch(@Nullable Boolean thePartialMatch) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.partialMatch = null != thePartialMatch ? thePartialMatch : false;
    }

    public boolean isPartialMatch() {
        return this.partialMatch;
    }

    public void setValue(@Nullable String theValue) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.value = StringSupport.trimOrNull((String)theValue);
    }

    @Nullable
    public String getValue() {
        Constraint.isTrue((boolean)this.isPartialMatch(), (String)"getValue is only meaningful for a partialMatch, use getPattern()");
        return this.value;
    }

    @Nonnull
    public Pattern getPattern() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isFalse((boolean)this.isPartialMatch(), (String)"getPattern is only meaningful for a non partial Match, use getValue()");
        return this.pattern;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", (Object)this.value).add("IsIgnoreCase", this.isIgnoreCase()).add("isPartialMatch", this.isPartialMatch()).toString();
    }
}

