/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryValidator
extends AbstractInitializableComponent
implements Validator {
    private final Logger log = LoggerFactory.getLogger(ConnectionFactoryValidator.class);
    @Nonnull
    private ConnectionFactory connectionFactory;
    private boolean throwOnValidateError = true;

    @Deprecated
    public ConnectionFactoryValidator(@Nonnull ConnectionFactory factory) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"ConnectionFactoryValidator(ConnectionFactory)", null, (String)"ConnectionFactoryValidator()");
        this.setConnectionFactory(factory);
        this.setThrowValidateError(true);
        try {
            this.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ConstraintViolationException("Invalid parameterization to deprecated structure");
        }
    }

    @Deprecated
    public ConnectionFactoryValidator(@Nonnull ConnectionFactory factory, boolean throwOnError) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"ConnectionFactoryValidator(ConnectionFactory, boolean)", null, (String)"ConnectionFactoryValidator()");
        this.setConnectionFactory(factory);
        this.setThrowValidateError(throwOnError);
        try {
            this.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ConstraintViolationException("Invalid parameterization to deprecated structure");
        }
    }

    public ConnectionFactoryValidator() {
    }

    protected void doInitialize() throws ComponentInitializationException {
        Constraint.isNotNull((Object)this.connectionFactory, (String)"Connection factory must be non-null");
        super.doInitialize();
    }

    @Nonnull
    public void setConnectionFactory(@Nonnull ConnectionFactory factory) {
        this.connectionFactory = (ConnectionFactory)Constraint.isNotNull((Object)factory, (String)"Connection factory must be non-null");
    }

    @Nonnull
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setThrowValidateError(Boolean what) {
        if (null != what) {
            this.throwOnValidateError = what;
        }
    }

    public boolean isThrowValidateError() {
        return this.throwOnValidateError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws ValidationException {
        try (Connection connection = null;){
            connection = this.connectionFactory.getConnection();
            if (connection == null) {
                this.log.error("Unable to retrieve connections from configured connection factory");
                if (this.throwOnValidateError) {
                    throw new LdapException("Unable to retrieve connection from connection factory");
                }
            }
            connection.open();
        }
    }
}

