/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ConnectionFactoryValidator;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ExecutableSearchFilter;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.SearchResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.StringAttributeValueMappingStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchResult;
import org.ldaptive.ssl.SSLContextInitializer;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.X509SSLContextInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPDataConnector
extends AbstractSearchDataConnector<ExecutableSearchFilter, SearchResultMappingStrategy> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPDataConnector.class);
    private ConnectionFactory connectionFactory;
    private SearchExecutor searchExecutor;
    private boolean defaultValidator = true;
    private boolean defaultMappingStrategy = true;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(@Nonnull ConnectionFactory factory) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.connectionFactory = (ConnectionFactory)Constraint.isNotNull((Object)factory, (String)"LDAP connection factory can not be null");
    }

    public SearchExecutor getSearchExecutor() {
        return this.searchExecutor;
    }

    public void setSearchExecutor(@Nonnull SearchExecutor executor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.searchExecutor = (SearchExecutor)Constraint.isNotNull((Object)executor, (String)"LDAP search executor can not be null");
    }

    @Override
    public void setValidator(@Nonnull Validator validator) {
        super.setValidator(validator);
        this.defaultValidator = false;
    }

    @Override
    public void setMappingStrategy(@Nonnull SearchResultMappingStrategy strategy) {
        super.setMappingStrategy(strategy);
        this.defaultMappingStrategy = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.connectionFactory == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No connection factory was configured");
        }
        if (this.searchExecutor == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No search executor was configured");
        }
        if (this.defaultValidator) {
            ConnectionFactoryValidator validator = new ConnectionFactoryValidator();
            validator.setConnectionFactory(this.connectionFactory);
            super.setValidator(validator);
        }
        if (this.defaultMappingStrategy) {
            super.setMappingStrategy(new StringAttributeValueMappingStrategy());
        }
        super.doInitialize();
        try {
            this.getValidator().validate();
        }
        catch (ValidationException e) {
            this.log.error("{} Invalid connector configuration", (Object)this.getLogPrefix(), (Object)e);
            throw new ComponentInitializationException(this.getLogPrefix() + " Invalid connector configuration", (Exception)((Object)e));
        }
        Connection conn = null;
        try {
            SslConfig sslConfig;
            conn = this.connectionFactory.getConnection();
            ConnectionConfig connConfig = conn.getConnectionConfig();
            if ((connConfig.getUseStartTLS() || connConfig.getUseSSL() || connConfig.getLdapUrl().toLowerCase().contains("ldaps://")) && (sslConfig = connConfig.getSslConfig()) != null) {
                SSLContextInitializer cxtInit;
                SSLContextInitializer sSLContextInitializer = cxtInit = sslConfig.getCredentialConfig() != null ? sslConfig.getCredentialConfig().createSSLContextInitializer() : null;
                if (cxtInit instanceof X509SSLContextInitializer && ((X509SSLContextInitializer)cxtInit).getTrustCertificates() == null) {
                    DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"Use of default JVM trust store", (String)this.getLogPrefix(), (String)"trustFile attribute");
                }
            }
        }
        catch (Exception e) {
            this.log.debug("{} Error inspecting SSL configuration", (Object)this.getLogPrefix(), (Object)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.log.debug("{} Error closing LDAP connection", (Object)this.getLogPrefix(), (Object)e);
                }
            }
        }
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> retrieveAttributes(ExecutableSearchFilter filter) throws ResolutionException {
        if (filter == null) {
            throw new ResolutionException(this.getLogPrefix() + " Search filter cannot be null");
        }
        try {
            SearchResult result = filter.execute(this.searchExecutor, this.connectionFactory);
            this.log.trace("{} Search returned {}", (Object)this.getLogPrefix(), (Object)result);
            return ((SearchResultMappingStrategy)this.getMappingStrategy()).map(result);
        }
        catch (LdapException e) {
            throw new ResolutionException(this.getLogPrefix() + " Unable to execute LDAP search", (Exception)((Object)e));
        }
    }
}

