/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.AbstractExecutableStatementBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.apache.commons.lang.StringEscapeUtils;

public class FormatExecutableStatementBuilder
extends AbstractExecutableStatementBuilder {
    private String sqlQuery;

    @Deprecated
    public FormatExecutableStatementBuilder(@Nonnull String query) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"FormatExecutableStatementBuilder(String)", null, null);
        this.sqlQuery = (String)Constraint.isNotNull((Object)query, (String)"SQL query can not be null");
    }

    @Deprecated
    public FormatExecutableStatementBuilder(@Nonnull String query, @Nonnull int timeout) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"FormatExecutableStatementBuilder(String, int)", null, null);
        this.sqlQuery = (String)Constraint.isNotNull((Object)query, (String)"SQL query can not be null");
        this.setQueryTimeout((int)Constraint.isGreaterThanOrEqual((long)0L, (long)timeout, (String)"Query timeout must be greater than zero"));
    }

    public FormatExecutableStatementBuilder() {
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (null == this.sqlQuery) {
            throw new ComponentInitializationException("FormatExecutableStatementBuilder: SQL query can not be null");
        }
        if (this.getQueryTimeout() <= 0) {
            throw new ComponentInitializationException("FormatExecutableStatementBuilder: Query timeout must be greater than zero");
        }
        super.doInitialize();
    }

    public void setQuery(@Nonnull String query) {
        this.sqlQuery = (String)Constraint.isNotNull((Object)query, (String)"SQL query can not be null");
    }

    public void setTimeOut(@Nonnull int timeout) {
        this.setQueryTimeout((int)Constraint.isGreaterThanOrEqual((long)0L, (long)timeout, (String)"Query timeout must be greater than zero"));
    }

    @Override
    protected String getSQLQuery(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) {
        ArrayList<Object> args = new ArrayList<Object>();
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue<?>>> entry : dependencyAttributes.entrySet()) {
                for (IdPAttributeValue<?> value : entry.getValue()) {
                    if (value.getValue() instanceof String) {
                        args.add(StringEscapeUtils.escapeSql((String)((String)value.getValue())));
                        continue;
                    }
                    args.add(value.getValue());
                }
            }
        } else {
            args.add(StringEscapeUtils.escapeSql((String)resolutionContext.getPrincipal()));
        }
        return String.format(this.sqlQuery, args.toArray());
    }
}

