/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.DataConnectorEx;
import net.shibboleth.idp.metrics.ReloadableServiceGaugeSet;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.joda.time.DateTime;

public class AttributeResolverServiceGaugeSet
extends ReloadableServiceGaugeSet
implements MetricSet,
MetricFilter {
    public AttributeResolverServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        super(metricName);
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "failure"}), new Gauge<Map<String, DateTime>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<String, DateTime> getValue() {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                ServiceableComponent component = AttributeResolverServiceGaugeSet.this.getService().getServiceableComponent();
                if (component != null) {
                    try {
                        AttributeResolver resolver = (AttributeResolver)component.getComponent();
                        Collection connectors = resolver.getDataConnectors().values();
                        for (DataConnector connector : connectors) {
                            long lastFail;
                            if (!(connector instanceof DataConnectorEx) || (lastFail = ((DataConnectorEx)connector).getLastFail()) <= 0L) continue;
                            mapBuilder.put((Object)connector.getId(), (Object)new DateTime(lastFail));
                        }
                    }
                    finally {
                        component.unpinComponent();
                    }
                }
                return mapBuilder.build();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        ServiceableComponent component = this.getService().getServiceableComponent();
        if (component != null) {
            try {
                if (component instanceof AttributeResolver) {
                    return;
                }
            }
            finally {
                component.unpinComponent();
            }
        }
        throw new ComponentInitializationException("Injected service was null or not an AttributeResolver");
    }
}

