/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import com.google.common.base.Function;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.ContextDerivedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ad.impl.IdPAttributePrincipalValuesFunction;
import net.shibboleth.idp.attribute.resolver.ad.impl.SubjectDerivedAttributeValuesFunction;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ContextDerivedAttributeDefinitionTest {
    private static final String SIMPLE_VALUE = "simple";

    @Test
    public void simpleValue() throws ComponentInitializationException, ResolutionException {
        ArrayList<StringAttributeValue> list = new ArrayList<StringAttributeValue>(2);
        list.add(new StringAttributeValue(SIMPLE_VALUE));
        list.add(new StringAttributeValue("simple2"));
        IdPAttribute attr = new IdPAttribute("wibble");
        attr.setValues(list);
        SubjectDerivedAttributeValuesFunction ctxValueFunction = new SubjectDerivedAttributeValuesFunction();
        ctxValueFunction.setId("pDaD");
        IdPAttributePrincipalValuesFunction fn = new IdPAttributePrincipalValuesFunction();
        fn.setAttributeName("wibble");
        fn.doInitialize();
        ctxValueFunction.setAttributeValuesFunction((Function)fn);
        ContextDerivedAttributeDefinition defn = new ContextDerivedAttributeDefinition();
        defn.setAttributeValuesFunction((Function)ctxValueFunction);
        defn.setId("pDAD");
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        SubjectContext sc = (SubjectContext)ctx.getParent().getSubcontext(SubjectContext.class, true);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        List foo = ((IdPAttribute)defn.resolve(ctx)).getValues();
        Assert.assertEquals((int)2, (int)foo.size());
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)foo.contains(new StringAttributeValue("simple2")));
    }

    @Test
    public void empty() throws ComponentInitializationException, ResolutionException {
        List list = Collections.EMPTY_LIST;
        IdPAttribute attr = new IdPAttribute("wibble");
        attr.setValues((Collection)list);
        SubjectDerivedAttributeValuesFunction ctxValueFunction = new SubjectDerivedAttributeValuesFunction();
        ctxValueFunction.setId("pDaD");
        IdPAttributePrincipalValuesFunction fn = new IdPAttributePrincipalValuesFunction();
        fn.setAttributeName("wibble");
        fn.doInitialize();
        ctxValueFunction.setAttributeValuesFunction((Function)fn);
        ContextDerivedAttributeDefinition defn = new ContextDerivedAttributeDefinition();
        defn.setAttributeValuesFunction((Function)ctxValueFunction);
        defn.setId("pDAD");
        defn.initialize();
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        SubjectContext sc = (SubjectContext)ctx.getParent().getSubcontext(SubjectContext.class, true);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new IdPAttributePrincipal(attr));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        IdPAttribute result = (IdPAttribute)defn.resolve(ctx);
        Assert.assertNull((Object)result);
    }
}

