/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.Collection;
import java.util.Collections;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.logic.AttributeIssuerIdPredicate;
import net.shibboleth.idp.attribute.resolver.logic.AttributePrincipalPredicate;
import net.shibboleth.idp.attribute.resolver.logic.AttributeRecipientIdPredicate;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public class LogicTest {
    private final AttributeIssuerIdPredicate aiip = new AttributeIssuerIdPredicate(Collections.singleton("AII"));
    private final AttributePrincipalPredicate app = new AttributePrincipalPredicate((Collection)Lists.newArrayList((Object[])new String[]{"AP", "Principal"}));
    private final AttributeRecipientIdPredicate arip = new AttributeRecipientIdPredicate(Collections.singleton("ARI"));

    @Test
    public void empty() {
        ProfileRequestContext pfc = new ProfileRequestContext();
        Assert.assertFalse((boolean)this.aiip.apply((Object)pfc));
        Assert.assertFalse((boolean)this.app.apply((Object)pfc));
        Assert.assertFalse((boolean)this.arip.apply((Object)pfc));
        pfc.getSubcontext(AttributeResolutionContext.class, true);
        Assert.assertFalse((boolean)this.aiip.apply((Object)pfc));
        Assert.assertFalse((boolean)this.app.apply((Object)pfc));
        Assert.assertFalse((boolean)this.arip.apply((Object)pfc));
    }

    @Test
    public void wrong() {
        ProfileRequestContext pfc = new ProfileRequestContext();
        AttributeResolutionContext arc = (AttributeResolutionContext)pfc.getSubcontext(AttributeResolutionContext.class, true);
        arc.setAttributeIssuerID("badValue");
        arc.setPrincipal("badValue");
        arc.setAttributeRecipientID("badValue");
        Assert.assertFalse((boolean)this.aiip.apply((Object)pfc));
        Assert.assertFalse((boolean)this.app.apply((Object)pfc));
        Assert.assertFalse((boolean)this.arip.apply((Object)pfc));
    }

    @Test
    public void correct() {
        ProfileRequestContext pfc = new ProfileRequestContext();
        AttributeResolutionContext arc = (AttributeResolutionContext)pfc.getSubcontext(AttributeResolutionContext.class, true);
        arc.setAttributeIssuerID("AII");
        arc.setPrincipal("Principal");
        arc.setAttributeRecipientID("ARI");
        Assert.assertTrue((boolean)this.aiip.apply((Object)pfc));
        Assert.assertTrue((boolean)this.app.apply((Object)pfc));
        Assert.assertTrue((boolean)this.arip.apply((Object)pfc));
    }
}

