/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.ad.impl.PrescopedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PrescopedAtributeTest {
    private static final String TEST_ATTRIBUTE_NAME = "prescoped";
    private static final String DELIMITER = "@";

    @Test
    public void preScoped() throws ResolutionException, ComponentInitializationException {
        LazySet dependencySet = new LazySet();
        ResolverPluginDependency depend = new ResolverPluginDependency("staticCon");
        depend.setDependencyAttributeId("ac1");
        dependencySet.add(depend);
        PrescopedAttributeDefinition attrDef = new PrescopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setScopeDelimiter("-");
        attrDef.setDependencies((Set)dependencySet);
        attrDef.initialize();
        LazySet connectorSet = new LazySet();
        connectorSet.add(TestSources.populatedStaticConnector());
        LazySet attributeSet = new LazySet();
        attributeSet.add(attrDef);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attributeSet, (Collection<DataConnector>)connectorSet, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        List f = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)f.size(), (int)2);
        Assert.assertTrue((boolean)f.contains(new ScopedStringAttributeValue("at1", "Data")));
        Assert.assertTrue((boolean)f.contains(new ScopedStringAttributeValue("at1", "Connector")));
    }

    @Test
    public void preScopedNoValues() throws ResolutionException, ComponentInitializationException {
        LazySet dependencySet = new LazySet();
        ResolverPluginDependency depend = new ResolverPluginDependency("staticCon");
        depend.setDependencyAttributeId("ac1");
        dependencySet.add(depend);
        PrescopedAttributeDefinition attrDef = new PrescopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setScopeDelimiter(DELIMITER);
        attrDef.setDependencies((Set)dependencySet);
        attrDef.initialize();
        LazySet connectorSet = new LazySet();
        connectorSet.add(TestSources.populatedStaticConnector());
        LazySet attributeSet = new LazySet();
        attributeSet.add(attrDef);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attributeSet, (Collection<DataConnector>)connectorSet, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
            Assert.fail();
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void invalidValueType() throws ComponentInitializationException {
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(Collections.singletonList(new ByteAttributeValue(new byte[]{1, 2, 3})));
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        PrescopedAttributeDefinition attrDef = new PrescopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setScopeDelimiter(DELIMITER);
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attrDef.setDependencies(Collections.singleton(depend));
        attrDef.initialize();
        try {
            attrDef.resolve(resolutionContext);
            Assert.fail((String)"Invalid type");
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void nullValueType() throws ComponentInitializationException, ResolutionException {
        ArrayList<Object> values = new ArrayList<Object>(4);
        values.add(new StringAttributeValue("one@two"));
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        values.add(new StringAttributeValue("three@four"));
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.ZERO_LENGTH_VALUE));
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(values);
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        PrescopedAttributeDefinition attrDef = new PrescopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setScopeDelimiter(DELIMITER);
        attrDef.setDependencies(Collections.singleton(depend));
        attrDef.initialize();
        IdPAttribute result = (IdPAttribute)attrDef.resolve(resolutionContext);
        List f = result.getValues();
        Assert.assertEquals((int)f.size(), (int)2);
        Assert.assertTrue((boolean)f.contains(new ScopedStringAttributeValue("one", "two")));
        Assert.assertTrue((boolean)f.contains(new ScopedStringAttributeValue("three", "four")));
    }

    @Test
    public void emptyValueType() throws ResolutionException, ComponentInitializationException {
        LazySet dependencySet = new LazySet();
        ResolverPluginDependency depend = new ResolverPluginDependency("staticCon");
        depend.setDependencyAttributeId("ac1");
        dependencySet.add(depend);
        PrescopedAttributeDefinition attrDef = new PrescopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setScopeDelimiter("at1-");
        attrDef.setDependencies((Set)dependencySet);
        attrDef.initialize();
        LazySet connectorSet = new LazySet();
        connectorSet.add(TestSources.populatedStaticConnector());
        LazySet attributeSet = new LazySet();
        attributeSet.add(attrDef);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attributeSet, (Collection<DataConnector>)connectorSet, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        List f = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)f.size(), (int)1);
        Assert.assertEquals(f.iterator().next(), (Object)EmptyAttributeValue.ZERO_LENGTH);
    }

    @Test
    public void initDestroyParms() throws ResolutionException, ComponentInitializationException {
        PrescopedAttributeDefinition attrDef = new PrescopedAttributeDefinition();
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        Set<ResolverPluginDependency> pluginDependencies = Collections.singleton(depend);
        attrDef.setDependencies(pluginDependencies);
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        try {
            attrDef.setScopeDelimiter(null);
            Assert.fail((String)"set null delimiter");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        attrDef = new PrescopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        Assert.assertNotNull((Object)attrDef.getScopeDelimiter());
        attrDef.setScopeDelimiter(DELIMITER);
        try {
            attrDef.initialize();
            Assert.fail((String)"no Dependency - should fail");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        attrDef.setDependencies(pluginDependencies);
        try {
            attrDef.resolve(new AttributeResolutionContext());
            Assert.fail((String)"resolve not initialized");
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        attrDef.initialize();
        Assert.assertEquals((String)attrDef.getScopeDelimiter(), (String)DELIMITER);
        try {
            attrDef.resolve(null);
            Assert.fail((String)"Null context not allowed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        attrDef.destroy();
        try {
            attrDef.initialize();
            Assert.fail((String)"Init after destroy");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            attrDef.resolve(new AttributeResolutionContext());
            Assert.fail((String)"Resolve after destroy");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            attrDef.setScopeDelimiter(DELIMITER);
            Assert.fail((String)"Set Delimiter after destroy");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }
}

