/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.PrincipalAuthenticationMethodAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PrincipalAuthenticationMethodAttributeDefinitionTest {
    @Test
    public void emptyMethod() throws ComponentInitializationException, ResolutionException {
        PrincipalAuthenticationMethodAttributeDefinition defn = new PrincipalAuthenticationMethodAttributeDefinition();
        defn.setId("id");
        defn.initialize();
        Assert.assertNull((Object)defn.resolve(TestSources.createResolutionContext((String)"princ", (String)"issuer", (String)"recipient")));
    }

    @Test
    public void usual() throws ComponentInitializationException, ResolutionException {
        PrincipalAuthenticationMethodAttributeDefinition defn = new PrincipalAuthenticationMethodAttributeDefinition();
        defn.setId("id");
        defn.initialize();
        AttributeResolutionContext arc = TestSources.createResolutionContext((String)"princ", (String)"issuer", (String)"recipient");
        arc.setPrincipalAuthenticationMethod("Method");
        arc.setPrincipalAuthenticationMethod("Method");
        IdPAttribute result = (IdPAttribute)defn.resolve(arc);
        Assert.assertEquals((int)result.getValues().size(), (int)1);
        StringAttributeValue value = (StringAttributeValue)result.getValues().iterator().next();
        Assert.assertEquals((String)value.getValue(), (String)"Method");
    }
}

