/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.PrincipalNameAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PrincipalNameAttributeDefinitionTest {
    @Test
    public void nullContext() throws ComponentInitializationException {
        PrincipalNameAttributeDefinition defn = new PrincipalNameAttributeDefinition();
        defn.setId("id");
        defn.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        try {
            defn.resolve(context);
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void nullName() throws ComponentInitializationException {
        PrincipalNameAttributeDefinition defn = new PrincipalNameAttributeDefinition();
        defn.setId("id");
        defn.initialize();
        try {
            defn.resolve(TestSources.createResolutionContext((String)"", (String)"issuer", (String)"recipient"));
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void normal() throws ComponentInitializationException, ResolutionException {
        PrincipalNameAttributeDefinition defn = new PrincipalNameAttributeDefinition();
        defn.setId("id");
        defn.initialize();
        IdPAttribute result = (IdPAttribute)defn.resolve(TestSources.createResolutionContext((String)"principal", (String)"issuer", (String)"recipient"));
        Assert.assertEquals((int)result.getValues().size(), (int)1);
        StringAttributeValue value = (StringAttributeValue)result.getValues().iterator().next();
        Assert.assertEquals((String)value.getValue(), (String)"principal");
    }
}

