/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.ad.impl.RegexSplitAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RegexAtributeTest {
    private static final String TEST_ATTRIBUTE_NAME = "regex";

    @Test
    public void regex() throws ResolutionException, ComponentInitializationException {
        LazySet dependencySet = new LazySet();
        ResolverPluginDependency depend = new ResolverPluginDependency("staticCon");
        depend.setDependencyAttributeId("ac1");
        dependencySet.add(depend);
        RegexSplitAttributeDefinition attrDef = new RegexSplitAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setRegularExpression(TestSources.CONNECTOR_ATTRIBUTE_VALUE_REGEXP_PATTERN);
        attrDef.setDependencies((Set)dependencySet);
        attrDef.initialize();
        LazySet connectorSet = new LazySet();
        connectorSet.add(TestSources.populatedStaticConnector());
        LazySet attributeSet = new LazySet();
        attributeSet.add(attrDef);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attributeSet, (Collection<DataConnector>)connectorSet, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        List f = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)f.size(), (int)1);
        Assert.assertTrue((boolean)f.contains(TestSources.CONNECTOR_ATTRIBUTE_VALUE_REGEXP_RESULT), (String)"looking for regexp result");
    }

    @Test
    public void nullValueType() throws ComponentInitializationException, ResolutionException {
        ArrayList<Object> values = new ArrayList<Object>(4);
        values.add(new StringAttributeValue("at1-Connector"));
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        values.add(new StringAttributeValue("three"));
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.ZERO_LENGTH_VALUE));
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(values);
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        RegexSplitAttributeDefinition attrDef = new RegexSplitAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setRegularExpression(TestSources.CONNECTOR_ATTRIBUTE_VALUE_REGEXP_PATTERN);
        attrDef.setDependencies(Collections.singleton(depend));
        attrDef.initialize();
        IdPAttribute result = (IdPAttribute)attrDef.resolve(resolutionContext);
        List f = result.getValues();
        Assert.assertEquals((int)f.size(), (int)1);
        Assert.assertTrue((boolean)f.contains(new StringAttributeValue("Connect")));
    }

    @Test
    public void invalidValueType() throws ComponentInitializationException {
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(Collections.singletonList(new ByteAttributeValue(new byte[]{1, 2, 3})));
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        RegexSplitAttributeDefinition attrDef = new RegexSplitAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setRegularExpression(TestSources.CONNECTOR_ATTRIBUTE_VALUE_REGEXP_PATTERN);
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attrDef.setDependencies(Collections.singleton(depend));
        attrDef.initialize();
        try {
            attrDef.resolve(resolutionContext);
            Assert.fail((String)"Invalid type");
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void emptyValueType() throws ResolutionException, ComponentInitializationException {
        LazySet dependencySet = new LazySet();
        ResolverPluginDependency depend = new ResolverPluginDependency("staticCon");
        depend.setDependencyAttributeId("ac1");
        dependencySet.add(depend);
        RegexSplitAttributeDefinition attrDef = new RegexSplitAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setRegularExpression(Pattern.compile("([zZ]*)at1-(.+)or"));
        attrDef.setDependencies((Set)dependencySet);
        attrDef.initialize();
        LazySet connectorSet = new LazySet();
        connectorSet.add(TestSources.populatedStaticConnector());
        LazySet attributeSet = new LazySet();
        attributeSet.add(attrDef);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attributeSet, (Collection<DataConnector>)connectorSet, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        List f = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)f.size(), (int)1);
        Assert.assertEquals(f.iterator().next(), (Object)EmptyAttributeValue.ZERO_LENGTH);
    }

    @Test
    public void initDestroyParms() throws ResolutionException, ComponentInitializationException {
        RegexSplitAttributeDefinition attrDef = new RegexSplitAttributeDefinition();
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        Set<ResolverPluginDependency> pluginDependencies = Collections.singleton(depend);
        attrDef.setDependencies(pluginDependencies);
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        try {
            attrDef.initialize();
            Assert.fail((String)"no regexp - should fail");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        try {
            attrDef.setRegularExpression(null);
            Assert.fail((String)"set null regexp");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        attrDef = new RegexSplitAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        Assert.assertNull((Object)attrDef.getRegularExpression());
        attrDef.setRegularExpression(TestSources.CONNECTOR_ATTRIBUTE_VALUE_REGEXP_PATTERN);
        try {
            attrDef.initialize();
            Assert.fail((String)"no Dependency - should fail");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        attrDef.setDependencies(pluginDependencies);
        try {
            attrDef.resolve(new AttributeResolutionContext());
            Assert.fail((String)"resolve not initialized");
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        attrDef.initialize();
        Assert.assertEquals((Object)attrDef.getRegularExpression(), (Object)TestSources.CONNECTOR_ATTRIBUTE_VALUE_REGEXP_PATTERN);
        try {
            attrDef.resolve(null);
            Assert.fail((String)"Null context not allowed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        attrDef.destroy();
        try {
            attrDef.initialize();
            Assert.fail((String)"Init after destroy");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            attrDef.setRegularExpression(TestSources.CONNECTOR_ATTRIBUTE_VALUE_REGEXP_PATTERN);
            Assert.fail((String)"setRegExp after destroy");
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        try {
            attrDef.resolve(new AttributeResolutionContext());
            Assert.fail((String)"Resolve after destroy");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }
}

