/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.saml.attribute.resolver.impl.SAML1NameIdentifierAttributeDefinition;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SAML1NameIdentifierAttributeDefinitionTest
extends OpenSAMLInitBaseTestCase {
    private static final String TEST_ATTRIBUTE_NAME = "simple";
    private static final String SECOND_ATTRIBUTE_NAME = "second";
    private static final String IDP_ENTITY_ID = "https://idp.example.org/idp";
    private static final String ALTERNATIVE_FORMAT = "ALTERNATE_FORMAT";
    private static final String ALTERNATE_QUALIFIER = "ALTERNATE_QUALIFIER";

    @Test
    public void empty() throws ResolutionException, ComponentInitializationException {
        SAML1NameIdentifierAttributeDefinition defn = new SAML1NameIdentifierAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        defn.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        defn.initialize();
        IdPAttribute result = (IdPAttribute)defn.resolve(TestSources.createResolutionContext(null, (String)IDP_ENTITY_ID, null));
        Assert.assertTrue((boolean)result.getValues().isEmpty());
    }

    @Test
    public void simple() throws ResolutionException, ComponentInitializationException {
        SAML1NameIdentifierAttributeDefinition defn = new SAML1NameIdentifierAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        defn.setDependencies((Set)dependencySet);
        defn.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        am.add(TestSources.populatedStaticAttribute());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, null, null);
        resolver.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, (String)IDP_ENTITY_ID, null);
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        List values = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)values.size(), (int)2);
        HashSet<String> nameValues = new HashSet<String>(2);
        for (IdPAttributeValue val : values) {
            NameIdentifier id = (NameIdentifier)val.getValue();
            Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            Assert.assertEquals((String)id.getNameQualifier(), (String)IDP_ENTITY_ID);
            nameValues.add(id.getValue());
        }
        Assert.assertTrue((boolean)nameValues.contains("at1-Data"));
        Assert.assertTrue((boolean)nameValues.contains("at1-Attribute"));
    }

    @Test
    public void nullValueType() throws ComponentInitializationException, ResolutionException {
        ArrayList<Object> values = new ArrayList<Object>(3);
        values.add(new StringAttributeValue("at1-Data"));
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        values.add(new StringAttributeValue("at1-Attribute"));
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(values);
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        SAML1NameIdentifierAttributeDefinition defn = new SAML1NameIdentifierAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        defn.setDependencies(Collections.singleton(depend));
        defn.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, Collections.singleton(ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})), null);
        resolver.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, (String)IDP_ENTITY_ID, null);
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        List outValues = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)outValues.size(), (int)2);
        HashSet<String> nameValues = new HashSet<String>(2);
        for (IdPAttributeValue val : outValues) {
            NameIdentifier id = (NameIdentifier)val.getValue();
            Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            Assert.assertEquals((String)id.getNameQualifier(), (String)IDP_ENTITY_ID);
            nameValues.add(id.getValue());
        }
        Assert.assertTrue((boolean)nameValues.contains("at1-Data"));
        Assert.assertTrue((boolean)nameValues.contains("at1-Attribute"));
    }

    @Test
    public void nullIssuerID() throws ComponentInitializationException {
        SAML1NameIdentifierAttributeDefinition defn = new SAML1NameIdentifierAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        defn.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        defn.setDependencies((Set)dependencySet);
        defn.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        am.add(TestSources.populatedStaticAttribute());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
            Assert.fail((String)"resolution Should have failed");
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void badValue() throws ResolutionException, ComponentInitializationException {
        AttributeDefinition defn = TestSources.nonStringAttributeDefiniton((String)TEST_ATTRIBUTE_NAME);
        SAML1NameIdentifierAttributeDefinition defn2 = new SAML1NameIdentifierAttributeDefinition();
        defn2.setId(SECOND_ATTRIBUTE_NAME);
        defn2.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        LazySet dependencySet = new LazySet();
        dependencySet.add(new ResolverPluginDependency(TEST_ATTRIBUTE_NAME));
        defn2.setDependencies((Set)dependencySet);
        defn2.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        am.add(TestSources.populatedStaticAttribute());
        am.add(defn2);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, null, null);
        resolver.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, (String)IDP_ENTITY_ID, (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        Assert.assertNull(context.getResolvedIdPAttributes().get(SECOND_ATTRIBUTE_NAME));
    }

    @Test
    public void singleValueWithOptions() throws ResolutionException, ComponentInitializationException {
        SAML1NameIdentifierAttributeDefinition defn = new SAML1NameIdentifierAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        defn.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        defn.setDependencies((Set)dependencySet);
        defn.setNameIdFormat(ALTERNATIVE_FORMAT);
        defn.setNameIdQualifier(ALTERNATE_QUALIFIER);
        defn.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        am.add(TestSources.populatedStaticAttribute((String)"staticAtt", (String)"at1", (int)1));
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, null, null);
        resolver.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, (String)IDP_ENTITY_ID, null);
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        List values = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)values.size(), (int)1);
        NameIdentifier id = (NameIdentifier)((IdPAttributeValue)values.iterator().next()).getValue();
        Assert.assertEquals((String)id.getFormat(), (String)ALTERNATIVE_FORMAT);
        Assert.assertEquals((String)defn.getNameIdFormat(), (String)id.getFormat());
        Assert.assertEquals((String)id.getNameQualifier(), (String)ALTERNATE_QUALIFIER);
        Assert.assertEquals((String)defn.getNameIdQualifier(), (String)id.getNameQualifier());
        Assert.assertEquals((String)id.getValue(), (String)"at1-Data");
    }
}

