/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.saml.attribute.resolver.impl.SAML2NameIDAttributeDefinition;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.saml.saml2.core.NameID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SAML2NameIDAttributeDefinitionTest
extends OpenSAMLInitBaseTestCase {
    private static final String TEST_ATTRIBUTE_NAME = "simple";
    private static final String SECOND_ATTRIBUTE_NAME = "second";
    private static final String ALTERNATIVE_FORMAT = "ALTERNATE_FORMAT";
    private static final String ALTERNATE_QUALIFIER = "ALTERNATE_QUALIFIER";
    private static final String ALTERNATE_SP_QUALIFIER = "ALTERNATE_SP_QUAL";

    @Test
    public void testEmpty() throws ResolutionException, ComponentInitializationException {
        SAML2NameIDAttributeDefinition defn = new SAML2NameIDAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        defn.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        defn.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        IdPAttribute result = (IdPAttribute)defn.resolve(context);
        Assert.assertTrue((boolean)result.getValues().isEmpty());
    }

    private AttributeResolver setupResolver() throws ComponentInitializationException {
        SAML2NameIDAttributeDefinition defn = new SAML2NameIDAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        defn.setDependencies((Set)dependencySet);
        defn.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        am.add(TestSources.populatedStaticAttribute());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, null, null);
        resolver.initialize();
        return resolver;
    }

    @Test
    public void simple() throws ResolutionException, ComponentInitializationException {
        AttributeResolver resolver = this.setupResolver();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        List values = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)values.size(), (int)2);
        HashSet<String> nameValues = new HashSet<String>(2);
        for (IdPAttributeValue val : values) {
            NameID id = (NameID)val.getValue();
            Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            Assert.assertNull((Object)id.getSPProvidedID());
            Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://sp.example.org/sp");
            Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
            nameValues.add(id.getValue());
        }
        Assert.assertTrue((boolean)nameValues.contains("at1-Data"));
        Assert.assertTrue((boolean)nameValues.contains("at1-Attribute"));
    }

    @Test
    public void nullValueType() throws ComponentInitializationException, ResolutionException {
        ArrayList<Object> values = new ArrayList<Object>(3);
        values.add(new StringAttributeValue("at1-Data"));
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        values.add(new StringAttributeValue("at1-Attribute"));
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(values);
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        SAML2NameIDAttributeDefinition defn = new SAML2NameIDAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        defn.setDependencies(Collections.singleton(depend));
        defn.setNameIdSPQualifier("doo");
        defn.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, Collections.singleton(ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})), null);
        resolver.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, (String)"https://idp.example.org/idp", null);
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        List outValues = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)outValues.size(), (int)2);
        HashSet<String> nameValues = new HashSet<String>(2);
        for (IdPAttributeValue val : outValues) {
            NameID id = (NameID)val.getValue();
            Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
            nameValues.add(id.getValue());
        }
        Assert.assertTrue((boolean)nameValues.contains("at1-Data"));
        Assert.assertTrue((boolean)nameValues.contains("at1-Attribute"));
    }

    @Test
    public void nulls() throws ComponentInitializationException {
        AttributeResolver resolver = this.setupResolver();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, null, (String)"https://sp.example.org/sp");
        try {
            resolver.resolveAttributes(context);
            Assert.fail((String)"null IdP EntityId should throw");
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
        resolver = this.setupResolver();
        context = TestSources.createResolutionContext(null, (String)"https://idp.example.org/idp", null);
        try {
            resolver.resolveAttributes(context);
            Assert.fail((String)"null IdP EntityId should throw");
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void badValue() throws ResolutionException, ComponentInitializationException {
        AttributeDefinition defn = TestSources.nonStringAttributeDefiniton((String)TEST_ATTRIBUTE_NAME);
        SAML2NameIDAttributeDefinition defn2 = new SAML2NameIDAttributeDefinition();
        defn2.setId(SECOND_ATTRIBUTE_NAME);
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)TEST_ATTRIBUTE_NAME, null));
        defn2.setDependencies((Set)dependencySet);
        defn2.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        am.add(TestSources.populatedStaticAttribute());
        am.add(defn2);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, null, null);
        resolver.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed");
        }
        Assert.assertNull(context.getResolvedIdPAttributes().get(SECOND_ATTRIBUTE_NAME));
    }

    @Test
    public void singleValueWithOptions() throws ResolutionException, ComponentInitializationException {
        SAML2NameIDAttributeDefinition defn = new SAML2NameIDAttributeDefinition();
        defn.setId(TEST_ATTRIBUTE_NAME);
        defn.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        defn.setDependencies((Set)dependencySet);
        defn.setNameIdFormat(ALTERNATIVE_FORMAT);
        defn.setNameIdQualifier(ALTERNATE_QUALIFIER);
        defn.setNameIdSPQualifier(ALTERNATE_SP_QUALIFIER);
        defn.initialize();
        LazySet am = new LazySet();
        am.add(defn);
        am.add(TestSources.populatedStaticAttribute((String)"staticAtt", (String)"at1", (int)1));
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, null, null);
        resolver.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext(null, (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        List values = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)values.size(), (int)1);
        NameID id = (NameID)((IdPAttributeValue)values.iterator().next()).getValue();
        Assert.assertEquals((String)id.getFormat(), (String)ALTERNATIVE_FORMAT);
        Assert.assertEquals((String)defn.getNameIdFormat(), (String)id.getFormat());
        Assert.assertNull((Object)id.getSPProvidedID());
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)ALTERNATE_SP_QUALIFIER);
        Assert.assertEquals((String)defn.getNameIdSPQualifier(), (String)id.getSPNameQualifier());
        Assert.assertEquals((String)id.getNameQualifier(), (String)ALTERNATE_QUALIFIER);
        Assert.assertEquals((String)defn.getNameIdQualifier(), (String)id.getNameQualifier());
        Assert.assertEquals((String)id.getValue(), (String)"at1-Data");
    }
}

