/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScopedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScopedAttributeTest {
    private static final String TEST_ATTRIBUTE_NAME = "scoped";
    private static final String TEST_SCOPE = "scope";

    @Test
    public void scopes() throws ResolutionException, ComponentInitializationException {
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticCon", (String)"ac1"));
        ScopedAttributeDefinition scoped = new ScopedAttributeDefinition();
        scoped.setScope(TEST_SCOPE);
        scoped.setId(TEST_ATTRIBUTE_NAME);
        scoped.setDependencies((Set)dependencySet);
        scoped.initialize();
        LazySet connectorSet = new LazySet();
        connectorSet.add(TestSources.populatedStaticConnector());
        LazySet attributeSet = new LazySet();
        attributeSet.add(scoped);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attributeSet, (Collection<DataConnector>)connectorSet, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        List f = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)f.size(), (int)2);
        Assert.assertTrue((boolean)f.contains(new ScopedStringAttributeValue("at1-Data", TEST_SCOPE)), (String)"looking for COMMON_ATTRIBUTE_VALUE");
        Assert.assertTrue((boolean)f.contains(new ScopedStringAttributeValue("at1-Data", TEST_SCOPE)), (String)"looking for CONNECTOR_ATTRIBUTE_VALUE");
    }

    @Test
    public void invalidValueType() throws ComponentInitializationException {
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(Collections.singletonList(new ByteAttributeValue(new byte[]{1, 2, 3})));
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        ScopedAttributeDefinition attrDef = new ScopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setScope(TEST_SCOPE);
        attrDef.setDependencies(new HashSet<ResolverPluginDependency>(Arrays.asList(TestSources.makeResolverPluginDependency((String)"connector1", (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1"))));
        attrDef.initialize();
        try {
            attrDef.resolve(resolutionContext);
            Assert.fail((String)"Invalid type");
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void nullValueType() throws ComponentInitializationException, ResolutionException {
        ArrayList<Object> values = new ArrayList<Object>(4);
        values.add(new StringAttributeValue("one"));
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        values.add(new StringAttributeValue("three"));
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.ZERO_LENGTH_VALUE));
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(values);
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        ScopedAttributeDefinition attrDef = new ScopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        attrDef.setScope(TEST_SCOPE);
        attrDef.setDependencies(new HashSet<ResolverPluginDependency>(Arrays.asList(TestSources.makeResolverPluginDependency((String)"connector1", (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1"))));
        attrDef.initialize();
        IdPAttribute result = (IdPAttribute)attrDef.resolve(resolutionContext);
        List f = result.getValues();
        Assert.assertEquals((int)f.size(), (int)2);
        Assert.assertTrue((boolean)f.contains(new ScopedStringAttributeValue("one", TEST_SCOPE)));
        Assert.assertTrue((boolean)f.contains(new ScopedStringAttributeValue("three", TEST_SCOPE)));
    }

    @Test
    public void initDestroyParms() throws ResolutionException, ComponentInitializationException {
        ScopedAttributeDefinition attrDef = new ScopedAttributeDefinition();
        HashSet<ResolverPluginDependency> pluginDependencies = new HashSet<ResolverPluginDependency>(Arrays.asList(TestSources.makeResolverPluginDependency((String)"connector1", (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1")));
        attrDef.setDependencies(pluginDependencies);
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        try {
            attrDef.setScope(null);
            Assert.fail((String)"set null delimiter");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        attrDef = new ScopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        Assert.assertNull((Object)attrDef.getScope());
        attrDef.setScope(TEST_SCOPE);
        try {
            attrDef.initialize();
            Assert.fail((String)"no Dependency - should fail");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        attrDef = new ScopedAttributeDefinition();
        attrDef.setId(TEST_ATTRIBUTE_NAME);
        Assert.assertNull((Object)attrDef.getScope());
        attrDef.setDependencies(pluginDependencies);
        try {
            attrDef.initialize();
            Assert.fail((String)"no Scope - should fail");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        try {
            attrDef.resolve(new AttributeResolutionContext());
            Assert.fail((String)"resolve not initialized");
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        attrDef.setScope(TEST_SCOPE);
        attrDef.initialize();
        Assert.assertEquals((String)attrDef.getScope(), (String)TEST_SCOPE);
        try {
            attrDef.resolve(null);
            Assert.fail((String)"Null context not allowed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        attrDef.destroy();
        try {
            attrDef.initialize();
            Assert.fail((String)"Init after destroy");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            attrDef.resolve(new AttributeResolutionContext());
            Assert.fail((String)"Resolve after destroy");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            attrDef.setScope(TEST_SCOPE);
            Assert.fail((String)"Set Delimiter after destroy");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }
}

