/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.impl.SAMLAttributeDataConnector;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import net.shibboleth.utilities.java.support.testing.TestSupport;
import org.apache.commons.codec.digest.DigestUtils;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptedAttributeTest
extends XMLObjectBaseTestCase {
    private static final String TEST_ATTRIBUTE_NAME = "Scripted";
    private static final String SCRIPT_LANGUAGE = "JavaScript";
    private static final String SIMPLE_VALUE = "simple";
    private static Logger log = LoggerFactory.getLogger(ScriptedAttributeTest.class);

    private String fileNameToPath(String fileName, boolean isV8Capable) {
        if (TestSupport.isJavaV8OrLater() && !isV8Capable) {
            return "/net/shibboleth/idp/attribute/resolver/impl/ad/jdk8/" + fileName;
        }
        return "/net/shibboleth/idp/attribute/resolver/impl/ad/" + fileName;
    }

    private String getScript(String fileName, boolean isV8Capable) throws IOException {
        return StringSupport.inputStreamToString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.fileNameToPath(fileName, isV8Capable)), null);
    }

    private String getScript(String fileName) throws IOException {
        return this.getScript(fileName, true);
    }

    @Test
    public void simple() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        IdPAttribute test = new IdPAttribute(TEST_ATTRIBUTE_NAME);
        test.setValues(Collections.singletonList(new StringAttributeValue(SIMPLE_VALUE)));
        ScriptedAttributeDefinition attr = new ScriptedAttributeDefinition();
        Assert.assertNull((Object)attr.getScript());
        attr.setId(TEST_ATTRIBUTE_NAME);
        attr.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("simple.script")));
        attr.initialize();
        Assert.assertNotNull((Object)attr.getScript());
        IdPAttribute val = (IdPAttribute)attr.resolve(ScriptedAttributeTest.generateContext());
        List results = val.getValues();
        Assert.assertTrue((boolean)test.equals((Object)val), (String)"Scripted result is the same as bases");
        Assert.assertEquals((int)results.size(), (int)1, (String)"Scripted result value count");
        Assert.assertEquals((Object)((IdPAttributeValue)results.iterator().next()).getValue(), (Object)SIMPLE_VALUE, (String)"Scripted result contains known value");
    }

    @Test
    public void subject() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        IdPAttribute test = new IdPAttribute(TEST_ATTRIBUTE_NAME);
        test.setValues(Collections.singletonList(new StringAttributeValue(SIMPLE_VALUE)));
        ScriptedAttributeDefinition attr = new ScriptedAttributeDefinition();
        Assert.assertNull((Object)attr.getScript());
        attr.setId(TEST_ATTRIBUTE_NAME);
        attr.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("subjects.script")));
        attr.initialize();
        Assert.assertNotNull((Object)attr.getScript());
        IdPAttribute val = (IdPAttribute)attr.resolve(ScriptedAttributeTest.generateContext());
        List results = val.getValues();
        Assert.assertTrue((boolean)test.equals((Object)val), (String)"Scripted result is the same as bases");
        Assert.assertEquals((int)results.size(), (int)4, (String)"Scripted result value count");
        Assert.assertTrue((boolean)results.contains(new StringAttributeValue(SIMPLE_VALUE)));
        Assert.assertTrue((boolean)results.contains(new StringAttributeValue("simple2")));
        Assert.assertTrue((boolean)results.contains(new StringAttributeValue("simple3")));
        Assert.assertTrue((boolean)results.contains(new StringAttributeValue("simple4")));
    }

    @Test
    public void custom() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        IdPAttribute test = new IdPAttribute(TEST_ATTRIBUTE_NAME);
        test.setValues(Collections.singletonList(new StringAttributeValue(SIMPLE_VALUE)));
        ScriptedAttributeDefinition attr = new ScriptedAttributeDefinition();
        Assert.assertNull((Object)attr.getScript());
        attr.setId(TEST_ATTRIBUTE_NAME);
        attr.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("custom.script")));
        attr.setCustomObject(test.getValues().get(0));
        attr.initialize();
        Assert.assertNotNull((Object)attr.getScript());
        IdPAttribute val = (IdPAttribute)attr.resolve(ScriptedAttributeTest.generateContext());
        List results = val.getValues();
        Assert.assertTrue((boolean)test.equals((Object)val), (String)"Scripted result is the same as bases");
        Assert.assertEquals((int)results.size(), (int)1, (String)"Scripted result value count");
        Assert.assertEquals((Object)((IdPAttributeValue)results.get(0)).getValue(), (Object)SIMPLE_VALUE, (String)"Scripted result contains known value");
    }

    @Test
    public void simple2() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        IdPAttribute test = new IdPAttribute(TEST_ATTRIBUTE_NAME);
        test.setValues(Collections.singletonList(new StringAttributeValue(SIMPLE_VALUE)));
        ScriptedAttributeDefinition attr = new ScriptedAttributeDefinition();
        Assert.assertNull((Object)attr.getScript());
        attr.setId(TEST_ATTRIBUTE_NAME);
        attr.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("simple2.script", false)));
        attr.initialize();
        Assert.assertNotNull((Object)attr.getScript());
        IdPAttribute val = (IdPAttribute)attr.resolve(ScriptedAttributeTest.generateContext());
        List results = val.getValues();
        Assert.assertTrue((boolean)test.equals((Object)val), (String)"Scripted result is the same as bases");
        Assert.assertEquals((int)results.size(), (int)1, (String)"Scripted result value count");
        Assert.assertEquals((Object)((IdPAttributeValue)results.iterator().next()).getValue(), (Object)SIMPLE_VALUE, (String)"Scripted result contains known value");
    }

    @Test
    public void nullValue() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        IdPAttribute test = new IdPAttribute(TEST_ATTRIBUTE_NAME);
        test.setValues(Collections.singletonList(new StringAttributeValue(SIMPLE_VALUE)));
        ScriptedAttributeDefinition attr = new ScriptedAttributeDefinition();
        Assert.assertNull((Object)attr.getScript());
        attr.setId(TEST_ATTRIBUTE_NAME);
        attr.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("nullValue.script", false)));
        attr.initialize();
        Assert.assertNotNull((Object)attr.getScript());
        IdPAttribute val = (IdPAttribute)attr.resolve(ScriptedAttributeTest.generateContext());
        List results = val.getValues();
        Assert.assertEquals((int)results.size(), (int)1, (String)"Scripted result value count");
        Assert.assertEquals(results.iterator().next(), (Object)new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE), (String)"Scripted result contains expected value");
    }

    @Test
    public void logging() throws Exception {
        IdPAttribute test = new IdPAttribute(TEST_ATTRIBUTE_NAME);
        test.setValues(Collections.singletonList(new StringAttributeValue(SIMPLE_VALUE)));
        ScriptedAttributeDefinition attr = new ScriptedAttributeDefinition();
        Assert.assertNull((Object)attr.getScript());
        attr.setId(TEST_ATTRIBUTE_NAME);
        attr.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("logging.script", false)));
        attr.initialize();
        IdPAttribute val = (IdPAttribute)attr.resolve(ScriptedAttributeTest.generateContext());
        List results = val.getValues();
        Assert.assertEquals((int)results.size(), (int)2, (String)"Scripted result value count");
    }

    @Test
    public void simpleWithPredef() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        IdPAttribute test = new IdPAttribute(TEST_ATTRIBUTE_NAME);
        StringAttributeValue attributeValue = new StringAttributeValue(SIMPLE_VALUE);
        test.setValues(Collections.singletonList(attributeValue));
        ScriptedAttributeDefinition attr = new ScriptedAttributeDefinition();
        Assert.assertNull((Object)attr.getScript());
        attr.setId(TEST_ATTRIBUTE_NAME);
        attr.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("simpleWithPredef.script", false)));
        attr.initialize();
        Assert.assertNotNull((Object)attr.getScript());
        IdPAttribute val = (IdPAttribute)attr.resolve(ScriptedAttributeTest.generateContext());
        List results = val.getValues();
        Assert.assertTrue((boolean)test.equals((Object)val), (String)"Scripted result is the same as bases");
        Assert.assertEquals((int)results.size(), (int)1, (String)"Scripted result value count");
        Assert.assertEquals(results.iterator().next(), (Object)attributeValue, (String)"Scripted result contains known value");
    }

    private ScriptedAttributeDefinition buildTest(String failingScript, boolean v8Safe) throws ScriptException, IOException, ComponentInitializationException {
        ScriptedAttributeDefinition attr = new ScriptedAttributeDefinition();
        attr.setId(TEST_ATTRIBUTE_NAME);
        try {
            attr.initialize();
            Assert.fail((String)"No script defined");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        attr.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript(failingScript, v8Safe)));
        attr.initialize();
        return attr;
    }

    private void failureTest(String failingScript, String failingMessage, boolean v8Safe) throws ScriptException, IOException, ComponentInitializationException {
        try {
            this.buildTest(failingScript, v8Safe).resolve(ScriptedAttributeTest.generateContext());
            Assert.fail((String)("Script: '" + failingScript + "' should have thrown an exception: " + failingMessage));
        }
        catch (ResolutionException ex) {
            log.trace("Successful exception", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            if (TestSupport.isJavaV8OrLater() && ex.getCause() instanceof ResolutionException) {
                log.trace("Successful exception", (Throwable)ex);
            }
            throw ex;
        }
    }

    @Test
    public void fails() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        this.failureTest("fail1.script", "Unknown method", true);
        this.failureTest("fail2.script", "Bad output type", true);
        if (!TestSupport.isJavaV8OrLater()) {
            Assert.assertNull((Object)this.buildTest("fail3.script", true).resolve(ScriptedAttributeTest.generateContext()), (String)"returns nothing");
        }
        this.failureTest("fail4.script", "getValues, then getNativeAttributes", true);
        this.failureTest("fail5.script", "getNativeAttributes, then getValues", true);
        this.failureTest("fail6.script", "bad type added", false);
    }

    @Test
    public void addAfterGetValues() throws ResolutionException, ScriptException, IOException, ComponentInitializationException {
        IdPAttribute result = (IdPAttribute)this.buildTest("addAfterGetValues.script", true).resolve(ScriptedAttributeTest.generateContext());
        List values = result.getValues();
        Assert.assertEquals((int)values.size(), (int)1);
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("newValue")));
    }

    @Test
    public void attributes() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        LazySet ds = new LazySet();
        ds.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        ScriptedAttributeDefinition scripted = new ScriptedAttributeDefinition();
        scripted.setId(TEST_ATTRIBUTE_NAME);
        scripted.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("attributes.script")));
        scripted.setDependencies((Set)ds);
        scripted.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(scripted);
        attrDefinitions.add(TestSources.populatedStaticAttribute());
        LazySet dataDefinitions = new LazySet();
        dataDefinitions.add(TestSources.populatedStaticConnector());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, (Collection<DataConnector>)dataDefinitions, null);
        resolver.initialize();
        AttributeResolutionContext context = ScriptedAttributeTest.generateContext();
        resolver.resolveAttributes(context);
        IdPAttribute attribute = (IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME);
        List values = attribute.getValues();
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertTrue((boolean)values.contains(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT));
        Assert.assertTrue((boolean)values.contains(TestSources.ATTRIBUTE_ATTRIBUTE_VALUE_RESULT));
    }

    @Test
    public void workContext() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        LazySet ds = new LazySet();
        ds.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        ScriptedAttributeDefinition scripted = new ScriptedAttributeDefinition();
        scripted.setId(TEST_ATTRIBUTE_NAME);
        scripted.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("work.script")));
        scripted.setDependencies((Set)ds);
        scripted.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(scripted);
        attrDefinitions.add(TestSources.populatedStaticAttribute());
        LazySet dataDefinitions = new LazySet();
        dataDefinitions.add(TestSources.populatedStaticConnector());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, (Collection<DataConnector>)dataDefinitions, null);
        resolver.initialize();
        AttributeResolutionContext context = ScriptedAttributeTest.generateContext();
        resolver.resolveAttributes(context);
        IdPAttribute attribute = (IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME);
        List values = attribute.getValues();
        Assert.assertEquals((int)values.size(), (int)3);
        Assert.assertTrue((boolean)values.contains(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT));
    }

    @Test
    public void attributesWithNull() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        ArrayList<Object> values = new ArrayList<Object>(3);
        values.add(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT);
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        IdPAttribute attr = new IdPAttribute("at1");
        attr.setValues(values);
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("at1");
        ScriptedAttributeDefinition scripted = new ScriptedAttributeDefinition();
        scripted.setId(TEST_ATTRIBUTE_NAME);
        scripted.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("attributes.script")));
        scripted.setDependencies(Collections.singleton(depend));
        scripted.initialize();
        IdPAttribute result = (IdPAttribute)scripted.resolve(resolutionContext);
        List outValues = result.getValues();
        Assert.assertEquals((int)outValues.size(), (int)2);
        Assert.assertTrue((boolean)values.contains(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT));
        Assert.assertTrue((boolean)values.contains(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE)));
    }

    @Test
    public void nonString() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        LazySet ds = new LazySet();
        ds.add(TestSources.makeResolverPluginDependency((String)"at1", null));
        ScriptedAttributeDefinition scripted = new ScriptedAttributeDefinition();
        scripted.setId(TEST_ATTRIBUTE_NAME);
        scripted.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("attributes2.script")));
        scripted.setDependencies((Set)ds);
        scripted.initialize();
        HashSet<AttributeDefinition> attrDefinitions = new HashSet<AttributeDefinition>(3);
        attrDefinitions.add((AttributeDefinition)scripted);
        AttributeDefinition nonString = TestSources.nonStringAttributeDefiniton((String)"at1");
        attrDefinitions.add(nonString);
        attrDefinitions.add(TestSources.populatedStaticAttribute());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", attrDefinitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = ScriptedAttributeTest.generateContext();
        resolver.resolveAttributes(context);
        IdPAttribute attribute = (IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME);
        List values = attribute.getValues();
        Assert.assertEquals((int)values.size(), (int)2);
        for (IdPAttributeValue value : values) {
            if (value instanceof XMLObjectAttributeValue) continue;
            Assert.fail((String)("Wrong type: " + value.getClass().getName()));
        }
    }

    @Test
    public void context() throws ResolutionException, ComponentInitializationException, ScriptException, IOException {
        LazySet ds = new LazySet();
        ds.add(TestSources.makeResolverPluginDependency((String)"staticCon", (String)"ac1"));
        ScriptedAttributeDefinition scripted = new ScriptedAttributeDefinition();
        scripted.setId(TEST_ATTRIBUTE_NAME);
        scripted.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("context.script", false)));
        scripted.setDependencies((Set)ds);
        scripted.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(scripted);
        attrDefinitions.add(TestSources.populatedStaticAttribute());
        LazySet dataDefinitions = new LazySet();
        dataDefinitions.add(TestSources.populatedStaticConnector());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, (Collection<DataConnector>)dataDefinitions, null);
        resolver.initialize();
        AttributeResolutionContext context = ScriptedAttributeTest.generateContext();
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        IdPAttribute attribute = (IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME);
        List values = attribute.getValues();
        Assert.assertEquals((int)values.size(), (int)5, (String)"looking for context");
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("AttributeResolutionContext")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("ProfileRequestContext")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("PETER_THE_PRINCIPAL")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("https://idp.example.org/idp")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("https://sp.example.org/sp")));
    }

    protected IdPAttribute runExample(String exampleScript, String exampleData, String attributeName) throws ScriptException, IOException, ComponentInitializationException {
        SAMLAttributeDataConnector connector = new SAMLAttributeDataConnector();
        connector.setAttributesStrategy(new Locator(exampleData));
        connector.setId("Connector");
        Set<ResolverPluginDependency> ds = Collections.singleton(TestSources.makeResolverPluginDependency((String)"Connector", null));
        ScriptedAttributeDefinition scripted = new ScriptedAttributeDefinition();
        scripted.setId(attributeName);
        scripted.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript(exampleScript, false)));
        scripted.setDependencies(ds);
        Set<SAMLAttributeDataConnector> dataDefinitions = Collections.singleton(connector);
        Set<ScriptedAttributeDefinition> attrDefinitions = Collections.singleton(scripted);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", attrDefinitions, dataDefinitions, null);
        connector.initialize();
        scripted.initialize();
        resolver.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"principal", (String)"issuer", (String)"recipient");
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        return (IdPAttribute)context.getResolvedIdPAttributes().get(attributeName);
    }

    @Test
    public void examples() throws ScriptException, IOException, ComponentInitializationException {
        IdPAttribute attribute = this.runExample("example1.script", "example1.attribute.xml", "swissEduPersonUniqueID");
        Assert.assertEquals((Object)((IdPAttributeValue)attribute.getValues().iterator().next()).getValue(), (Object)(DigestUtils.md5Hex((String)"12345678some#salt#value#12345679") + "@switch.ch"));
        attribute = this.runExample("example2.script", "example2.attribute.xml", "eduPersonAffiliation");
        HashSet set = new HashSet(attribute.getValues());
        Assert.assertEquals((int)set.size(), (int)3);
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("affiliate")));
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("student")));
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("staff")));
        attribute = this.runExample("example3.script", "example3.attribute.xml", "eduPersonAffiliation");
        set = new HashSet(attribute.getValues());
        Assert.assertEquals((int)set.size(), (int)2);
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("member")));
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("staff")));
        attribute = this.runExample("example3.script", "example3.attribute.2.xml", "eduPersonAffiliation");
        set = new HashSet(attribute.getValues());
        Assert.assertEquals((int)set.size(), (int)3);
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("member")));
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("staff")));
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("walkin")));
        attribute = this.runExample("example4.script", "example4.attribute.xml", "eduPersonEntitlement");
        set = new HashSet(attribute.getValues());
        Assert.assertEquals((int)set.size(), (int)1);
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("urn:mace:dir:entitlement:common-lib-terms")));
        attribute = this.runExample("example4.script", "example4.attribute.2.xml", "eduPersonEntitlement");
        set = new HashSet(attribute.getValues());
        Assert.assertEquals((int)set.size(), (int)2);
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("urn:mace:dir:entitlement:common-lib-terms")));
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("LittleGreenMen")));
        attribute = this.runExample("example4.script", "example4.attribute.3.xml", "eduPersonEntitlement");
        Assert.assertNull((Object)attribute);
    }

    @Test
    public void v2Context() throws IOException, ComponentInitializationException, ResolutionException, ScriptException {
        ScriptedAttributeDefinition scripted = new ScriptedAttributeDefinition();
        scripted.setId("scripted");
        scripted.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("requestContext.script")));
        scripted.initialize();
        IdPAttribute result = (IdPAttribute)scripted.resolve(ScriptedAttributeTest.generateContext());
        HashSet set = new HashSet(result.getValues());
        Assert.assertEquals((int)set.size(), (int)3);
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("PETER_THE_PRINCIPAL")));
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("https://idp.example.org/idp")));
        Assert.assertTrue((boolean)set.contains(new StringAttributeValue("https://sp.example.org/sp")));
    }

    @Test
    public void unimplementedV2Context() throws IOException, ComponentInitializationException, ResolutionException, ScriptException {
        ScriptedAttributeDefinition scripted = new ScriptedAttributeDefinition();
        scripted.setId("scripted");
        scripted.setScript(new EvaluableScript(SCRIPT_LANGUAGE, this.getScript("requestContextUnimplemented.script")));
        scripted.initialize();
        IdPAttribute result = (IdPAttribute)scripted.resolve(ScriptedAttributeTest.generateContext());
        Assert.assertEquals(result.getValues().iterator().next(), (Object)new StringAttributeValue("AllDone"));
    }

    private static AttributeResolutionContext generateContext() {
        AttributeResolutionContext ctx = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        SubjectContext sc = (SubjectContext)ctx.getParent().getSubcontext(SubjectContext.class, true);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal(SIMPLE_VALUE));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple2"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        subject = new Subject();
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple3"));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("simple4"));
        authnResults.put("two", new AuthenticationResult("2", subject));
        return ctx;
    }

    final class Locator
    implements Function<AttributeResolutionContext, List<Attribute>> {
        final EntityAttributes obj;

        public Locator(String file) {
            this.obj = (EntityAttributes)ScriptedAttributeTest.this.unmarshallElement(ScriptedAttributeTest.this.fileNameToPath(file, true));
        }

        @Nullable
        public List<Attribute> apply(@Nullable AttributeResolutionContext input) {
            return this.obj.getAttributes();
        }
    }
}

