/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.ad.impl.SimpleAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleAttributeTest {
    private static final String TEST_ATTRIBUTE_NAME = "simple";

    @Test
    public void empty() throws ResolutionException, ComponentInitializationException {
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(TEST_ATTRIBUTE_NAME);
        try {
            simple.initialize();
            Assert.fail((String)"no dependencies");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        simple.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        simple.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        IdPAttribute result = (IdPAttribute)simple.resolve(context);
        Assert.assertTrue((boolean)result.getValues().isEmpty());
    }

    @Test
    public void dataConnector() throws ComponentInitializationException {
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(TEST_ATTRIBUTE_NAME);
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticCon", (String)"ac1"));
        simple.setDependencies((Set)dependencySet);
        simple.initialize();
        LazySet connectorSet = new LazySet();
        connectorSet.add(TestSources.populatedStaticConnector());
        LazySet attributeSet = new LazySet();
        attributeSet.add(simple);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attributeSet, (Collection<DataConnector>)connectorSet, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        List values = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertTrue((boolean)values.contains(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT), (String)"looking for at1-Data");
        Assert.assertTrue((boolean)values.contains(TestSources.CONNECTOR_ATTRIBUTE_VALUE_RESULT), (String)"looking for at1-Connector");
    }

    @Test
    public void attribute() throws ComponentInitializationException {
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(TEST_ATTRIBUTE_NAME);
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        simple.setDependencies((Set)dependencySet);
        simple.initialize();
        LazySet am = new LazySet();
        am.add(simple);
        am.add(TestSources.populatedStaticAttribute());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)am, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        List values = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertTrue((boolean)values.contains(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT), (String)"looking for value at1-Data");
        Assert.assertTrue((boolean)values.contains(TestSources.ATTRIBUTE_ATTRIBUTE_VALUE_RESULT), (String)"looking for value at1-Attribute");
    }

    @Test
    public void nullValue() throws ResolutionException, ComponentInitializationException {
        ArrayList<Object> values = new ArrayList<Object>(3);
        values.add(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT);
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        IdPAttribute attr = new IdPAttribute("at1");
        attr.setValues(values);
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("at1");
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(TEST_ATTRIBUTE_NAME);
        simple.setDependencies(Collections.singleton(depend));
        simple.initialize();
        IdPAttribute result = (IdPAttribute)simple.resolve(resolutionContext);
        List outValues = result.getValues();
        Assert.assertEquals((int)outValues.size(), (int)2);
        Assert.assertTrue((boolean)outValues.contains(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT));
        Assert.assertTrue((boolean)outValues.contains(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE)));
    }

    @Test
    public void both() throws ComponentInitializationException {
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(TEST_ATTRIBUTE_NAME);
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticCon", (String)"ac1"));
        simple.setDependencies((Set)dependencySet);
        simple.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(simple);
        attrDefinitions.add(TestSources.populatedStaticAttribute());
        LazySet dataDefinitions = new LazySet();
        dataDefinitions.add(TestSources.populatedStaticConnector());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, (Collection<DataConnector>)dataDefinitions, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"resolution failed", (Throwable)e);
        }
        List values = ((IdPAttribute)context.getResolvedIdPAttributes().get(TEST_ATTRIBUTE_NAME)).getValues();
        Assert.assertTrue((boolean)values.contains(TestSources.COMMON_ATTRIBUTE_VALUE_RESULT), (String)"looking for value at1-Data");
        Assert.assertTrue((boolean)values.contains(TestSources.ATTRIBUTE_ATTRIBUTE_VALUE_RESULT), (String)"looking for value at1-Attribute");
        Assert.assertTrue((boolean)values.contains(TestSources.CONNECTOR_ATTRIBUTE_VALUE_RESULT), (String)"looking for value at1-Connector");
        Assert.assertEquals((int)values.size(), (int)3);
    }
}

