/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.Arrays;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.StaticAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StaticAttributeDefinitionTest {
    @Test
    public void resolve() throws ComponentInitializationException, ResolutionException {
        StaticAttributeDefinition attrDef = new StaticAttributeDefinition();
        attrDef.setId("Static");
        Assert.assertNull((Object)attrDef.getValue());
        attrDef.setValue(null);
        Assert.assertNull((Object)attrDef.getValue());
        try {
            attrDef.initialize();
            Assert.fail((String)"Cannot initialize without an attribute");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        IdPAttribute attribute = new IdPAttribute("attribute");
        attribute.setValues(Arrays.asList(new StringAttributeValue("one"), new StringAttributeValue("two")));
        attrDef.setValue(attribute);
        Assert.assertNotNull((Object)attrDef.getValue());
        try {
            attrDef.resolve(new AttributeResolutionContext());
            Assert.fail((String)"Need to be initialized to resolve");
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        attrDef.initialize();
        Assert.assertNotNull((Object)attrDef.getValue());
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        IdPAttribute result = (IdPAttribute)attrDef.resolve(context);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result.getId(), (String)"attribute");
        try {
            attrDef.setValue(new IdPAttribute("other"));
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        attrDef.destroy();
        try {
            attrDef.initialize();
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            attrDef.setValue(new IdPAttribute("other"));
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            attrDef.resolve(new AttributeResolutionContext());
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }
}

