/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ad.impl.StaticAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ad.impl.TemplateAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.velocity.app.VelocityEngine;
import org.testng.Assert;
import org.testng.annotations.Test;

@ThreadSafe
public class TemplateAttributeTest {
    private static final String TEST_ATTRIBUTE_BASE_NAME = "TEMPLATE";
    private static final String SIMPLE_VALUE_STRING = "simple";
    private static final StringAttributeValue SIMPLE_VALUE_RESULT = new StringAttributeValue("simple");
    private static final String TEST_SIMPLE_TEMPLATE = "simple";
    private static final String TEST_ATTRIBUTES_TEMPLATE_ATTR = "Att ${at1}-${at2}";
    private static final String TEST_ATTRIBUTES_TEMPLATE_CONNECTOR = "Att ${at1}-${at2}";
    private static VelocityEngine engineSingleton;

    private VelocityEngine getEngine() {
        if (null == engineSingleton) {
            engineSingleton = new VelocityEngine();
            try {
                engineSingleton.addProperty("string.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.StringResourceLoader");
                engineSingleton.addProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                engineSingleton.addProperty("resource.loader", (Object)"classpath, string");
                engineSingleton.init();
            }
            catch (Exception e) {
                Assert.fail((String)"couldn't create engine", (Throwable)e);
            }
        }
        return engineSingleton;
    }

    @Test
    public void simple() throws ResolutionException, ComponentInitializationException {
        String name = "TEMPLATE1";
        TemplateAttributeDefinition attr = new TemplateAttributeDefinition();
        attr.setId("TEMPLATE1");
        Assert.assertNull((Object)attr.getTemplate());
        attr.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        try {
            attr.initialize();
            Assert.fail((String)"No template");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        attr = new TemplateAttributeDefinition();
        attr.setId("TEMPLATE1");
        Assert.assertNull((Object)attr.getTemplateText());
        attr.setTemplateText("Att ${at1}-${at2}");
        Assert.assertNull((Object)attr.getVelocityEngine());
        attr.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        try {
            attr.initialize();
            Assert.fail((String)"engine");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        attr = new TemplateAttributeDefinition();
        attr.setId("TEMPLATE1");
        attr.setVelocityEngine(this.getEngine());
        attr.setTemplateText("Att ${at1}-${at2}");
        try {
            attr.initialize();
            Assert.fail((String)"No dependencies");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)attr.getTemplateText());
        attr.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        attr.initialize();
        Assert.assertNotNull((Object)attr.getTemplate());
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        IdPAttribute val = (IdPAttribute)attr.resolve(context);
        List results = val.getValues();
        Assert.assertEquals((int)results.size(), (int)0, (String)"Templated value count");
        attr = new TemplateAttributeDefinition();
        attr.setId("TEMPLATE1");
        attr.setVelocityEngine(this.getEngine());
        attr.setTemplateText("Att ${at1}-${at2}");
        attr.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        attr.setSourceAttributes(Collections.singletonList("at1"));
        attr.initialize();
        Assert.assertNotNull((Object)attr.getTemplate());
        try {
            attr.resolve(context);
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
        attr = new TemplateAttributeDefinition();
        attr.setId("TEMPLATE1");
        attr.setVelocityEngine(this.getEngine());
        attr.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"foo", (String)"bar")));
        try {
            attr.initialize();
            Assert.fail((String)"No Text or attributes");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        attr.setSourceAttributes(Collections.singletonList("at1"));
        attr.initialize();
        Assert.assertEquals((String)attr.getTemplateText(), (String)"${at1} ");
        Assert.assertEquals((String)((String)attr.getSourceAttributes().get(0)), (String)"at1");
        Assert.assertEquals((int)attr.getSourceAttributes().size(), (int)1);
    }

    @Test
    public void simpleWithValues() throws ResolutionException, ComponentInitializationException {
        String name = "TEMPLATE2";
        TemplateAttributeDefinition templateDef = new TemplateAttributeDefinition();
        templateDef.setId("TEMPLATE2");
        templateDef.setVelocityEngine(this.getEngine());
        templateDef.setTemplateText("simple");
        LazySet ds = new LazySet();
        ds.add(new ResolverPluginDependency("staticAtt"));
        templateDef.setDependencies((Set)ds);
        templateDef.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(templateDef);
        attrDefinitions.add(TestSources.populatedStaticAttribute());
        LazySet dataDefinitions = new LazySet();
        dataDefinitions.add(TestSources.populatedStaticConnector());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, (Collection<DataConnector>)dataDefinitions, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        IdPAttribute a = (IdPAttribute)context.getResolvedIdPAttributes().get("TEMPLATE2");
        List results = a.getValues();
        Assert.assertEquals((int)results.size(), (int)1, (String)"Templated value count");
        Assert.assertTrue((boolean)results.contains(SIMPLE_VALUE_RESULT), (String)"Single value context is correct");
    }

    @Test
    public void templateWithValues() throws ResolutionException, ComponentInitializationException {
        this.templateWithValues(false);
    }

    @Test
    public void templateWithValuesTestSources() throws ResolutionException, ComponentInitializationException {
        this.templateWithValues(false);
    }

    private final void templateWithValues(boolean setSources) throws ResolutionException, ComponentInitializationException {
        String name = "TEMPLATE3";
        TemplateAttributeDefinition templateDef = new TemplateAttributeDefinition();
        templateDef.setId("TEMPLATE3");
        templateDef.setVelocityEngine(this.getEngine());
        templateDef.setTemplateText("Att ${at1}-${at2}");
        LazySet ds = new LazySet();
        ds.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        ds.add(TestSources.makeResolverPluginDependency((String)"staticCon", (String)"at2"));
        templateDef.setDependencies((Set)ds);
        if (setSources) {
            templateDef.setSourceAttributes(Collections.singletonList("at1"));
        }
        templateDef.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(templateDef);
        attrDefinitions.add(TestSources.populatedStaticAttribute());
        LazySet dataDefinitions = new LazySet();
        dataDefinitions.add(TestSources.populatedStaticConnector());
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, (Collection<DataConnector>)dataDefinitions, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        IdPAttribute a = (IdPAttribute)context.getResolvedIdPAttributes().get("TEMPLATE3");
        List results = a.getValues();
        Assert.assertEquals((int)results.size(), (int)2, (String)"Templated value count");
        String s = "Att at1-Data-" + TestSources.SECOND_ATTRIBUTE_VALUE_STRINGS[0];
        Assert.assertTrue((boolean)results.contains(new StringAttributeValue(s)), (String)"First Match");
        s = "Att at1-Attribute-" + TestSources.SECOND_ATTRIBUTE_VALUE_STRINGS[1];
        Assert.assertTrue((boolean)results.contains(new StringAttributeValue(s)), (String)"Second Match");
    }

    @Test
    public void emptyValues() throws ResolutionException, ComponentInitializationException {
        String name = "TEMPLATE3";
        TemplateAttributeDefinition templateDef = new TemplateAttributeDefinition();
        templateDef.setId("TEMPLATE3");
        templateDef.setVelocityEngine(this.getEngine());
        templateDef.setTemplateText("Att ${at1}");
        LazySet ds = new LazySet();
        ds.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        templateDef.setDependencies((Set)ds);
        templateDef.initialize();
        ArrayList<EmptyAttributeValue> values = new ArrayList<EmptyAttributeValue>();
        values.add(EmptyAttributeValue.ZERO_LENGTH);
        values.add(EmptyAttributeValue.NULL);
        IdPAttribute attr = new IdPAttribute("at1");
        attr.setValues(values);
        StaticAttributeDefinition simple = new StaticAttributeDefinition();
        simple.setId("staticAtt");
        simple.setValue(attr);
        simple.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(templateDef);
        attrDefinitions.add(simple);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, Collections.EMPTY_SET, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        IdPAttribute a = (IdPAttribute)context.getResolvedIdPAttributes().get("TEMPLATE3");
        List results = a.getValues();
        Assert.assertEquals((int)results.size(), (int)2, (String)"Templated value count");
        Assert.assertTrue((boolean)results.contains(new StringAttributeValue("Att ")), (String)"First Match");
        Assert.assertTrue((boolean)results.contains(new StringAttributeValue("Att ${at1}")), (String)"Second Match");
    }

    @Test
    public void failMisMatchCount() throws ResolutionException, ComponentInitializationException {
        String name = "TEMPLATE3";
        TemplateAttributeDefinition templateDef = new TemplateAttributeDefinition();
        templateDef.setId("TEMPLATE3");
        templateDef.setVelocityEngine(this.getEngine());
        templateDef.setTemplateText("Att ${at1}-${at2}");
        String otherDefName = "staticAtt2";
        String otherAttrName = "at12";
        LazySet ds = new LazySet();
        ds.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        ds.add(TestSources.makeResolverPluginDependency((String)"staticAtt2", (String)"at12"));
        templateDef.setDependencies((Set)ds);
        templateDef.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(templateDef);
        attrDefinitions.add(TestSources.populatedStaticAttribute());
        attrDefinitions.add(TestSources.populatedStaticAttribute((String)"staticAtt2", (String)"at12", (int)1));
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, Collections.EMPTY_SET, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
            Assert.fail();
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void wrongType() throws ResolutionException, ComponentInitializationException {
        String name = "TEMPLATE3";
        TemplateAttributeDefinition templateDef = new TemplateAttributeDefinition();
        templateDef.setId("TEMPLATE3");
        templateDef.setVelocityEngine(this.getEngine());
        templateDef.setTemplateText("Att ${at1}-${at2}");
        LazySet ds = new LazySet();
        ds.add(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1"));
        templateDef.setDependencies((Set)ds);
        templateDef.initialize();
        IdPAttribute attr = new IdPAttribute("at1");
        attr.setValues(Collections.singletonList(new ByteAttributeValue(new byte[]{1, 2, 3})));
        StaticAttributeDefinition simple = new StaticAttributeDefinition();
        simple.setId("staticAtt");
        simple.setValue(attr);
        simple.initialize();
        LazySet attrDefinitions = new LazySet();
        attrDefinitions.add(templateDef);
        attrDefinitions.add(simple);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)attrDefinitions, Collections.EMPTY_SET, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
            Assert.fail();
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }
}

