/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.mapped.impl;

import java.util.Collections;
import java.util.Set;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.MappedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.SourceValueTest;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.ValueMap;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MappedAttributeTest {
    private static final String TEST_ATTRIBUTE_NAME = "mapped";

    @Test
    public void instantiation() throws ComponentInitializationException, ResolutionException {
        MappedAttributeDefinition definition = new MappedAttributeDefinition();
        definition.setId(TEST_ATTRIBUTE_NAME);
        Assert.assertFalse((boolean)definition.isPassThru());
        try {
            definition.initialize();
            Assert.fail((String)"Initialized without dependencies and value mappings");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        LazySet dependencySet = new LazySet();
        dependencySet.add(TestSources.makeResolverPluginDependency((String)"staticCon", (String)"ac1"));
        definition.setDependencies((Set)dependencySet);
        try {
            definition.initialize();
            Assert.fail((String)"Initialized without value mappings");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        definition.setValueMaps(Collections.singleton(this.substringValueMapping("foo", false, "foo")));
        definition.initialize();
        definition.destroy();
        try {
            definition.initialize();
            Assert.fail((String)"init a torn down mapper?");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            definition.resolve(new AttributeResolutionContext());
            Assert.fail((String)"resolve a torn down mapper?");
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void noAttributeValues() throws Exception {
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.7", (String[])ResolverTestSupport.EPE1_VALUES), ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (String[])ResolverTestSupport.EPA1_VALUES)})});
        MappedAttributeDefinition definition = new MappedAttributeDefinition();
        definition.setId(TEST_ATTRIBUTE_NAME);
        definition.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"connector1", (String)"NoSuchAttribute")));
        definition.setValueMaps(Collections.singleton(this.substringValueMapping("foo", false, "foo")));
        definition.initialize();
        IdPAttribute result = (IdPAttribute)definition.resolve(resolutionContext);
        Assert.assertEquals((String)result.getId(), (String)TEST_ATTRIBUTE_NAME);
        Assert.assertTrue((boolean)result.getValues().isEmpty());
    }

    @Test
    public void noAttributeValuesDefault() throws Exception {
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.7", (String[])ResolverTestSupport.EPE1_VALUES), ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (String[])ResolverTestSupport.EPA1_VALUES)})});
        MappedAttributeDefinition definition = new MappedAttributeDefinition();
        definition.setId(TEST_ATTRIBUTE_NAME);
        definition.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"connector1", (String)"NoSuchAttribute")));
        definition.setValueMaps(Collections.singleton(this.substringValueMapping("foo", false, "foo")));
        definition.setDefaultValue("");
        Assert.assertNull((Object)definition.getDefaultAttributeValue());
        Assert.assertNull((Object)definition.getDefaultValue());
        definition.setDefaultValue("default");
        Assert.assertEquals((String)definition.getDefaultValue(), (String)"default");
        definition.initialize();
        IdPAttribute result = (IdPAttribute)definition.resolve(resolutionContext);
        Assert.assertEquals((String)result.getId(), (String)TEST_ATTRIBUTE_NAME);
        Assert.assertFalse((boolean)result.getValues().isEmpty());
        Assert.assertTrue((boolean)result.getValues().contains(new StringAttributeValue("default")));
    }

    @Test
    public void invalidValueType() throws ComponentInitializationException {
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(Collections.singletonList(new ByteAttributeValue(new byte[]{1, 2, 3})));
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        MappedAttributeDefinition definition = new MappedAttributeDefinition();
        definition.setId(TEST_ATTRIBUTE_NAME);
        definition.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"connector1", (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1")));
        definition.setValueMaps(Collections.singleton(this.substringValueMapping("student", false, "student")));
        definition.initialize();
        try {
            definition.resolve(resolutionContext);
            Assert.fail((String)"invalid types");
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void emptyAttributeValues() throws Exception {
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.7", (String[])ResolverTestSupport.EPE1_VALUES), ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (String[])new String[]{null, ""})})});
        MappedAttributeDefinition definition = new MappedAttributeDefinition();
        definition.setId(TEST_ATTRIBUTE_NAME);
        definition.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"connector1", (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1")));
        Assert.assertTrue((boolean)definition.getValueMaps().isEmpty());
        definition.setValueMaps(Collections.singleton(this.substringValueMapping("student", false, "student")));
        Assert.assertEquals((int)definition.getValueMaps().size(), (int)1);
        definition.initialize();
        IdPAttribute result = (IdPAttribute)definition.resolve(resolutionContext);
        Assert.assertEquals((String)result.getId(), (String)TEST_ATTRIBUTE_NAME);
        Assert.assertTrue((boolean)result.getValues().isEmpty());
    }

    @Test
    public void validValueType() throws Exception {
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.7", (String[])ResolverTestSupport.EPE1_VALUES), ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (String[])ResolverTestSupport.EPA3_VALUES)})});
        MappedAttributeDefinition definition = new MappedAttributeDefinition();
        definition.setId(TEST_ATTRIBUTE_NAME);
        definition.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"connector1", (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1")));
        Assert.assertTrue((boolean)definition.getValueMaps().isEmpty());
        definition.setValueMaps(Collections.singleton(this.substringValueMapping("student", false, "student")));
        Assert.assertEquals((int)definition.getValueMaps().size(), (int)1);
        definition.initialize();
        IdPAttribute result = (IdPAttribute)definition.resolve(resolutionContext);
        Assert.assertEquals((String)result.getId(), (String)TEST_ATTRIBUTE_NAME);
        Assert.assertFalse((boolean)result.getValues().isEmpty());
        Assert.assertEquals((int)result.getValues().size(), (int)2);
        Assert.assertTrue((boolean)((IdPAttributeValue)result.getValues().get(0)).equals(new StringAttributeValue("student")));
        Assert.assertTrue((boolean)((IdPAttributeValue)result.getValues().get(1)).equals(new StringAttributeValue("student")));
    }

    @Test
    public void defaultCase() throws Exception {
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.7", (String[])ResolverTestSupport.EPE1_VALUES), ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (String[])ResolverTestSupport.EPA3_VALUES)})});
        MappedAttributeDefinition definition = new MappedAttributeDefinition();
        definition.setId(TEST_ATTRIBUTE_NAME);
        definition.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"connector1", (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1")));
        Assert.assertTrue((boolean)definition.getValueMaps().isEmpty());
        definition.setValueMaps(Collections.singleton(this.substringValueMapping("elephant", false, "banana")));
        definition.setDefaultValue("default");
        Assert.assertEquals((String)definition.getDefaultAttributeValue().getValue(), (String)"default");
        Assert.assertFalse((boolean)definition.isPassThru());
        definition.initialize();
        IdPAttribute result = (IdPAttribute)definition.resolve(resolutionContext);
        Assert.assertEquals((String)result.getId(), (String)TEST_ATTRIBUTE_NAME);
        Assert.assertFalse((boolean)result.getValues().isEmpty());
        Assert.assertEquals((int)result.getValues().size(), (int)3);
        Assert.assertTrue((boolean)((IdPAttributeValue)result.getValues().get(0)).equals(new StringAttributeValue("default")));
        Assert.assertTrue((boolean)((IdPAttributeValue)result.getValues().get(1)).equals(new StringAttributeValue("default")));
        Assert.assertTrue((boolean)((IdPAttributeValue)result.getValues().get(2)).equals(new StringAttributeValue("default")));
    }

    @Test
    public void passThrough() throws Exception {
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.7", (String[])ResolverTestSupport.EPE1_VALUES), ResolverTestSupport.buildAttribute((String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1", (String[])ResolverTestSupport.EPA3_VALUES)})});
        MappedAttributeDefinition definition = new MappedAttributeDefinition();
        definition.setId(TEST_ATTRIBUTE_NAME);
        definition.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"connector1", (String)"urn:oid:1.3.6.1.4.1.5923.1.1.1.1")));
        Assert.assertTrue((boolean)definition.getValueMaps().isEmpty());
        definition.setValueMaps(Collections.singleton(this.substringValueMapping("elephant", false, "banana")));
        definition.setDefaultValue("default");
        Assert.assertEquals((String)definition.getDefaultAttributeValue().getValue(), (String)"default");
        definition.setPassThru(true);
        definition.initialize();
        IdPAttribute result = (IdPAttribute)definition.resolve(resolutionContext);
        Assert.assertEquals((String)result.getId(), (String)TEST_ATTRIBUTE_NAME);
        Assert.assertFalse((boolean)result.getValues().isEmpty());
        Assert.assertEquals((int)result.getValues().size(), (int)ResolverTestSupport.EPA3_VALUES.length);
        for (String val : ResolverTestSupport.EPA3_VALUES) {
            Assert.assertTrue((boolean)result.getValues().contains(new StringAttributeValue(val)));
        }
    }

    protected ValueMap substringValueMapping(String targetValue, boolean caseInsensitive, String returnValue) throws ComponentInitializationException {
        ValueMap retVal = new ValueMap();
        retVal.setReturnValue(returnValue);
        retVal.setSourceValues(Collections.singleton(SourceValueTest.newSourceValue(returnValue, caseInsensitive, true)));
        return retVal;
    }
}

