/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.mapped.impl;

import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.SourceValue;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SourceValueTest {
    Logger log = LoggerFactory.getLogger(SourceValueTest.class);

    @Test
    public void sourceValue() throws ComponentInitializationException {
        SourceValue value = SourceValueTest.newSourceValue("value", false, true);
        Assert.assertEquals((String)value.getValue(), (String)"value");
        Assert.assertTrue((boolean)value.isPartialMatch());
        Assert.assertFalse((boolean)value.isIgnoreCase());
        this.log.info("Value = 'value', ignore = true, partial = false", (Object)value.toString());
        value = SourceValueTest.newSourceValue("eulaV", true, false);
        Assert.assertEquals((String)value.getPattern().pattern(), (String)"eulaV");
        Assert.assertFalse((boolean)value.isPartialMatch());
        Assert.assertTrue((boolean)value.isIgnoreCase());
        this.log.info("Value = 'eulaV', ignore = false, partial = true", (Object)value.toString());
    }

    public static SourceValue newSourceValue(String value, boolean ignoreCase, boolean partialMatch) throws ComponentInitializationException {
        SourceValue sourceValue = new SourceValue();
        sourceValue.setValue(value);
        sourceValue.setIgnoreCase(Boolean.valueOf(ignoreCase));
        sourceValue.setPartialMatch(Boolean.valueOf(partialMatch));
        sourceValue.initialize();
        return sourceValue;
    }
}

