/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.mapped.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.SourceValue;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.SourceValueTest;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.ValueMap;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ValueMapTest {
    @Test
    public void setterGetter() throws ComponentInitializationException {
        SourceValue value = SourceValueTest.newSourceValue("value", true, true);
        ValueMap map = new ValueMap();
        map.setSourceValues(Collections.singleton(value));
        map.setReturnValue("return");
        Assert.assertEquals((String)map.getReturnValue(), (String)"return");
        Assert.assertEquals((int)map.getSourceValues().size(), (int)1);
        Assert.assertTrue((boolean)map.getSourceValues().contains(value));
    }

    @Test
    public void subString() throws ComponentInitializationException {
        SourceValue value = SourceValueTest.newSourceValue("value", true, true);
        ValueMap map = new ValueMap();
        map.setSourceValues(Collections.singleton(value));
        map.setReturnValue("return");
        Set result = map.apply("elephant");
        Assert.assertTrue((boolean)result.isEmpty());
        result = map.apply("elephantvaluegiraffe");
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertTrue((boolean)result.contains(new StringAttributeValue("return")));
    }

    @Test
    public void regexp() throws ComponentInitializationException {
        HashSet<SourceValue> sources = new HashSet<SourceValue>(3);
        sources.add(SourceValueTest.newSourceValue("R(.+)", false, false));
        sources.add(SourceValueTest.newSourceValue("RE(.+)", true, false));
        ValueMap map = new ValueMap();
        map.setSourceValues(sources);
        map.setReturnValue("foo$1");
        Set result = map.apply("elephant");
        Assert.assertTrue((boolean)result.isEmpty());
        result = map.apply("Recursion");
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertTrue((boolean)result.contains(new StringAttributeValue("fooecursion")));
        Assert.assertTrue((boolean)result.contains(new StringAttributeValue("foocursion")));
    }
}

