/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.script.ScriptException;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.MappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.HTTPDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.ScriptedResponseMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.TemplatedBodyBuilder;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.TemplatedURLBuilder;
import net.shibboleth.idp.attribute.resolver.dc.impl.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.impl.TestCache;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.repository.RepositorySupport;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.testing.TestSupport;
import net.shibboleth.utilities.java.support.velocity.VelocityEngine;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolverTest;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.impl.SecurityEnhancedHttpClientSupport;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTTPDataConnectorTest {
    private static final String TEST_CONNECTOR_NAME = "HTTPConnector";
    private static final String TEST_URL = RepositorySupport.buildHTTPResourceURL((String)"java-identity-provider", (String)"idp-attribute-resolver-impl/src/test/resources/net/shibboleth/idp/attribute/resolver/impl/dc/http/test.json", (boolean)false);
    private static final String SCRIPT_PATH = "/net/shibboleth/idp/attribute/resolver/impl/dc/http/";
    private static final String SCRIPT_PATH_V8 = "/net/shibboleth/idp/attribute/resolver/impl/dc/http/v8/";
    private HTTPDataConnector connector;

    @BeforeMethod
    public void setUp() throws Exception {
        this.connector = new HTTPDataConnector();
        this.connector.setId(TEST_CONNECTOR_NAME);
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTLSSocketFactory(SecurityEnhancedHttpClientSupport.buildTLSSocketFactory((boolean)false, (boolean)false));
        this.connector.setHttpClient(builder.buildClient());
    }

    @Test
    public void test() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSProtocols(Collections.singleton("TLSv1"));
        this.connector.setHttpClientSecurityParameters(params);
        TemplatedURLBuilder builder = new TemplatedURLBuilder();
        builder.setTemplateText(TEST_URL);
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.setHttpClientSecurityParameters(params);
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.resourceScript((Resource)ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource((TestSupport.isJavaV8OrLater() ? SCRIPT_PATH_V8 : SCRIPT_PATH) + "test.js")));
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(200));
        mapping.setAcceptTypes(Collections.singleton("application/json"));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)this.connector.resolve(context);
        Assert.assertEquals((int)attrs.size(), (int)2);
        Assert.assertEquals((int)((IdPAttribute)attrs.get("foo")).getValues().size(), (int)1);
        Assert.assertEquals((Object)((IdPAttributeValue)((IdPAttribute)attrs.get("foo")).getValues().get(0)).getValue(), (Object)"foo1");
        Assert.assertEquals((int)((IdPAttribute)attrs.get("bar")).getValues().size(), (int)2);
        Assert.assertEquals((Object)((IdPAttributeValue)((IdPAttribute)attrs.get("bar")).getValues().get(0)).getValue(), (Object)"bar1");
        Assert.assertEquals((Object)((IdPAttributeValue)((IdPAttribute)attrs.get("bar")).getValues().get(1)).getValue(), (Object)"bar2");
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void testBadProtocol() throws Exception {
        HttpClientBuilder clientBuilder = new HttpClientBuilder();
        clientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.connector.setHttpClient(clientBuilder.buildClient());
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSProtocols(Collections.singleton("SSLv3"));
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine((String)"repo-entity.crt"));
        this.connector.setHttpClientSecurityParameters(params);
        TemplatedURLBuilder builder = new TemplatedURLBuilder();
        builder.setTemplateText(RepositorySupport.buildHTTPSResourceURL((String)"java-identity-provider", (String)"idp-attribute-resolver-impl/src/test/resources/net/shibboleth/idp/attribute/resolver/impl/dc/http/test.json"));
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.setHttpClientSecurityParameters(params);
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.resourceScript((Resource)ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource((TestSupport.isJavaV8OrLater() ? SCRIPT_PATH_V8 : SCRIPT_PATH) + "test.js")));
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(200));
        mapping.setAcceptTypes(Collections.singleton("application/json"));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        this.connector.resolve(context);
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void testSize() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        TemplatedURLBuilder builder = new TemplatedURLBuilder();
        builder.setTemplateText(TEST_URL);
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.resourceScript((Resource)ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource((TestSupport.isJavaV8OrLater() ? SCRIPT_PATH_V8 : SCRIPT_PATH) + "testsize.js")));
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(200));
        mapping.setAcceptTypes(Collections.singleton("application/json"));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        this.connector.resolve(context);
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void testMissing() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        TemplatedURLBuilder builder = new TemplatedURLBuilder();
        builder.setTemplateText("https://shibboleth.net/test.json");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.resourceScript((Resource)ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource((TestSupport.isJavaV8OrLater() ? SCRIPT_PATH_V8 : SCRIPT_PATH) + "test.js")));
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(200));
        mapping.setAcceptTypes(Collections.singleton("application/json"));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        this.connector.resolve(context);
    }

    @Test
    public void testMissingOk() throws ComponentInitializationException, ResolutionException, ScriptException {
        TemplatedURLBuilder builder = new TemplatedURLBuilder();
        builder.setTemplateText("https://build.shibboleth.net/test.json");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.inlineScript((String)"1");
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(404));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)this.connector.resolve(context);
        Assert.assertTrue((attrs == null || attrs.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void resolveWithCache() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        TemplatedURLBuilder builder = new TemplatedURLBuilder();
        builder.setTemplateText(TEST_URL);
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.resourceScript((Resource)ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource((TestSupport.isJavaV8OrLater() ? SCRIPT_PATH_V8 : SCRIPT_PATH) + "test.js")));
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(200));
        mapping.setAcceptTypes(Collections.singleton("application/json"));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        TestCache cache = new TestCache();
        this.connector.setResultsCache((Cache)cache);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Assert.assertTrue((cache.size() == 0L ? 1 : 0) != 0);
        Map optional = (Map)this.connector.resolve(context);
        Assert.assertTrue((cache.size() == 1L ? 1 : 0) != 0);
        Assert.assertEquals(cache.iterator().next(), (Map)optional);
    }

    @Test(enabled=false)
    public void testPOST() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        TemplatedBodyBuilder builder = new TemplatedBodyBuilder();
        builder.setURLTemplateText("https://shibboleth.net/cgi-bin/_frobnitz.cgi");
        builder.setBodyTemplateText("[{\"name\" : \"foo\",\"values\" : [ \"foo1\" ]},{\"name\" : \"bar\",\"values\" : [ \"bar1\", \"bar2\" ]}]");
        builder.setMIMEType("application/json");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.resourceScript((Resource)ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource((TestSupport.isJavaV8OrLater() ? SCRIPT_PATH_V8 : SCRIPT_PATH) + "test.js")));
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(200));
        mapping.setAcceptTypes(Collections.singleton("application/json"));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)this.connector.resolve(context);
        Assert.assertEquals((int)attrs.size(), (int)2);
        Assert.assertEquals((int)((IdPAttribute)attrs.get("foo")).getValues().size(), (int)1);
        Assert.assertEquals((Object)((IdPAttributeValue)((IdPAttribute)attrs.get("foo")).getValues().get(0)).getValue(), (Object)"foo1");
        Assert.assertEquals((int)((IdPAttribute)attrs.get("bar")).getValues().size(), (int)2);
        Assert.assertEquals((Object)((IdPAttributeValue)((IdPAttribute)attrs.get("bar")).getValues().get(0)).getValue(), (Object)"bar1");
        Assert.assertEquals((Object)((IdPAttributeValue)((IdPAttribute)attrs.get("bar")).getValues().get(1)).getValue(), (Object)"bar2");
    }

    @Test(enabled=false)
    public void testCacheable() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        TemplatedBodyBuilder builder = new TemplatedBodyBuilder();
        builder.setURLTemplateText("https://shibboleth.net/cgi-bin/_frobnitz.cgi");
        builder.setBodyTemplateText("[{\"name\" : \"foo\",\"values\" : [ \"foo1\" ]},{\"name\" : \"bar\",\"values\" : [ \"bar1\", \"bar2\" ]}]");
        builder.setCacheKeyTemplateText("foo");
        builder.setMIMEType("application/json");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.resourceScript((Resource)ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource((TestSupport.isJavaV8OrLater() ? SCRIPT_PATH_V8 : SCRIPT_PATH) + "test.js")));
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(200));
        mapping.setAcceptTypes(Collections.singleton("application/json"));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        TestCache cache = new TestCache();
        this.connector.setResultsCache((Cache)cache);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Assert.assertTrue((cache.size() == 0L ? 1 : 0) != 0);
        Map optional = (Map)this.connector.resolve(context);
        Assert.assertTrue((cache.size() == 1L ? 1 : 0) != 0);
        Assert.assertEquals(cache.iterator().next(), (Map)optional);
    }

    @Test(enabled=false)
    public void testUncacheable() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        TemplatedBodyBuilder builder = new TemplatedBodyBuilder();
        builder.setURLTemplateText("https://shibboleth.net/cgi-bin/_frobnitz.cgi");
        builder.setBodyTemplateText("[{\"name\" : \"foo\",\"values\" : [ \"foo1\" ]},{\"name\" : \"bar\",\"values\" : [ \"bar1\", \"bar2\" ]}]");
        builder.setMIMEType("application/json");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.connector.setExecutableSearchBuilder((ExecutableSearchBuilder)builder);
        ScriptedResponseMappingStrategy mapping = ScriptedResponseMappingStrategy.resourceScript((Resource)ResourceHelper.of((org.springframework.core.io.Resource)new ClassPathResource((TestSupport.isJavaV8OrLater() ? SCRIPT_PATH_V8 : SCRIPT_PATH) + "test.js")));
        mapping.setLogPrefix("HTTPConnector:");
        mapping.setAcceptStatuses(Collections.singleton(200));
        mapping.setAcceptTypes(Collections.singleton("application/json"));
        this.connector.setMappingStrategy((MappingStrategy)mapping);
        TestCache cache = new TestCache();
        this.connector.setResultsCache((Cache)cache);
        this.connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Assert.assertTrue((cache.size() == 0L ? 1 : 0) != 0);
        this.connector.resolve(context);
        Assert.assertTrue((cache.size() == 0L ? 1 : 0) != 0);
    }
}

