/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ResolverTestSupport;
import net.shibboleth.idp.attribute.resolver.ad.impl.SimpleAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImplTest;
import net.shibboleth.idp.saml.attribute.resolver.impl.AbstractPersistentIdDataConnector;
import net.shibboleth.idp.saml.attribute.resolver.impl.ComputedIDDataConnector;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ComputedIDDataConnectorTest
extends OpenSAMLInitBaseTestCase {
    private static final String TEST_ATTRIBUTE_NAME = "computedAttribute";
    private static final String TEST_CONNECTOR_NAME = "computedAttributeConnector";
    protected static final String OUTPUT_ATTRIBUTE_NAME = "outputAttribute";
    protected static final String RESULT = "Vl6z6K70iLc4AuBoNeb59Dj1rGw=";
    protected static final byte[] salt = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    protected static final byte[] smallSalt = new byte[]{0, 1, 2};

    private static void testInit(AbstractPersistentIdDataConnector connector, String failMessage) {
        try {
            connector.initialize();
            Assert.fail((String)failMessage);
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void dataConnector() throws ComponentInitializationException, ResolutionException {
        ComputedIDDataConnector connector = new ComputedIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1")));
        ComputedIDDataConnectorTest.testInit((AbstractPersistentIdDataConnector)connector, "No salt");
        connector.setSalt(salt);
        ComputedIDDataConnectorTest.testInit((AbstractPersistentIdDataConnector)connector, "No source attr");
        connector.setSourceAttributeId("staticAtt");
        connector.setGeneratedAttributeId(TEST_ATTRIBUTE_NAME);
        connector.initialize();
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(OUTPUT_ATTRIBUTE_NAME);
        simple.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)TEST_CONNECTOR_NAME, (String)TEST_ATTRIBUTE_NAME)));
        HashSet<AttributeDefinition> set = new HashSet<AttributeDefinition>(2);
        set.add((AttributeDefinition)simple);
        set.add(TestSources.populatedStaticAttribute((String)"staticAtt", (String)"at1", (int)1));
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("atresolver", set, Collections.singleton(connector), null);
        simple.initialize();
        resolver.initialize();
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        List resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
        Assert.assertEquals((String)((StringAttributeValue)resultValues.iterator().next()).getValue(), (String)RESULT);
    }

    @Test
    public void getters() throws ComponentInitializationException {
        ComputedIDDataConnector connector = new ComputedIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1")));
        connector.setSalt(smallSalt);
        connector.setSourceAttributeId("staticAtt");
        connector.setGeneratedAttributeId(TEST_ATTRIBUTE_NAME);
        Assert.assertEquals((byte[])connector.getSalt(), (byte[])smallSalt);
        ComputedIDDataConnectorTest.testInit((AbstractPersistentIdDataConnector)connector, "Small salt");
        connector.setSalt(salt);
        connector.initialize();
        try {
            connector.setSalt(smallSalt);
            Assert.fail((String)"setting after init");
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        Assert.assertEquals((byte[])connector.getSalt(), (byte[])salt);
    }

    private AttributeResolver constructResolver(int values) throws ComponentInitializationException {
        ComputedIDDataConnector connector = new ComputedIDDataConnector();
        return ComputedIDDataConnectorTest.constructResolver(connector, values, false);
    }

    protected static AttributeResolver constructResolver(ComputedIDDataConnector connector, int values, boolean noSalt) throws ComponentInitializationException {
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"staticAtt", (String)"at1")));
        connector.setSourceAttributeId("staticAtt");
        if (!noSalt) {
            connector.setSalt(salt);
        }
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(OUTPUT_ATTRIBUTE_NAME);
        simple.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)TEST_CONNECTOR_NAME, (String)TEST_CONNECTOR_NAME)));
        simple.initialize();
        HashSet<AttributeDefinition> set = new HashSet<AttributeDefinition>(2);
        set.add((AttributeDefinition)simple);
        set.add(TestSources.populatedStaticAttribute((String)"staticAtt", (String)"at1", (int)values));
        return AttributeResolverImplTest.newAttributeResolverImpl("atresolver", set, Collections.singleton(connector), null);
    }

    private AttributeResolver constructResolverWithNonString(String dependantOn) throws ComponentInitializationException {
        return ComputedIDDataConnectorTest.constructResolverWithNonString(new ComputedIDDataConnector(), dependantOn);
    }

    protected static AttributeResolver constructResolverWithNonString(ComputedIDDataConnector connector, String dependantOn) throws ComponentInitializationException {
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)dependantOn, null)));
        connector.setSalt(salt);
        connector.setSourceAttributeId(dependantOn);
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(OUTPUT_ATTRIBUTE_NAME);
        simple.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)TEST_CONNECTOR_NAME, (String)TEST_CONNECTOR_NAME)));
        simple.initialize();
        HashSet<AttributeDefinition> set = new HashSet<AttributeDefinition>(3);
        set.add((AttributeDefinition)simple);
        set.add(TestSources.populatedStaticAttribute((String)"staticAtt", (String)"at1", (int)1));
        set.add(TestSources.nonStringAttributeDefiniton((String)dependantOn));
        return AttributeResolverImplTest.newAttributeResolverImpl("atresolver", set, Collections.singleton(connector), null);
    }

    protected static AbstractPersistentIdDataConnector connectorFromResolver(AttributeResolver resolver) {
        return (AbstractPersistentIdDataConnector)resolver.getDataConnectors().get(TEST_CONNECTOR_NAME);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void noSalt() throws ComponentInitializationException {
        ComputedIDDataConnectorTest.connectorFromResolver(ComputedIDDataConnectorTest.constructResolver(new ComputedIDDataConnector(), 1, true)).initialize();
    }

    @Test
    public void altDataConnector() throws ComponentInitializationException, ResolutionException {
        AttributeResolver resolver = this.constructResolver(1);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        ComponentSupport.initialize((Object)resolver);
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        List resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
        Assert.assertEquals((String)((StringAttributeValue)resultValues.iterator().next()).getValue(), (String)RESULT);
        resolver = this.constructResolver(3);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        ComponentSupport.initialize((Object)resolver);
        context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
        resolver = this.constructResolver(1);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        ComponentSupport.initialize((Object)resolver);
        context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"foo");
        resolver.resolveAttributes(context);
        resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
        Assert.assertNotEquals((Object)((StringAttributeValue)resultValues.iterator().next()).getValue(), (Object)RESULT);
    }

    @Test
    public void attributeFails() throws ComponentInitializationException, ResolutionException {
        AttributeResolver resolver = this.constructResolver(3);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).setSourceAttributeId("staticAtt1");
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        ComponentSupport.initialize((Object)resolver);
        AttributeResolutionContext context = TestSources.createResolutionContext(null, null, (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        Assert.assertNull(context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME));
        resolver = this.constructResolver(0);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        ComponentSupport.initialize((Object)resolver);
        context = TestSources.createResolutionContext(null, (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        Assert.assertNull(context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME));
        resolver = this.constructResolver(1);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        ComponentSupport.initialize((Object)resolver);
        resolver.resolveAttributes(TestSources.createResolutionContext(null, null, null));
        Assert.assertNull(context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME));
        resolver = this.constructResolverWithNonString("nonString");
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        ComponentSupport.initialize((Object)resolver);
        context = TestSources.createResolutionContext(null, (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        Assert.assertNull(context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME));
    }

    @Test
    public void case425() throws ComponentInitializationException, ResolutionException {
        ComputedIDDataConnector connector = new ComputedIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)"staticCon", null)));
        connector.setSourceAttributeId("ac1");
        connector.setSalt(salt);
        connector.setGeneratedAttributeId("wibble");
        connector.initialize();
        HashSet<DataConnector> set = new HashSet<DataConnector>(2);
        set.add(TestSources.populatedStaticConnector());
        set.add((DataConnector)connector);
        SimpleAttributeDefinition simple = new SimpleAttributeDefinition();
        simple.setId(OUTPUT_ATTRIBUTE_NAME);
        simple.setDependencies(Collections.singleton(TestSources.makeResolverPluginDependency((String)TEST_CONNECTOR_NAME, (String)"wibble")));
        simple.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("atresolver", Collections.singleton(simple), set, null);
        ComponentSupport.initialize((Object)resolver);
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        List resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get(OUTPUT_ATTRIBUTE_NAME)).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
    }

    @Test
    public void nullValue() throws ComponentInitializationException, ResolutionException {
        ArrayList<Object> values = new ArrayList<Object>(2);
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE));
        values.add(new StringAttributeValue("calue"));
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(values);
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        resolutionContext.setAttributeIssuerID("https://idp.example.org/idp");
        resolutionContext.setAttributeRecipientID("https://sp.example.org/sp");
        resolutionContext.setPrincipal("PETER_THE_PRINCIPAL");
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        ComputedIDDataConnector connector = new ComputedIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setDependencies(Collections.singleton(depend));
        connector.setSourceAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        connector.setSalt(salt);
        connector.setGeneratedAttributeId("wibble");
        connector.initialize();
        Assert.assertNull((Object)connector.resolve(resolutionContext));
    }

    @Test
    public void emptyValue() throws ComponentInitializationException, ResolutionException {
        ArrayList<EmptyAttributeValue> values = new ArrayList<EmptyAttributeValue>(1);
        values.add(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.ZERO_LENGTH_VALUE));
        IdPAttribute attr = new IdPAttribute("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        attr.setValues(values);
        AttributeResolutionContext resolutionContext = ResolverTestSupport.buildResolutionContext((ResolverPlugin[])new ResolverPlugin[]{ResolverTestSupport.buildDataConnector((String)"connector1", (IdPAttribute[])new IdPAttribute[]{attr})});
        resolutionContext.setAttributeIssuerID("https://idp.example.org/idp");
        resolutionContext.setAttributeRecipientID("https://sp.example.org/sp");
        resolutionContext.setPrincipal("PETER_THE_PRINCIPAL");
        ResolverPluginDependency depend = new ResolverPluginDependency("connector1");
        depend.setDependencyAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        ComputedIDDataConnector connector = new ComputedIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setDependencies(Collections.singleton(depend));
        connector.setSourceAttributeId("urn:oid:1.3.6.1.4.1.5923.1.1.1.1");
        connector.setSalt(salt);
        connector.setGeneratedAttributeId("wibble");
        connector.initialize();
        Map result = (Map)connector.resolve(resolutionContext);
        Assert.assertNull((Object)result);
    }
}

