/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLAttributeDataConnector
extends AbstractDataConnector {
    private final Logger log = LoggerFactory.getLogger(SAMLAttributeDataConnector.class);
    private Function<AttributeResolutionContext, List<Attribute>> attributesStrategy;

    public Function<AttributeResolutionContext, List<Attribute>> getAttributesStrategy() {
        return this.attributesStrategy;
    }

    public void setAttributesStrategy(Function<AttributeResolutionContext, List<Attribute>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributesStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.attributesStrategy) {
            throw new ComponentInitializationException("Attribute Connector '" + this.getId() + "': no Attribute location strategy set");
        }
    }

    protected IdPAttributeValue encodeValue(XMLObject object) {
        if (null == object) {
            return null;
        }
        if (object instanceof XSString) {
            return this.encodeString((XSString)object);
        }
        return new XMLObjectAttributeValue(object);
    }

    private IdPAttributeValue encodeString(XSString inputString) {
        String value = inputString.getValue();
        int separator = value.indexOf(64);
        if (separator < 0) {
            return new StringAttributeValue(value);
        }
        return new ScopedStringAttributeValue(value.substring(0, separator), value.substring(separator + 1));
    }

    @Nullable
    @Nonnull
    protected List<IdPAttributeValue<?>> encodeValues(List<XMLObject> attributeValues) {
        ArrayList result = new ArrayList(attributeValues.size());
        for (XMLObject object : attributeValues) {
            IdPAttributeValue val = this.encodeValue(object);
            result.add(val);
        }
        return result;
    }

    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        List samlAttributes = (List)this.attributesStrategy.apply((Object)resolutionContext);
        if (null == samlAttributes) {
            this.log.info("Connector '{}' no attributes found", (Object)this.getId());
            return null;
        }
        HashMap<String, IdPAttribute> retVal = new HashMap<String, IdPAttribute>(samlAttributes.size());
        for (Attribute samlAttribute : samlAttributes) {
            String attributeName = samlAttribute.getName();
            this.log.debug("Connector '{}': found attribute named '{}'", (Object)this.getId(), (Object)attributeName);
            List<IdPAttributeValue<?>> values = this.encodeValues(samlAttribute.getAttributeValues());
            this.log.debug("Connector '{}': attribute '{}', values '{}'", new Object[]{this.getId(), attributeName, values});
            IdPAttribute IdPAttribute2 = new IdPAttribute(attributeName);
            IdPAttribute2.setValues(values);
            retVal.put(attributeName, IdPAttribute2);
        }
        return retVal;
    }
}

