/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.base.Function;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.dc.impl.SAMLAttributeDataConnector;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SAMLAttributeDataConnectorTest
extends XMLObjectBaseTestCase {
    private static final String PATH = "/net/shibboleth/idp/attribute/resolver/impl/dc/entityAttributes.xml";

    @Test
    public void connector() throws ResolutionException, ComponentInitializationException {
        Locator entityLocator = new Locator(PATH);
        SAMLAttributeDataConnector connector = new SAMLAttributeDataConnector();
        connector.setAttributesStrategy(entityLocator);
        connector.setId(PATH);
        connector.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        Map attributes = (Map)connector.resolve(context);
        Assert.assertEquals((int)attributes.size(), (int)2);
        List attributeValues = ((IdPAttribute)attributes.get("SamlName")).getValues();
        Assert.assertEquals((int)attributeValues.size(), (int)1);
        Assert.assertTrue((boolean)(attributeValues.iterator().next() instanceof XMLObjectAttributeValue));
        attributeValues = ((IdPAttribute)attributes.get("MultiName")).getValues();
        Assert.assertEquals((int)attributeValues.size(), (int)3);
        for (IdPAttributeValue val : attributeValues) {
            Assert.assertTrue((boolean)(val instanceof StringAttributeValue));
        }
    }

    final class Locator
    implements Function<AttributeResolutionContext, List<Attribute>> {
        final EntityAttributes obj;

        public Locator(String path) {
            this.obj = (EntityAttributes)SAMLAttributeDataConnectorTest.this.unmarshallElement(path);
        }

        @Nullable
        public List<Attribute> apply(@Nullable AttributeResolutionContext input) {
            return this.obj.getAttributes();
        }
    }
}

