/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.dc.impl.ScriptedDataConnector;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import net.shibboleth.utilities.java.support.testing.TestSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptedDataConnectorTest {
    private String getScript(String fileName) throws IOException {
        String name = TestSupport.isJavaV8OrLater() ? "/net/shibboleth/idp/attribute/resolver/impl/dc/v8/" + fileName : "/net/shibboleth/idp/attribute/resolver/impl/dc/" + fileName;
        return StringSupport.inputStreamToString((InputStream)this.getClass().getResourceAsStream(name), null);
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void error() throws ComponentInitializationException, ScriptException, IOException, ResolutionException {
        ScriptedDataConnector connector = new ScriptedDataConnector();
        connector.setId("Scripted");
        EvaluableScript definitionScript = new EvaluableScript("javascript", this.getScript("error.js"));
        connector.setScript(definitionScript);
        connector.initialize();
        AttributeResolutionContext context = (AttributeResolutionContext)new ProfileRequestContext().getSubcontext(AttributeResolutionContext.class, true);
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        connector.resolve(context);
    }

    @Test
    public void simple() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        ScriptedDataConnector connector = new ScriptedDataConnector();
        connector.setId("Scripted");
        EvaluableScript definitionScript = new EvaluableScript("javascript", this.getScript("scriptedConnector.js"));
        connector.setScript(definitionScript);
        connector.initialize();
        AttributeResolutionContext context = (AttributeResolutionContext)new ProfileRequestContext().getSubcontext(AttributeResolutionContext.class, true);
        SubjectContext sc = (SubjectContext)context.getParent().getSubcontext(SubjectContext.class, true);
        Map authnResults = sc.getAuthenticationResults();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("Foo"));
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("Bar"));
        authnResults.put("one", new AuthenticationResult("1", subject));
        subject = new Subject();
        subject.getPrincipals().add((Principal)new AuthenticationMethodPrincipal("Toto"));
        authnResults.put("two", new AuthenticationResult("2", subject));
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        Map result = (Map)connector.resolve(context);
        Assert.assertEquals((int)result.size(), (int)4);
        List values = ((IdPAttribute)result.get("ScriptedOne")).getValues();
        Assert.assertEquals((int)values.size(), (int)2);
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("Value 1")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("Value 2")));
        values = ((IdPAttribute)result.get("TwoScripted")).getValues();
        Assert.assertEquals((int)values.size(), (int)3);
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("1Value")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("2Value")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("3Value")));
        values = ((IdPAttribute)result.get("ThreeScripted")).getValues();
        Assert.assertEquals((int)values.size(), (int)1);
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue(AttributeResolutionContext.class.getSimpleName())));
        values = ((IdPAttribute)result.get("Subjects")).getValues();
        Assert.assertEquals((int)values.size(), (int)3);
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("Foo")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("Bar")));
        Assert.assertTrue((boolean)values.contains(new StringAttributeValue("Toto")));
    }

    @Test
    public void custom() throws ComponentInitializationException, ResolutionException, ScriptException, IOException {
        ScriptedDataConnector connector = new ScriptedDataConnector();
        connector.setId("Scripted");
        IdPAttribute attribute = new IdPAttribute("attr");
        attribute.setValues(Collections.singleton(new StringAttributeValue("bar")));
        connector.setCustomObject((Object)attribute);
        EvaluableScript definitionScript = new EvaluableScript("javascript", this.getScript("custom.js"));
        connector.setScript(definitionScript);
        connector.initialize();
        AttributeResolutionContext context = (AttributeResolutionContext)new ProfileRequestContext().getSubcontext(AttributeResolutionContext.class, true);
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        Map result = (Map)connector.resolve(context);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertEquals(result.get(attribute.getId()), (Object)attribute);
    }
}

