/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.dc.impl.StaticDataConnector;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StaticDataConnectorTest {
    @Test
    public void resolve() throws ComponentInitializationException, ResolutionException {
        IdPAttribute attribute = new IdPAttribute("attribute");
        attribute.setValues(Arrays.asList(new StringAttributeValue("one"), new StringAttributeValue("two")));
        StaticDataConnector connector = new StaticDataConnector();
        connector.setId("Static");
        Assert.assertNull((Object)connector.getAttributes());
        connector.setValues(null);
        Assert.assertNull((Object)connector.getAttributes());
        try {
            connector.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        ArrayList<IdPAttribute> input = new ArrayList<IdPAttribute>();
        connector.setValues(input);
        Assert.assertNotNull((Object)connector.getAttributes());
        input.add(null);
        connector.setValues(input);
        Assert.assertNotNull((Object)connector.getAttributes());
        input.add(attribute);
        input.add(null);
        input.add(new IdPAttribute("thingy"));
        connector.setValues(input);
        connector.initialize();
        Assert.assertEquals((int)connector.getAttributes().size(), (int)2);
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.getSubcontext(AttributeResolverWorkContext.class, true);
        Map result = (Map)connector.resolve(context);
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertTrue((boolean)result.containsKey("attribute"));
        Assert.assertTrue((boolean)result.containsKey("thingy"));
    }

    @Test
    public void initDestroy() throws ComponentInitializationException, ResolutionException {
        StaticDataConnector connector = new StaticDataConnector();
        connector.setId("Static");
        ArrayList<IdPAttribute> input = new ArrayList<IdPAttribute>();
        input.add(null);
        connector.setValues(input);
        try {
            connector.resolve(new AttributeResolutionContext());
            Assert.fail();
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        input.add(new IdPAttribute("thingy"));
        connector.setValues(input);
        connector.initialize();
        try {
            connector.setValues(Collections.singletonList(new IdPAttribute("whatever")));
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        connector.destroy();
        try {
            connector.resolve(new AttributeResolutionContext());
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }
}

