/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.impl.ComputedIDDataConnectorTest;
import net.shibboleth.idp.saml.attribute.resolver.impl.ComputedIDDataConnector;
import net.shibboleth.idp.saml.attribute.resolver.impl.StoredIDDataConnector;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.idp.testing.DatabaseTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class StoredIDDataConnectorTest
extends OpenSAMLInitBaseTestCase {
    private static final String TEST_ATTRIBUTE_NAME = "storedAttribute";
    private static final String TEST_CONNECTOR_NAME = "storedAttributeConnector";
    private static final String INIT_FILE = "/net/shibboleth/idp/attribute/resolver/impl/dc/StoredIdStore.sql";
    private static final String DELETE_FILE = "/net/shibboleth/idp/attribute/resolver/impl/dc/DeleteStore.sql";
    private DataSource testSource;

    public static String convertStreamToString(InputStream is) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(is));
    }

    @BeforeTest
    public void setupSource() throws SQLException, IOException {
        this.testSource = DatabaseTestingSupport.GetMockDataSource((String)INIT_FILE, (String)"StoredIDDataConnectorStore");
    }

    @AfterClass
    public void teardown() {
        DatabaseTestingSupport.InitializeDataSource((String)DELETE_FILE, (DataSource)this.testSource);
    }

    private void tryInitialize(StoredIDDataConnector connector, String failMessage) {
        try {
            connector.initialize();
            Assert.fail((String)failMessage);
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void initializeAndGetters() throws ComponentInitializationException, SQLException, ResolutionException {
        StoredIDDataConnector connector = new StoredIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setSourceAttributeId("staticAtt");
        connector.setGeneratedAttributeId(TEST_ATTRIBUTE_NAME);
        this.tryInitialize(connector, "No DataSource");
        connector = new StoredIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setSourceAttributeId("staticAtt");
        connector.setGeneratedAttributeId(TEST_ATTRIBUTE_NAME);
        connector.setDataSource(this.testSource);
        connector = new StoredIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setSourceAttributeId("staticAtt");
        connector.setGeneratedAttributeId(TEST_ATTRIBUTE_NAME);
        connector.setDataSource(this.testSource);
        connector.setSalt(ComputedIDDataConnectorTest.smallSalt);
        this.tryInitialize(connector, "salt too small");
        connector = new StoredIDDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setSourceAttributeId("staticAtt");
        connector.setGeneratedAttributeId(TEST_ATTRIBUTE_NAME);
        connector.setDataSource(this.testSource);
        connector.setSalt(ComputedIDDataConnectorTest.smallSalt);
        connector.setSalt(ComputedIDDataConnectorTest.salt);
        Assert.assertEquals((Object)connector.getDataSource(), (Object)this.testSource);
        Assert.assertEquals((long)connector.getQueryTimeout(), (long)5000L);
        connector.setQueryTimeout(1L);
        try {
            connector.resolve(null);
            Assert.fail((String)"need to initialize first");
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        connector.initialize();
        try {
            connector.setDataSource(null);
            Assert.fail((String)"work after initialize");
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        connector.initialize();
        try {
            connector.setQueryTimeout(0L);
            Assert.fail((String)"work after initialize");
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)connector.getDataSource(), (Object)this.testSource);
        Assert.assertEquals((Object)connector.getStoredIDStore().getDataSource(), (Object)this.testSource);
        Assert.assertEquals((long)connector.getQueryTimeout(), (long)1L);
    }

    private AttributeResolver constructResolver(int values) throws ComponentInitializationException {
        return this.constructResolver(values, false);
    }

    private AttributeResolver constructResolver(int values, boolean noSalt) throws ComponentInitializationException {
        StoredIDDataConnector connector = new StoredIDDataConnector();
        connector.setDataSource(this.testSource);
        return ComputedIDDataConnectorTest.constructResolver((ComputedIDDataConnector)connector, values, noSalt);
    }

    @Test(dependsOnMethods={"noSalt"})
    public void storeEntry() throws ComponentInitializationException, SQLException, ResolutionException {
        AttributeResolver resolver = this.constructResolver(1);
        ComponentSupport.initialize((Object)resolver);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        List resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get("outputAttribute")).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
        Assert.assertEquals((String)((StringAttributeValue)resultValues.iterator().next()).getValue(), (String)"Vl6z6K70iLc4AuBoNeb59Dj1rGw=");
    }

    @Test
    public void noSalt() throws ComponentInitializationException, SQLException, ResolutionException {
        AttributeResolver resolver = this.constructResolver(1, true);
        ComponentSupport.initialize((Object)resolver);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp1", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        List resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get("outputAttribute")).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
        this.assertIsUUID(((StringAttributeValue)resultValues.iterator().next()).getValue());
    }

    private void assertIsUUID(String value) {
        Assert.assertEquals((char)value.charAt(8), (char)'-');
        Assert.assertEquals((char)value.charAt(13), (char)'-');
        Assert.assertEquals((char)value.charAt(18), (char)'-');
        Assert.assertEquals((char)value.charAt(23), (char)'-');
    }

    @Test(dependsOnMethods={"storeEntry"})
    void retrieveEntry() throws ComponentInitializationException, IOException, ResolutionException {
        AttributeResolver resolver = this.constructResolver(1);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        ComponentSupport.initialize((Object)resolver);
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        List resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get("outputAttribute")).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
        Assert.assertEquals((String)((StringAttributeValue)resultValues.iterator().next()).getValue(), (String)"Vl6z6K70iLc4AuBoNeb59Dj1rGw=");
        resolver = this.constructResolver(1);
        StoredIDDataConnector connector = (StoredIDDataConnector)ComputedIDDataConnectorTest.connectorFromResolver(resolver);
        ComponentSupport.initialize((Object)resolver);
        connector.initialize();
        connector.getStoredIDStore().deactivate("https://idp.example.org/idp", "https://sp.example.org/sp", "Vl6z6K70iLc4AuBoNeb59Dj1rGw=", null);
        context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        resultValues = ((IdPAttribute)context.getResolvedIdPAttributes().get("outputAttribute")).getValues();
        Assert.assertEquals((int)resultValues.size(), (int)1);
        String val = ((StringAttributeValue)resultValues.iterator().next()).getValue();
        Assert.assertNotEquals((Object)val, (Object)"Vl6z6K70iLc4AuBoNeb59Dj1rGw=");
        this.assertIsUUID(val);
    }

    @Test(dependsOnMethods={"retrieveEntry"})
    void badEntry() throws ComponentInitializationException, IOException, ResolutionException {
        StoredIDDataConnector connector = new StoredIDDataConnector();
        connector.setDataSource(this.testSource);
        AttributeResolver resolver = ComputedIDDataConnectorTest.constructResolverWithNonString((ComputedIDDataConnector)connector, "nonString");
        ComponentSupport.initialize((Object)resolver);
        ComputedIDDataConnectorTest.connectorFromResolver(resolver).initialize();
        connector.getStoredIDStore().deactivate("https://idp.example.org/idp", "https://sp.example.org/sp", "Vl6z6K70iLc4AuBoNeb59Dj1rGw=", null);
        AttributeResolutionContext context = TestSources.createResolutionContext((String)" ", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        resolver.resolveAttributes(context);
        Assert.assertNull(context.getResolvedIdPAttributes().get("outputAttribute"));
    }
}

