/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import com.google.common.cache.Cache;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.impl.TestCache;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ConnectionFactoryValidator;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ExecutableSearchFilter;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.LDAPDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ParameterizedExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.SearchResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.StringAttributeValueMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.TemplatedExecutableSearchFilterBuilder;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.velocity.VelocityEngine;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.SearchExecutor;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class LDAPDataConnectorTest {
    private static final String TEST_CONNECTOR_NAME = "ldapAttributeConnector";
    private static final String TEST_BASE_DN = "ou=people,dc=shibboleth,dc=net";
    private static final String[] TEST_RETURN_ATTRIBUTES = new String[]{"cn", "sn", "uid", "mail"};
    private InMemoryDirectoryServer directoryServer;

    @BeforeTest
    public void setupDirectoryServer() throws LDAPException {
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{"dc=shibboleth,dc=net"});
        config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"default", (int)10389)});
        config.addAdditionalBindCredentials("cn=Directory Manager", "password");
        this.directoryServer = new InMemoryDirectoryServer(config);
        this.directoryServer.importFromLDIF(true, "src/test/resources/net/shibboleth/idp/attribute/resolver/impl/dc/ldap/ldapDataConnectorTest.ldif");
        this.directoryServer.startListening();
    }

    @AfterTest
    public void teardownDirectoryServer() {
        this.directoryServer.shutDown(true);
    }

    protected LDAPDataConnector createLdapDataConnector(ExecutableSearchBuilder builder, SearchResultMappingStrategy strategy) throws ComponentInitializationException {
        LDAPDataConnector connector = new LDAPDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        DefaultConnectionFactory connectionFactory = new DefaultConnectionFactory("ldap://localhost:10389");
        connector.setConnectionFactory((ConnectionFactory)connectionFactory);
        SearchExecutor searchExecutor = new SearchExecutor();
        searchExecutor.setBaseDn(TEST_BASE_DN);
        searchExecutor.setReturnAttributes(TEST_RETURN_ATTRIBUTES);
        connector.setSearchExecutor(searchExecutor);
        connector.setExecutableSearchBuilder((ExecutableSearchBuilder)(builder == null ? LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(uid={principalName})") : builder));
        connector.setValidator((Validator)LDAPDataConnectorTest.newConnectionFactoryValidator((ConnectionFactory)connectionFactory));
        connector.setMappingStrategy((SearchResultMappingStrategy)(strategy == null ? new StringAttributeValueMappingStrategy() : strategy));
        return connector;
    }

    @Test
    public void initializeAndGetters() throws ComponentInitializationException, ResolutionException {
        LDAPDataConnector connector = new LDAPDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        try {
            connector.initialize();
            Assert.fail((String)"No connection factory");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        connector.setConnectionFactory((ConnectionFactory)new DefaultConnectionFactory("ldap://localhost:55555"));
        try {
            connector.initialize();
            Assert.fail((String)"No search executor");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        SearchExecutor searchExecutor = new SearchExecutor();
        searchExecutor.setBaseDn(TEST_BASE_DN);
        searchExecutor.setReturnAttributes(TEST_RETURN_ATTRIBUTES);
        connector.setSearchExecutor(searchExecutor);
        try {
            connector.initialize();
            Assert.fail((String)"No filter builder");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        ParameterizedExecutableSearchFilterBuilder requestBuilder = LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(uid={principalName})");
        connector.setExecutableSearchBuilder((ExecutableSearchBuilder)requestBuilder);
        try {
            connector.initialize();
            Assert.fail((String)"Invalid Connection Factory");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        DefaultConnectionFactory connectionFactory = new DefaultConnectionFactory("ldap://localhost:10389");
        connector.setConnectionFactory((ConnectionFactory)connectionFactory);
        StringAttributeValueMappingStrategy mappingStrategy = new StringAttributeValueMappingStrategy();
        connector.setMappingStrategy((SearchResultMappingStrategy)mappingStrategy);
        try {
            connector.resolve(null);
            Assert.fail((String)"Need to initialize first");
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        connector.initialize();
        try {
            connector.setConnectionFactory(null);
            Assert.fail((String)"Setter after initialize");
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)connector.getConnectionFactory(), (Object)connectionFactory);
        Assert.assertEquals((Object)connector.getSearchExecutor(), (Object)searchExecutor);
        Assert.assertEquals((Object)connector.getExecutableSearchBuilder(), (Object)requestBuilder);
        Assert.assertEquals((Object)connector.getMappingStrategy(), (Object)mappingStrategy);
    }

    @Test
    public void failFastInitialize() throws ComponentInitializationException {
        LDAPDataConnector connector = new LDAPDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        DefaultConnectionFactory connectionFactory = new DefaultConnectionFactory("ldap://localhost:55555");
        connector.setConnectionFactory((ConnectionFactory)connectionFactory);
        connector.setSearchExecutor(new SearchExecutor());
        connector.setExecutableSearchBuilder((ExecutableSearchBuilder)LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(uid={principalName})"));
        try {
            connector.initialize();
            Assert.fail((String)"No failfast");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        connector.setValidator((Validator)LDAPDataConnectorTest.newConnectionFactoryValidator((ConnectionFactory)connectionFactory, false));
        connector.initialize();
    }

    @Test
    public void resolve() throws ComponentInitializationException, ResolutionException {
        ParameterizedExecutableSearchFilterBuilder builder = LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(uid={principalName})");
        this.resolve((ExecutableSearchBuilder)builder);
    }

    @Test
    public void resolveMulti() throws ComponentInitializationException, ResolutionException {
        ParameterizedExecutableSearchFilterBuilder builder = LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(uid=P*)");
        this.resolveMulti((ExecutableSearchBuilder)builder);
    }

    @Test
    public void resolveWithDepends() throws ComponentInitializationException, ResolutionException {
        ParameterizedExecutableSearchFilterBuilder builder = LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(&(cn={principalName})(eduPersonAffiliation={affiliation[0]}))");
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        HashMap dependsAttributes = new HashMap();
        ArrayList<StringAttributeValue> attributeValues = new ArrayList<StringAttributeValue>();
        attributeValues.add(new StringAttributeValue("student"));
        dependsAttributes.put("affiliation", attributeValues);
        ExecutableSearchFilter filter = builder.build(context, dependsAttributes);
        Assert.assertEquals((String)filter.getSearchFilter().format(), (String)"(&(cn=PETER_THE_PRINCIPAL)(eduPersonAffiliation=student))");
        Assert.assertEquals((String)filter.getResultCacheKey(), (String)"(&(cn=PETER_THE_PRINCIPAL)(eduPersonAffiliation=student))");
    }

    @Test
    public void resolveWithMultiValueDepends() throws ComponentInitializationException, ResolutionException {
        ParameterizedExecutableSearchFilterBuilder builder = LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(&(cn={principalName})(eduPersonEntitlement={entitlement[0]})(eduPersonEntitlement={entitlement[1]}))");
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        HashMap dependsAttributes = new HashMap();
        ArrayList<StringAttributeValue> attributeValues = new ArrayList<StringAttributeValue>();
        attributeValues.add(new StringAttributeValue("entitlement1"));
        attributeValues.add(new StringAttributeValue("entitlement*"));
        dependsAttributes.put("entitlement", attributeValues);
        ExecutableSearchFilter filter = builder.build(context, dependsAttributes);
        Assert.assertEquals((String)filter.getSearchFilter().format(), (String)"(&(cn=PETER_THE_PRINCIPAL)(eduPersonEntitlement=entitlement1)(eduPersonEntitlement=entitlement\\2a))");
        Assert.assertEquals((String)filter.getResultCacheKey(), (String)"(&(cn=PETER_THE_PRINCIPAL)(eduPersonEntitlement=entitlement1)(eduPersonEntitlement=entitlement\\2a))");
    }

    @Test
    public void escape() throws ComponentInitializationException, ResolutionException {
        ParameterizedExecutableSearchFilterBuilder builder = LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(cn={principalName})");
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"domain\\user*", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        ExecutableSearchFilter filter = builder.build(context, null);
        Assert.assertEquals((String)filter.getSearchFilter().format(), (String)"(cn=domain\\5cuser\\2a)");
        Assert.assertEquals((String)filter.getResultCacheKey(), (String)"(cn=domain\\5cuser\\2a)");
    }

    @Test
    public void resolveTemplate() throws ComponentInitializationException, ResolutionException {
        TemplatedExecutableSearchFilterBuilder builder = new TemplatedExecutableSearchFilterBuilder();
        builder.setTemplateText("(uid=${resolutionContext.principal})");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.resolve((ExecutableSearchBuilder)builder);
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void resolveTemplateExcept() throws ComponentInitializationException, ResolutionException {
        TemplatedExecutableSearchFilterBuilder builder = new TemplatedExecutableSearchFilterBuilder();
        builder.setTemplateText("(uid=${resolutionContext.AttributeRecipientID.toString().substring(99, 106)})");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        this.resolve((ExecutableSearchBuilder)builder);
    }

    @Test
    public void resolveTemplateWithDepends() throws ComponentInitializationException, ResolutionException {
        TemplatedExecutableSearchFilterBuilder builder = new TemplatedExecutableSearchFilterBuilder();
        builder.setTemplateText("(&(cn=${resolutionContext.principal})(eduPersonAffiliation=${affiliation[0]}))");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        HashMap dependsAttributes = new HashMap();
        ArrayList<StringAttributeValue> attributeValues = new ArrayList<StringAttributeValue>();
        attributeValues.add(new StringAttributeValue("student"));
        dependsAttributes.put("affiliation", attributeValues);
        ExecutableSearchFilter filter = builder.build(context, dependsAttributes);
        Assert.assertEquals((String)filter.getSearchFilter().format(), (String)"(&(cn=PETER_THE_PRINCIPAL)(eduPersonAffiliation=student))");
        Assert.assertEquals((String)filter.getResultCacheKey(), (String)"(&(cn=PETER_THE_PRINCIPAL)(eduPersonAffiliation=student))");
    }

    @Test
    public void resolveTemplateWithMultiValueDepends() throws ComponentInitializationException, ResolutionException {
        TemplatedExecutableSearchFilterBuilder builder = new TemplatedExecutableSearchFilterBuilder();
        builder.setTemplateText("(&(cn=${resolutionContext.principal})(eduPersonEntitlement=${entitlement[0]})(eduPersonEntitlement=${entitlement[1]}))");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        HashMap dependsAttributes = new HashMap();
        ArrayList<StringAttributeValue> attributeValues = new ArrayList<StringAttributeValue>();
        attributeValues.add(new StringAttributeValue("entitlement1"));
        attributeValues.add(new StringAttributeValue("entitlement*"));
        dependsAttributes.put("entitlement", attributeValues);
        ExecutableSearchFilter filter = builder.build(context, dependsAttributes);
        Assert.assertEquals((String)filter.getSearchFilter().format(), (String)"(&(cn=PETER_THE_PRINCIPAL)(eduPersonEntitlement=entitlement1)(eduPersonEntitlement=entitlement\\2a))");
        Assert.assertEquals((String)filter.getResultCacheKey(), (String)"(&(cn=PETER_THE_PRINCIPAL)(eduPersonEntitlement=entitlement1)(eduPersonEntitlement=entitlement\\2a))");
    }

    @Test
    public void escapeTemplate() throws ComponentInitializationException, ResolutionException {
        TemplatedExecutableSearchFilterBuilder builder = new TemplatedExecutableSearchFilterBuilder();
        builder.setTemplateText("(cn=${resolutionContext.principal})");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"domain\\user*", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        ExecutableSearchFilter filter = builder.build(context, null);
        Assert.assertEquals((String)filter.getSearchFilter().format(), (String)"(cn=domain\\5cuser\\2a)");
        Assert.assertEquals((String)filter.getResultCacheKey(), (String)"(cn=domain\\5cuser\\2a)");
    }

    protected void resolve(ExecutableSearchBuilder builder) throws ComponentInitializationException, ResolutionException {
        LDAPDataConnector connector = this.createLdapDataConnector(builder, (SearchResultMappingStrategy)new StringAttributeValueMappingStrategy());
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)connector.resolve(context);
        Assert.assertNotNull((Object)attrs);
        Assert.assertEquals((int)attrs.size(), (int)4);
        Assert.assertEquals((int)((IdPAttribute)attrs.get("uid")).getValues().size(), (int)1);
        Assert.assertEquals((Object)new StringAttributeValue("PETER_THE_PRINCIPAL"), ((IdPAttribute)attrs.get("uid")).getValues().iterator().next());
        Assert.assertEquals((int)((IdPAttribute)attrs.get("cn")).getValues().size(), (int)3);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("Peter Principal")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("Peter J Principal")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("pete principal")));
        Assert.assertEquals((int)((IdPAttribute)attrs.get("sn")).getValues().size(), (int)1);
        Assert.assertEquals((Object)new StringAttributeValue("Principal"), ((IdPAttribute)attrs.get("sn")).getValues().iterator().next());
        Assert.assertEquals((int)((IdPAttribute)attrs.get("mail")).getValues().size(), (int)2);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("peter.principal@shibboleth.net")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("peterprincipal@shibboleth.net")));
    }

    protected void resolveMulti(ExecutableSearchBuilder builder) throws ComponentInitializationException, ResolutionException {
        LDAPDataConnector connector = this.createLdapDataConnector(builder, (SearchResultMappingStrategy)new StringAttributeValueMappingStrategy());
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)connector.resolve(context);
        Assert.assertNotNull((Object)attrs);
        Assert.assertEquals((int)attrs.size(), (int)4);
        Assert.assertEquals((int)((IdPAttribute)attrs.get("uid")).getValues().size(), (int)3);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("uid")).getValues().contains(new StringAttributeValue("PETER_THE_PRINCIPAL")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("uid")).getValues().contains(new StringAttributeValue("PAUL_THE_PRINCIPAL")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("uid")).getValues().contains(new StringAttributeValue("PHILIP_THE_PRINCIPAL")));
        Assert.assertEquals((int)((IdPAttribute)attrs.get("cn")).getValues().size(), (int)5);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("Peter Principal")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("Peter J Principal")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("pete principal")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("Paul Principal")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("Philip Principal")));
        Assert.assertEquals((int)((IdPAttribute)attrs.get("sn")).getValues().size(), (int)3);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("sn")).getValues().contains(new StringAttributeValue("Principal")));
        Assert.assertEquals((int)((IdPAttribute)attrs.get("mail")).getValues().size(), (int)8);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("peter.principal@shibboleth.net")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("peterprincipal@shibboleth.net")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("paul.principal@shibboleth.net")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("paulprincipal@shibboleth.net")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(EmptyAttributeValue.ZERO_LENGTH));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("\"\"")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("  ")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue(" philip.principal@shibboleth.net ")));
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void resolveNoFilter() throws ComponentInitializationException, ResolutionException {
        LDAPDataConnector connector = this.createLdapDataConnector((ExecutableSearchBuilder)new ExecutableSearchBuilder<ExecutableSearchFilter>(){

            @Nonnull
            public ExecutableSearchFilter build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) throws ResolutionException {
                return null;
            }
        }, null);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        connector.resolve(context);
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void resolveNoResultIsError() throws ComponentInitializationException, ResolutionException {
        StringAttributeValueMappingStrategy mappingStrategy = new StringAttributeValueMappingStrategy();
        mappingStrategy.setNoResultAnError(true);
        LDAPDataConnector connector = this.createLdapDataConnector(null, (SearchResultMappingStrategy)mappingStrategy);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        try {
            Map res = (Map)connector.resolve(context);
            Assert.assertNotNull((Object)res);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"Resolution exception occurred", (Throwable)e);
        }
        context = TestSources.createResolutionContext((String)"NOT_A_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        connector.resolve(context);
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void resolveMultipleResultsIsError() throws ComponentInitializationException, ResolutionException {
        StringAttributeValueMappingStrategy mappingStrategy = new StringAttributeValueMappingStrategy();
        mappingStrategy.setMultipleResultsAnError(true);
        LDAPDataConnector connector = this.createLdapDataConnector((ExecutableSearchBuilder)LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(sn={principalName})"), (SearchResultMappingStrategy)mappingStrategy);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"NOT_A_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        try {
            Map res = (Map)connector.resolve(context);
            Assert.assertNull((Object)res);
        }
        catch (ResolutionException e) {
            Assert.fail((String)"Resolution exception occurred", (Throwable)e);
        }
        context = TestSources.createResolutionContext((String)"PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        connector.resolve(context);
    }

    @Test
    public void resolveWithCache() throws ComponentInitializationException, ResolutionException {
        LDAPDataConnector connector = this.createLdapDataConnector(null, null);
        TestCache cache = new TestCache();
        connector.setResultsCache((Cache)cache);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Assert.assertEquals((long)cache.size(), (long)0L);
        Map optional = (Map)connector.resolve(context);
        Assert.assertEquals((long)cache.size(), (long)1L);
        Assert.assertEquals(cache.iterator().next(), (Map)optional);
    }

    @Test
    public void resolveWithCacheCollison() throws ComponentInitializationException, ResolutionException {
        LDAPDataConnector connector = this.createLdapDataConnector(null, null);
        TestCache cache = new TestCache();
        connector.setResultsCache((Cache)cache);
        connector.initialize();
        Assert.assertEquals((long)cache.size(), (long)0L);
        AttributeResolutionContext context1 = TestSources.createResolutionContext((String)"dlo1", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        connector.resolve(context1);
        Assert.assertEquals((long)cache.size(), (long)1L);
        AttributeResolutionContext context2 = TestSources.createResolutionContext((String)"dn11", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        connector.resolve(context2);
        Assert.assertEquals((long)cache.size(), (long)2L);
    }

    @Test
    public void resolveEmptyAttribute() throws ComponentInitializationException, ResolutionException {
        ParameterizedExecutableSearchFilterBuilder builder = LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(uid={principalName})");
        LDAPDataConnector connector = this.createLdapDataConnector((ExecutableSearchBuilder)builder, (SearchResultMappingStrategy)new StringAttributeValueMappingStrategy());
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PHILIP_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)connector.resolve(context);
        Assert.assertNotNull((Object)attrs);
        Assert.assertEquals((int)attrs.size(), (int)4);
        Assert.assertEquals((int)((IdPAttribute)attrs.get("uid")).getValues().size(), (int)1);
        Assert.assertEquals(((IdPAttribute)attrs.get("uid")).getValues().iterator().next(), (Object)new StringAttributeValue("PHILIP_THE_PRINCIPAL"));
        Assert.assertEquals((int)((IdPAttribute)attrs.get("cn")).getValues().size(), (int)1);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("cn")).getValues().contains(new StringAttributeValue("Philip Principal")));
        Assert.assertEquals((int)((IdPAttribute)attrs.get("sn")).getValues().size(), (int)1);
        Assert.assertEquals(((IdPAttribute)attrs.get("sn")).getValues().iterator().next(), (Object)new StringAttributeValue("Principal"));
        Assert.assertEquals((int)((IdPAttribute)attrs.get("mail")).getValues().size(), (int)4);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.ZERO_LENGTH_VALUE)));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("\"\"")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue("  ")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("mail")).getValues().contains(new StringAttributeValue(" philip.principal@shibboleth.net ")));
    }

    public static ParameterizedExecutableSearchFilterBuilder newParameterizedExecutableSearchFilterBuilder(String filter) throws ComponentInitializationException {
        ParameterizedExecutableSearchFilterBuilder builder = new ParameterizedExecutableSearchFilterBuilder();
        builder.setSearchFilter(filter);
        builder.initialize();
        return builder;
    }

    public static ConnectionFactoryValidator newConnectionFactoryValidator(ConnectionFactory connectionFactory, boolean throwValidateError) throws ComponentInitializationException {
        ConnectionFactoryValidator validator = new ConnectionFactoryValidator();
        validator.setConnectionFactory(connectionFactory);
        validator.setThrowValidateError(Boolean.valueOf(throwValidateError));
        validator.initialize();
        return validator;
    }

    public static ConnectionFactoryValidator newConnectionFactoryValidator(ConnectionFactory connectionFactory) throws ComponentInitializationException {
        ConnectionFactoryValidator validator = new ConnectionFactoryValidator();
        validator.setConnectionFactory(connectionFactory);
        validator.initialize();
        return validator;
    }
}

