/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.LDAPDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.LDAPDataConnectorTest;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ParameterizedExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.SearchResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.StringAttributeValueMappingStrategy;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.SearchExecutor;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class Regressions {
    private static final String TEST_CONNECTOR_NAME = "ldapRegressionsAttributeConnector";
    private static final String TEST_BASE_DN = "ou=people,dc=shibboleth,dc=net";
    private static final String[] TEST_RETURN_ATTRIBUTES = new String[]{"cn", "sn", "uid", "mail"};
    private InMemoryDirectoryServer directoryServer;

    @BeforeTest
    public void setupDirectoryServer() throws LDAPException {
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{"dc=shibboleth,dc=net"});
        config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"default", (int)10390)});
        config.addAdditionalBindCredentials("cn=Directory Manager", "password");
        this.directoryServer = new InMemoryDirectoryServer(config);
        this.directoryServer.importFromLDIF(true, "src/test/resources/net/shibboleth/idp/attribute/resolver/impl/dc/ldap/ldapDataConnectorTestEmpty.ldif");
        this.directoryServer.startListening();
    }

    @AfterTest
    public void teardownDirectoryServer() {
        this.directoryServer.shutDown(true);
    }

    protected LDAPDataConnector createLdapDataConnector(ExecutableSearchBuilder builder, SearchResultMappingStrategy strategy) throws ComponentInitializationException {
        LDAPDataConnector connector = new LDAPDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        DefaultConnectionFactory connectionFactory = new DefaultConnectionFactory("ldap://localhost:10390");
        connector.setConnectionFactory((ConnectionFactory)connectionFactory);
        SearchExecutor searchExecutor = new SearchExecutor();
        searchExecutor.setBaseDn(TEST_BASE_DN);
        searchExecutor.setReturnAttributes(TEST_RETURN_ATTRIBUTES);
        connector.setSearchExecutor(searchExecutor);
        connector.setExecutableSearchBuilder((ExecutableSearchBuilder)(builder == null ? LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(uid={principalName})") : builder));
        connector.setValidator((Validator)LDAPDataConnectorTest.newConnectionFactoryValidator((ConnectionFactory)connectionFactory));
        connector.setMappingStrategy((SearchResultMappingStrategy)(strategy == null ? new StringAttributeValueMappingStrategy() : strategy));
        return connector;
    }

    @Test
    public void idP573() throws ComponentInitializationException, ResolutionException {
        ParameterizedExecutableSearchFilterBuilder builder = LDAPDataConnectorTest.newParameterizedExecutableSearchFilterBuilder("(uid={principalName})");
        LDAPDataConnector connector = this.createLdapDataConnector((ExecutableSearchBuilder)builder, (SearchResultMappingStrategy)new StringAttributeValueMappingStrategy());
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)connector.resolve(context);
        List values = ((IdPAttribute)attrs.get("mail")).getValues();
        Assert.assertEquals((int)values.size(), (int)4);
        Assert.assertTrue((boolean)values.contains(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.ZERO_LENGTH_VALUE)));
    }
}

