/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import com.google.common.cache.Cache;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.impl.TestCache;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.DataSourceValidator;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.ExecutableStatement;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.FormatExecutableStatementBuilder;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.RDBMSDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.ResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.StringResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.TemplatedExecutableStatementBuilder;
import net.shibboleth.idp.saml.impl.TestSources;
import net.shibboleth.idp.testing.DatabaseTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.velocity.VelocityEngine;
import org.hsqldb.jdbc.JDBCDataSource;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RDBMSDataConnectorTest {
    private static final String TEST_CONNECTOR_NAME = "rdbmsAttributeConnector";
    private static final String INIT_FILE = "/net/shibboleth/idp/attribute/resolver/impl/dc/rdbms/RdbmsStore.sql";
    private static final String DATA_FILE = "/net/shibboleth/idp/attribute/resolver/impl/dc/rdbms/RdbmsData.sql";
    private static final String USER_QUERY = "SELECT userid, name, homephone, mail FROM people WHERE userid='%s'";
    private static final String GROUP_QUERY = "SELECT name FROM groups WHERE userid='%s'";
    private DataSource datasource;

    @BeforeTest
    public void setupDatabaseServer() throws ClassNotFoundException, SQLException {
        this.datasource = DatabaseTestingSupport.GetMockDataSource((String)INIT_FILE, (String)"RDBMSDataConnectorStore");
        DatabaseTestingSupport.InitializeDataSourceFromFile((String)DATA_FILE, (DataSource)this.datasource);
    }

    protected RDBMSDataConnector createUserRdbmsDataConnector(ExecutableSearchBuilder builder, ResultMappingStrategy strategy) {
        RDBMSDataConnector connector = new RDBMSDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        connector.setDataSource(this.datasource);
        connector.setExecutableSearchBuilder((ExecutableSearchBuilder)(builder == null ? RDBMSDataConnectorTest.newFormatExecutableStatementBuilder(USER_QUERY) : builder));
        connector.setMappingStrategy((ResultMappingStrategy)(strategy == null ? new StringResultMappingStrategy() : strategy));
        return connector;
    }

    protected RDBMSDataConnector createGroupRdbmsDataConnector(ExecutableSearchBuilder builder, ResultMappingStrategy strategy) {
        RDBMSDataConnector connector = new RDBMSDataConnector();
        connector.setId("rdbmsAttributeConnectorForGroups");
        connector.setDataSource(this.datasource);
        connector.setExecutableSearchBuilder((ExecutableSearchBuilder)(builder == null ? RDBMSDataConnectorTest.newFormatExecutableStatementBuilder(GROUP_QUERY) : builder));
        connector.setMappingStrategy((ResultMappingStrategy)(strategy == null ? new StringResultMappingStrategy() : strategy));
        return connector;
    }

    @Test
    public void initializeAndGetters() throws ComponentInitializationException, ResolutionException {
        RDBMSDataConnector connector = new RDBMSDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        try {
            connector.initialize();
            Assert.fail((String)"No datasource");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        connector.setDataSource((DataSource)new JDBCDataSource());
        try {
            connector.initialize();
            Assert.fail((String)"No statement builder");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        FormatExecutableStatementBuilder statementBuilder = RDBMSDataConnectorTest.newFormatExecutableStatementBuilder(USER_QUERY);
        connector.setExecutableSearchBuilder((ExecutableSearchBuilder)statementBuilder);
        try {
            connector.initialize();
            Assert.fail((String)"Invalid datasource");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        connector.setDataSource(this.datasource);
        StringResultMappingStrategy mappingStrategy = new StringResultMappingStrategy();
        connector.setMappingStrategy((ResultMappingStrategy)mappingStrategy);
        try {
            connector.resolve(null);
            Assert.fail((String)"Need to initialize first");
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        connector.initialize();
        try {
            connector.setDataSource(null);
            Assert.fail((String)"Setter after initialize");
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)connector.getDataSource(), (Object)this.datasource);
        Assert.assertEquals((Object)connector.getExecutableSearchBuilder(), (Object)statementBuilder);
        Assert.assertEquals((Object)connector.getMappingStrategy(), (Object)mappingStrategy);
    }

    @Test
    public void failFastInitialize() throws ComponentInitializationException {
        RDBMSDataConnector connector = new RDBMSDataConnector();
        connector.setId(TEST_CONNECTOR_NAME);
        FormatExecutableStatementBuilder statementBuilder = RDBMSDataConnectorTest.newFormatExecutableStatementBuilder(USER_QUERY);
        connector.setExecutableSearchBuilder((ExecutableSearchBuilder)statementBuilder);
        connector.setDataSource((DataSource)new JDBCDataSource());
        try {
            connector.initialize();
            Assert.fail((String)"No failfast");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        DataSourceValidator validator = new DataSourceValidator();
        validator.setDataSource(this.datasource);
        validator.setThrowValidateError(false);
        validator.initialize();
        connector.setValidator((Validator)validator);
        connector.initialize();
    }

    @Test
    public void resolveTemplateWithDepends() throws ComponentInitializationException, ResolutionException {
        TemplatedExecutableStatementBuilder builder = new TemplatedExecutableStatementBuilder();
        builder.setTemplateText("SELECT userid FROM people WHERE userid='${resolutionContext.principal}' AND affiliation='${affiliation[0]}'");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        HashMap dependsAttributes = new HashMap();
        ArrayList<StringAttributeValue> attributeValues = new ArrayList<StringAttributeValue>();
        attributeValues.add(new StringAttributeValue("student"));
        dependsAttributes.put("affiliation", attributeValues);
        String query = builder.getSQLQuery(context, dependsAttributes);
        Assert.assertEquals((String)query, (String)"SELECT userid FROM people WHERE userid='PETER_THE_PRINCIPAL' AND affiliation='student'");
    }

    @Test
    public void resolveTemplateWithMultiValueDepends() throws ComponentInitializationException, ResolutionException {
        TemplatedExecutableStatementBuilder builder = new TemplatedExecutableStatementBuilder();
        builder.setTemplateText("SELECT userid FROM people WHERE userid='${resolutionContext.principal}' AND eduPersonEntitlement='${entitlement[0]}' AND eduPersonEntitlement='${entitlement[1]}'");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        HashMap dependsAttributes = new HashMap();
        ArrayList<StringAttributeValue> attributeValues = new ArrayList<StringAttributeValue>();
        attributeValues.add(new StringAttributeValue("entitlement1"));
        attributeValues.add(new StringAttributeValue("entitlement2"));
        dependsAttributes.put("entitlement", attributeValues);
        String query = builder.getSQLQuery(context, dependsAttributes);
        Assert.assertEquals((String)query, (String)"SELECT userid FROM people WHERE userid='PETER_THE_PRINCIPAL' AND eduPersonEntitlement='entitlement1' AND eduPersonEntitlement='entitlement2'");
    }

    @Test
    public void escapeTemplate() throws ComponentInitializationException, ResolutionException {
        TemplatedExecutableStatementBuilder builder = new TemplatedExecutableStatementBuilder();
        builder.setTemplateText("SELECT userid FROM people WHERE userid='${resolutionContext.principal}'");
        builder.setVelocityEngine(VelocityEngine.newVelocityEngine());
        builder.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"McHale's Navy", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        String query = builder.getSQLQuery(context, null);
        Assert.assertEquals((String)query, (String)"SELECT userid FROM people WHERE userid='McHale''s Navy'");
    }

    @Test
    public void resolve() throws ComponentInitializationException, ResolutionException {
        RDBMSDataConnector connector = this.createUserRdbmsDataConnector(null, null);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)connector.resolve(context);
        Assert.assertTrue((attrs.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((IdPAttribute)attrs.get("USERID")).getValues().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)new StringAttributeValue("PETER_THE_PRINCIPAL"), ((IdPAttribute)attrs.get("USERID")).getValues().iterator().next());
        Assert.assertTrue((((IdPAttribute)attrs.get("NAME")).getValues().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)new StringAttributeValue("Peter Principal"), ((IdPAttribute)attrs.get("NAME")).getValues().iterator().next());
        Assert.assertTrue((((IdPAttribute)attrs.get("HOMEPHONE")).getValues().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)new StringAttributeValue("555-111-2222"), ((IdPAttribute)attrs.get("HOMEPHONE")).getValues().iterator().next());
        Assert.assertTrue((((IdPAttribute)attrs.get("MAIL")).getValues().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)new StringAttributeValue("peter.principal@shibboleth.net"), ((IdPAttribute)attrs.get("MAIL")).getValues().iterator().next());
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void resolveNoStatement() throws ComponentInitializationException, ResolutionException {
        RDBMSDataConnector connector = this.createUserRdbmsDataConnector((ExecutableSearchBuilder)new ExecutableSearchBuilder<ExecutableStatement>(){

            @Nonnull
            public ExecutableStatement build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue<?>>> dependencyAttributes) throws ResolutionException {
                return null;
            }
        }, null);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        connector.resolve(context);
    }

    @Test(expectedExceptions={ResolutionException.class})
    public void resolveNoResultIsError() throws ComponentInitializationException, ResolutionException {
        StringResultMappingStrategy mappingStrategy = new StringResultMappingStrategy();
        mappingStrategy.setNoResultAnError(true);
        RDBMSDataConnector connector = this.createUserRdbmsDataConnector(null, (ResultMappingStrategy)mappingStrategy);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        try {
            Assert.assertNotNull((Object)connector.resolve(context));
        }
        catch (ResolutionException e) {
            Assert.fail((String)"Resolution exception occurred", (Throwable)e);
        }
        context = TestSources.createResolutionContext((String)"NOT_A_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        connector.resolve(context);
    }

    @Test(enabled=false, expectedExceptions={ResolutionException.class})
    public void resolveMultipleResultsIsError() throws ComponentInitializationException, ResolutionException {
        StringResultMappingStrategy mappingStrategy = new StringResultMappingStrategy();
        mappingStrategy.setMultipleResultsAnError(true);
        RDBMSDataConnector connector = this.createGroupRdbmsDataConnector(null, (ResultMappingStrategy)mappingStrategy);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"NOT_A_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        try {
            Assert.assertNull((Object)connector.resolve(context));
        }
        catch (ResolutionException e) {
            Assert.fail((String)"Resolution exception occurred", (Throwable)e);
        }
        context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        connector.resolve(context);
    }

    @Test
    public void resolveWithCache() throws ComponentInitializationException, ResolutionException {
        RDBMSDataConnector connector = this.createUserRdbmsDataConnector(null, null);
        TestCache cache = new TestCache();
        connector.setResultsCache((Cache)cache);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Assert.assertTrue((cache.size() == 0L ? 1 : 0) != 0);
        Map optional = (Map)connector.resolve(context);
        Assert.assertTrue((cache.size() == 1L ? 1 : 0) != 0);
        Assert.assertEquals(cache.iterator().next(), (Map)optional);
    }

    @Test
    public void resolveMultiple() throws ComponentInitializationException, ResolutionException {
        RDBMSDataConnector connector = this.createGroupRdbmsDataConnector(null, null);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PETER_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)connector.resolve(context);
        Assert.assertTrue((attrs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((IdPAttribute)attrs.get("NAME")).getValues().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("NAME")).getValues().contains(new StringAttributeValue("group1")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("NAME")).getValues().contains(new StringAttributeValue("group2")));
    }

    @Test
    public void resolveEmptyAttribute() throws ComponentInitializationException, ResolutionException {
        RDBMSDataConnector connector = this.createUserRdbmsDataConnector(null, null);
        connector.initialize();
        AttributeResolutionContext context = TestSources.createResolutionContext((String)"PHILIP_THE_PRINCIPAL", (String)"https://idp.example.org/idp", (String)"https://sp.example.org/sp");
        Map attrs = (Map)connector.resolve(context);
        Assert.assertTrue((attrs.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((IdPAttribute)attrs.get("USERID")).getValues().size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals(((IdPAttribute)attrs.get("USERID")).getValues().iterator().next(), (Object)new StringAttributeValue("PHILIP_THE_PRINCIPAL"));
        Assert.assertTrue((((IdPAttribute)attrs.get("NAME")).getValues().size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals(((IdPAttribute)attrs.get("NAME")).getValues().iterator().next(), (Object)new StringAttributeValue("Philip Principal"));
        Assert.assertTrue((((IdPAttribute)attrs.get("HOMEPHONE")).getValues().size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals(((IdPAttribute)attrs.get("HOMEPHONE")).getValues().iterator().next(), (Object)new StringAttributeValue("555-111-4444"));
        Assert.assertTrue((((IdPAttribute)attrs.get("MAIL")).getValues().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("MAIL")).getValues().contains(EmptyAttributeValue.NULL));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("MAIL")).getValues().contains(EmptyAttributeValue.ZERO_LENGTH));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("MAIL")).getValues().contains(new StringAttributeValue("  ")));
        Assert.assertTrue((boolean)((IdPAttribute)attrs.get("MAIL")).getValues().contains(new StringAttributeValue(" phil.principal@shibboleth.net ")));
    }

    protected static FormatExecutableStatementBuilder newFormatExecutableStatementBuilder(@Nonnull String query) {
        FormatExecutableStatementBuilder builder = new FormatExecutableStatementBuilder();
        builder.setQuery(query);
        return builder;
    }

    protected static FormatExecutableStatementBuilder newFormatExecutableStatementBuilder(@Nonnull String query, @Nonnull int timeout) {
        FormatExecutableStatementBuilder builder = new FormatExecutableStatementBuilder();
        builder.setQuery(query);
        builder.setQueryTimeout(timeout);
        return builder;
    }
}

