/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import com.google.common.base.Function;
import java.util.HashSet;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.navigate.AttributeIssuerIdLookupFunction;
import net.shibboleth.idp.attribute.resolver.context.navigate.AttributePrincipalLookupFunction;
import net.shibboleth.idp.attribute.resolver.context.navigate.AttributeRecipientIdLookupFunction;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeResolutionContextTest {
    private static final String THE_ISSUER = "Issuer";
    private static final String THE_RECIPIENT = "Recipient";
    private static final String THE_PRINCIPAL = "Principal";

    @Test
    public void instantiation() {
        AttributeResolutionContext context = new AttributeResolutionContext();
        Assert.assertNull((Object)context.getParent());
        Assert.assertNotNull((Object)context.getRequestedIdPAttributeNames());
        Assert.assertTrue((boolean)context.getRequestedIdPAttributeNames().isEmpty());
    }

    @Test
    public void setRequesedAttributes() {
        AttributeResolutionContext context = new AttributeResolutionContext();
        HashSet<String> attributes = new HashSet<String>();
        context.setRequestedIdPAttributeNames(attributes);
        Assert.assertNotNull((Object)context.getRequestedIdPAttributeNames());
        Assert.assertTrue((boolean)context.getRequestedIdPAttributeNames().isEmpty());
        attributes.add(null);
        context.setRequestedIdPAttributeNames(attributes);
        Assert.assertNotNull((Object)context.getRequestedIdPAttributeNames());
        Assert.assertTrue((boolean)context.getRequestedIdPAttributeNames().isEmpty());
        attributes.add("foo");
        attributes.add(null);
        attributes.add("bar");
        context.setRequestedIdPAttributeNames(attributes);
        Assert.assertNotNull((Object)context.getRequestedIdPAttributeNames());
        Assert.assertEquals((int)context.getRequestedIdPAttributeNames().size(), (int)2);
        attributes.clear();
        attributes.add("baz");
        context.setRequestedIdPAttributeNames(attributes);
        Assert.assertNotNull((Object)context.getRequestedIdPAttributeNames());
        Assert.assertEquals((int)context.getRequestedIdPAttributeNames().size(), (int)1);
    }

    @Test
    public void setResolvedAttributes() {
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.setResolvedIdPAttributes(null);
        Assert.assertNotNull((Object)context.getResolvedIdPAttributes());
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
        HashSet<IdPAttribute> attributes = new HashSet<IdPAttribute>();
        context.setResolvedIdPAttributes(attributes);
        Assert.assertNotNull((Object)context.getResolvedIdPAttributes());
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
        attributes.add(null);
        context.setResolvedIdPAttributes(attributes);
        Assert.assertNotNull((Object)context.getResolvedIdPAttributes());
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
        attributes.add(new IdPAttribute("foo"));
        attributes.add(null);
        attributes.add(new IdPAttribute("bar"));
        context.setResolvedIdPAttributes(attributes);
        Assert.assertNotNull((Object)context.getResolvedIdPAttributes());
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)2);
        attributes.clear();
        attributes.add(new IdPAttribute("baz"));
        context.setResolvedIdPAttributes(attributes);
        Assert.assertNotNull((Object)context.getResolvedIdPAttributes());
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)1);
    }

    @Test
    public void lookupsParent() {
        ProfileRequestContext profileCtx = new ProfileRequestContext();
        AttributeResolutionContext context = (AttributeResolutionContext)profileCtx.getSubcontext(AttributeResolutionContext.class, true);
        context.setPrincipal(THE_PRINCIPAL);
        context.setAttributeIssuerID(THE_ISSUER);
        context.setAttributeRecipientID(THE_RECIPIENT);
        Assert.assertSame((Object)context.getPrincipal(), (Object)THE_PRINCIPAL);
        Assert.assertSame((Object)context.getAttributeIssuerID(), (Object)THE_ISSUER);
        Assert.assertSame((Object)context.getAttributeRecipientID(), (Object)THE_RECIPIENT);
        AttributePrincipalLookupFunction principalFn = new AttributePrincipalLookupFunction();
        AttributeRecipientIdLookupFunction recipientFn = new AttributeRecipientIdLookupFunction();
        AttributeIssuerIdLookupFunction issuerFn = new AttributeIssuerIdLookupFunction();
        Assert.assertSame((Object)principalFn.apply((Object)profileCtx), (Object)THE_PRINCIPAL);
        Assert.assertSame((Object)issuerFn.apply((Object)profileCtx), (Object)THE_ISSUER);
        Assert.assertSame((Object)recipientFn.apply((Object)profileCtx), (Object)THE_RECIPIENT);
    }

    @Test
    public void lookupsChild() {
        AttributeResolutionContext context = new AttributeResolutionContext();
        ProfileRequestContext profileCtx = (ProfileRequestContext)context.getSubcontext(ProfileRequestContext.class, true);
        context.setPrincipal(THE_PRINCIPAL);
        context.setAttributeIssuerID(THE_ISSUER);
        context.setAttributeRecipientID(THE_RECIPIENT);
        AttributePrincipalLookupFunction principalFn = new AttributePrincipalLookupFunction();
        AttributeRecipientIdLookupFunction recipientFn = new AttributeRecipientIdLookupFunction();
        AttributeIssuerIdLookupFunction issuerFn = new AttributeIssuerIdLookupFunction();
        Assert.assertNull((Object)principalFn.apply(profileCtx), (String)THE_PRINCIPAL);
        Assert.assertNull((Object)issuerFn.apply(profileCtx), (String)THE_ISSUER);
        Assert.assertNull((Object)recipientFn.apply(profileCtx), (String)THE_RECIPIENT);
        principalFn.setAttributeResolutionContextLookupStrategy((Function)new ParentContextLookup());
        recipientFn.setAttributeResolutionContextLookupStrategy((Function)new ParentContextLookup());
        issuerFn.setAttributeResolutionContextLookupStrategy((Function)new ParentContextLookup());
        Assert.assertSame((Object)principalFn.apply(profileCtx), (Object)THE_PRINCIPAL);
        Assert.assertSame((Object)issuerFn.apply(profileCtx), (Object)THE_ISSUER);
        Assert.assertSame((Object)recipientFn.apply(profileCtx), (Object)THE_RECIPIENT);
    }
}

