/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.LegacyPrincipalDecoder;
import net.shibboleth.idp.attribute.resolver.MockAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.MockDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.ad.impl.SimpleAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeResolverImplTest {
    private final Logger log = LoggerFactory.getLogger(AttributeResolverImplTest.class);

    @Test
    public void initDestroy() throws Exception {
        MockAttributeDefinition attrDef = new MockAttributeDefinition("foo", new IdPAttribute("test"));
        MockDataConnector dataCon = new MockDataConnector("bar", (Map)null);
        dataCon.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("toto", Collections.singleton(attrDef), Collections.singleton(dataCon), null);
        Assert.assertFalse((boolean)attrDef.isInitialized());
        Assert.assertFalse((boolean)attrDef.isDestroyed());
        Assert.assertFalse((boolean)dataCon.isDestroyed());
        attrDef.initialize();
        resolver.initialize();
        Assert.assertTrue((boolean)attrDef.isInitialized());
        Assert.assertFalse((boolean)attrDef.isDestroyed());
        Assert.assertTrue((boolean)dataCon.isInitialized());
        Assert.assertFalse((boolean)dataCon.isDestroyed());
        Assert.assertEquals((String)resolver.getId(), (String)"toto");
        Assert.assertEquals((int)resolver.getAttributeDefinitions().size(), (int)1);
        Assert.assertTrue((boolean)resolver.getAttributeDefinitions().containsKey("foo"));
        Assert.assertEquals((int)resolver.getDataConnectors().size(), (int)1);
        Assert.assertTrue((boolean)resolver.getDataConnectors().containsKey("bar"));
        attrDef.destroy();
        resolver.destroy();
        dataCon.destroy();
        Assert.assertTrue((boolean)attrDef.isInitialized());
        Assert.assertTrue((boolean)attrDef.isDestroyed());
        Assert.assertTrue((boolean)dataCon.isInitialized());
        Assert.assertTrue((boolean)dataCon.isDestroyed());
        try {
            resolver.initialize();
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void setAttributeDefinitions() throws Exception {
        ArrayList<AttributeDefinition> definitions = new ArrayList<AttributeDefinition>();
        definitions.add((AttributeDefinition)new MockAttributeDefinition("foo", new IdPAttribute("test")));
        definitions.add(null);
        definitions.add((AttributeDefinition)new MockAttributeDefinition("bar", new IdPAttribute("test")));
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl(" foo ", definitions, null, null);
        resolver.initialize();
        Assert.assertNotNull((Object)resolver.getAttributeDefinitions());
        Assert.assertEquals((int)resolver.getAttributeDefinitions().size(), (int)2);
        definitions.add((AttributeDefinition)new MockAttributeDefinition("foo", new IdPAttribute("test")));
        try {
            AttributeResolverImplTest.newAttributeResolverImpl(" foo ", definitions, null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setDataConnectors() throws Exception {
        ArrayList<DataConnector> connectors = new ArrayList<DataConnector>();
        connectors.add((DataConnector)new MockDataConnector("foo", (Map)null));
        connectors.add(null);
        connectors.add((DataConnector)new MockDataConnector("bar", (Map)null));
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", null, connectors, null);
        Assert.assertNotNull((Object)resolver.getDataConnectors());
        Assert.assertEquals((int)resolver.getDataConnectors().size(), (int)2);
        connectors.add((DataConnector)new MockDataConnector("foo", (Map)null));
        try {
            AttributeResolverImplTest.newAttributeResolverImpl(" foo ", null, connectors, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resolve() throws Exception {
        IdPAttribute attribute = new IdPAttribute("ad1");
        attribute.setValues(Collections.singletonList(new StringAttributeValue("value1")));
        LazySet definitions = new LazySet();
        definitions.add((Object)new MockAttributeDefinition("ad1", attribute));
        ((AttributeDefinition)definitions.iterator().next()).initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)1);
        Assert.assertEquals(context.getResolvedIdPAttributes().get("ad1"), (Object)attribute);
    }

    @Test
    public void resolveSpecificAttribute() throws Exception {
        IdPAttribute attribute = new IdPAttribute("ad1");
        attribute.setValues(Collections.singletonList(new StringAttributeValue("value1")));
        LazySet definitions = new LazySet();
        definitions.add((Object)new MockAttributeDefinition("ad1", attribute));
        ((AttributeDefinition)definitions.iterator().next()).initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        context.setRequestedIdPAttributeNames(Collections.singleton("ad1"));
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)1);
        Assert.assertEquals(context.getResolvedIdPAttributes().get("ad1"), (Object)attribute);
        context = new AttributeResolutionContext();
        context.setRequestedIdPAttributeNames(Collections.singleton("1da"));
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
    }

    @Test
    public void resolveFails() throws Exception {
        this.log.debug("Log Resolve fails");
        IdPAttribute attribute = new IdPAttribute("ad1");
        attribute.setValues(Collections.singletonList(new StringAttributeValue("value1")));
        LazySet definitions = new LazySet();
        MockAttributeDefinition attrDef = new MockAttributeDefinition("ad1", new ResolutionException());
        attrDef.setPropagateResolutionExceptions(true);
        definitions.add((Object)attrDef);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        attrDef.initialize();
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
            Assert.fail();
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
        definitions = new LazySet();
        attrDef = new MockAttributeDefinition("ad1", new ResolutionException());
        attrDef.setPropagateResolutionExceptions(false);
        definitions.add((Object)attrDef);
        resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        attrDef.initialize();
        context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
        this.log.debug("Logged Resolve fails");
    }

    @Test
    public void resolveEmpty() throws Exception {
        LazySet definitions = new LazySet();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
    }

    @Test
    public void resolveWithDependenciesOld() throws Exception {
        MockDataConnector dc1 = new MockDataConnector("dc1", (Map)null);
        dc1.initialize();
        IdPAttribute attr = new IdPAttribute("test");
        attr.setValues(Arrays.asList(new StringAttributeValue("a"), new StringAttributeValue("b")));
        ResolverPluginDependency dep1 = new ResolverPluginDependency("dc1");
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", attr);
        ad1.setDependencies(Collections.singleton(dep1));
        ad1.initialize();
        MockAttributeDefinition ad2 = new MockAttributeDefinition("ad2", attr);
        ResolverPluginDependency dep2 = new ResolverPluginDependency("ad1");
        ResolverPluginDependency dep3 = new ResolverPluginDependency("ad2");
        MockAttributeDefinition ad0 = new MockAttributeDefinition("ad0", attr);
        ad0.setDependencies(new HashSet<ResolverPluginDependency>(Arrays.asList(dep2, dep3)));
        ad0.initialize();
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        LazySet definitions = new LazySet();
        definitions.add((Object)ad0);
        definitions.add((Object)ad1);
        definitions.add((Object)ad2);
        ad2.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)1);
        Assert.assertEquals((int)((IdPAttribute)context.getResolvedIdPAttributes().get("test")).getValues().size(), (int)2);
    }

    @Test
    public void resolveWithDependencies() throws Exception {
        MockDataConnector dc1 = new MockDataConnector("dc1", (Map)null);
        dc1.initialize();
        IdPAttribute attr = new IdPAttribute("test");
        attr.setValues(Arrays.asList(new StringAttributeValue("a"), new StringAttributeValue("b")));
        ResolverDataConnectorDependency dep1 = new ResolverDataConnectorDependency("dc1");
        dep1.setAllAttributes(true);
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", attr);
        ad1.setDependencies(Collections.singleton(dep1));
        ad1.initialize();
        MockAttributeDefinition ad2 = new MockAttributeDefinition("ad2", attr);
        ResolverAttributeDefinitionDependency dep2 = new ResolverAttributeDefinitionDependency("ad1");
        ResolverAttributeDefinitionDependency dep3 = new ResolverAttributeDefinitionDependency("ad2");
        MockAttributeDefinition ad0 = new MockAttributeDefinition("ad0", attr);
        ad0.setDependencies(new HashSet<ResolverPluginDependency>(Arrays.asList(dep2, dep3)));
        ad0.initialize();
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        LazySet definitions = new LazySet();
        definitions.add((Object)ad0);
        definitions.add((Object)ad1);
        definitions.add((Object)ad2);
        ad2.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)1);
        Assert.assertEquals((int)((IdPAttribute)context.getResolvedIdPAttributes().get("test")).getValues().size(), (int)2);
    }

    @Test
    public void resolveWithDependencyFail1() throws ComponentInitializationException, ResolutionException {
        MockDataConnector dc1 = new MockDataConnector("dc1", new HashMap());
        dc1.setFailoverDataConnectorId("dc2");
        dc1.initialize();
        ResolverPluginDependency dep1 = new ResolverPluginDependency("dc1");
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", new IdPAttribute("test"));
        ad1.setDependencies(Collections.singleton(dep1));
        ad1.initialize();
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        LazySet definitions = new LazySet();
        definitions.add((Object)ad1);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        dc1.initialize();
        ad1.initialize();
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
    }

    @Test(enabled=true)
    public void resolveWithTimeout() throws Exception {
        IdPAttribute i1Val = new IdPAttribute("Atr");
        i1Val.setValues(Collections.singleton(new StringAttributeValue("value1")));
        MockDataConnector dc1 = new MockDataConnector("dc1", Collections.singletonMap("Atr", i1Val));
        SimpleAttributeDefinition ad = new SimpleAttributeDefinition();
        ad.setId("output");
        ad.setSourceAttributeId("Atr");
        ResolverPluginDependency dep1 = new ResolverPluginDependency("dc1");
        ad.setDependencies(Collections.singleton(dep1));
        ad.initialize();
        IdPAttribute i2Val = new IdPAttribute("Atr");
        HashSet<StringAttributeValue> vals = new HashSet<StringAttributeValue>();
        vals.add(new StringAttributeValue("value1"));
        vals.add(new StringAttributeValue("value2"));
        i2Val.setValues(vals);
        MockDataConnector dc2 = new MockDataConnector("dc2", Collections.singletonMap("Atr", i2Val));
        dc2.initialize();
        dc1.setFailoverDataConnectorId("dc2");
        dc1.setNoRetryDelay(3000L);
        dc1.initialize();
        HashSet<DataConnector> connectors = new HashSet<DataConnector>(2);
        connectors.add((DataConnector)dc2);
        connectors.add((DataConnector)dc1);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", Collections.singleton(ad), connectors, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)((IdPAttribute)context.getResolvedIdPAttributes().get("output")).getValues().size(), (int)1);
        dc1.setFailure(true);
        context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)((IdPAttribute)context.getResolvedIdPAttributes().get("output")).getValues().size(), (int)2);
        dc1.setFailure(false);
        context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)((IdPAttribute)context.getResolvedIdPAttributes().get("output")).getValues().size(), (int)2);
        Thread.sleep(6200L);
        context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)((IdPAttribute)context.getResolvedIdPAttributes().get("output")).getValues().size(), (int)1);
    }

    @Test
    public void resolveDataConnectorFail() throws ComponentInitializationException, ResolutionException {
        MockDataConnector dc1 = new MockDataConnector("dc1", new HashMap());
        dc1.setFailure(true);
        dc1.initialize();
        ResolverPluginDependency dep1 = new ResolverPluginDependency("dc1");
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", new IdPAttribute("test"));
        ad1.setDependencies(Collections.singleton(dep1));
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        LazySet definitions = new LazySet();
        definitions.add((Object)ad1);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        dc1.initialize();
        ad1.initialize();
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        try {
            resolver.resolveAttributes(context);
            Assert.fail();
        }
        catch (ResolutionException resolutionException) {
            // empty catch block
        }
    }

    @Test
    public void cachedDataConnectorDependency() throws ComponentInitializationException, ResolutionException {
        MockDataConnector dc1 = new MockDataConnector("dc1", (Map)null);
        dc1.initialize();
        ResolverPluginDependency dep1 = new ResolverPluginDependency("dc1");
        IdPAttribute attr = new IdPAttribute("test1");
        attr.setValues(Collections.singletonList(new StringAttributeValue("value1")));
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", attr);
        ad1.setDependencies(Collections.singleton(dep1));
        ad1.initialize();
        attr = new IdPAttribute("test2");
        attr.setValues(Collections.singletonList(new StringAttributeValue("value2")));
        MockAttributeDefinition ad2 = new MockAttributeDefinition("ad2", attr);
        ad2.setDependencies(Collections.singleton(new ResolverPluginDependency("dc1")));
        ad2.initialize();
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        LazySet definitions = new LazySet();
        definitions.add((Object)ad1);
        definitions.add((Object)ad2);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)2);
        MockDataConnector dcfail1 = new MockDataConnector("failer1", new HashMap());
        dcfail1.setFailure(true);
        dcfail1.setPropagateResolutionExceptions(false);
        dcfail1.initialize();
        ResolverPluginDependency depFail1 = new ResolverPluginDependency("failer1");
        MockDataConnector dcfail2 = new MockDataConnector("failer2", new HashMap());
        dcfail2.setFailure(true);
        dcfail2.setFailoverDataConnectorId("failer1");
        dcfail2.initialize();
        ResolverPluginDependency depFail2 = new ResolverPluginDependency("failer2");
        connectors = new LazySet();
        connectors.add((Object)dcfail1);
        connectors.add((Object)dcfail2);
        MockAttributeDefinition ad10 = new MockAttributeDefinition("ad10", new IdPAttribute("ten"));
        ad10.setDependencies(Collections.singleton(depFail1));
        ad10.setPropagateResolutionExceptions(false);
        ad10.initialize();
        MockAttributeDefinition ad11 = new MockAttributeDefinition("ad11", new IdPAttribute("eleven"));
        ad11.setDependencies(Collections.singleton(depFail2));
        ad11.setPropagateResolutionExceptions(false);
        ad11.initialize();
        definitions = new LazySet();
        definitions.add((Object)ad10);
        definitions.add((Object)ad11);
        resolver = AttributeResolverImplTest.newAttributeResolverImpl("failoverTest", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        resolver.initialize();
    }

    @Test
    public void dataConnectorWithDataDependencyOld() throws ComponentInitializationException, ResolutionException {
        HashMap<String, IdPAttribute> values = new HashMap<String, IdPAttribute>(1);
        IdPAttribute attr = new IdPAttribute("SubAttribute");
        attr.setValues(Collections.singletonList(new StringAttributeValue("SubValue1")));
        values.put("SubAttribute", attr);
        MockDataConnector dc1 = new MockDataConnector("dc1", values);
        dc1.initialize();
        ResolverPluginDependency dep1 = new ResolverPluginDependency("dc1");
        dep1.setDependencyAttributeId("SubAttribute");
        attr = new IdPAttribute("test1");
        attr.setValues(Collections.singletonList(new StringAttributeValue("value1")));
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", attr);
        ad1.setDependencies(Collections.singleton(dep1));
        ad1.initialize();
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        LazySet definitions = new LazySet();
        definitions.add((Object)ad1);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)1);
    }

    @Test
    public void dataConnectorWithDataDependency() throws ComponentInitializationException, ResolutionException {
        HashMap<String, IdPAttribute> values = new HashMap<String, IdPAttribute>(1);
        IdPAttribute attr = new IdPAttribute("SubAttribute");
        attr.setValues(Collections.singletonList(new StringAttributeValue("SubValue1")));
        values.put("SubAttribute", attr);
        MockDataConnector dc1 = new MockDataConnector("dc1", values);
        dc1.initialize();
        ResolverDataConnectorDependency dep1 = new ResolverDataConnectorDependency("dc1");
        dep1.setAttributeNames(Collections.singleton("SubAttribute"));
        attr = new IdPAttribute("test1");
        attr.setValues(Collections.singletonList(new StringAttributeValue("value1")));
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", attr);
        ad1.setDependencies(Collections.singleton(dep1));
        ad1.initialize();
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        LazySet definitions = new LazySet();
        definitions.add((Object)ad1);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertEquals((int)context.getResolvedIdPAttributes().size(), (int)1);
    }

    @Test
    public void resolveCleanNullAttributes() throws Exception {
        LazySet definitions = new LazySet();
        definitions.add((Object)new MockAttributeDefinition("ad1", new IdPAttribute("test")));
        ((AttributeDefinition)definitions.iterator().next()).initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
    }

    @Test
    public void resolveCleanDependencyOnly() throws Exception {
        IdPAttribute attribute = new IdPAttribute("ad1");
        attribute.setValues(Collections.singletonList(new StringAttributeValue("value1")));
        MockAttributeDefinition definition = new MockAttributeDefinition("ad1", attribute);
        definition.setDependencyOnly(true);
        LazySet definitions = new LazySet();
        definitions.add((Object)definition);
        definition.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
    }

    @Test
    public void resolveCleanDuplicateValues() throws Exception {
        IdPAttribute attribute = new IdPAttribute("ad1");
        attribute.setValues(Arrays.asList(new StringAttributeValue("value1"), new StringAttributeValue("value1")));
        MockAttributeDefinition definition = new MockAttributeDefinition("ad1", attribute);
        LazySet definitions = new LazySet();
        definitions.add((Object)definition);
        definition.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().containsKey("ad1"));
        Assert.assertEquals((int)((IdPAttribute)context.getResolvedIdPAttributes().get("ad1")).getValues().size(), (int)1);
    }

    @Test
    public void resolveNullValues() throws Exception {
        IdPAttribute attribute = new IdPAttribute("ad1");
        attribute.setValues(Arrays.asList(new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE), new EmptyAttributeValue(EmptyAttributeValue.EmptyType.ZERO_LENGTH_VALUE), null));
        MockAttributeDefinition definition = new MockAttributeDefinition("ad1", attribute);
        LazySet definitions = new LazySet();
        definitions.add((Object)definition);
        definition.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().containsKey("ad1"));
        Assert.assertEquals((int)((IdPAttribute)context.getResolvedIdPAttributes().get("ad1")).getValues().size(), (int)2);
        resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.setStripNulls(Boolean.valueOf(true));
        resolver.initialize();
        context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
    }

    @Test
    public void resolveCleanEmptyValueAttributes() throws Exception {
        IdPAttribute attribute = new IdPAttribute("ad1");
        MockAttributeDefinition definition = new MockAttributeDefinition("ad1", attribute);
        definition.setDependencyOnly(true);
        LazySet definitions = new LazySet();
        definitions.add((Object)definition);
        definition.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        AttributeResolutionContext context = new AttributeResolutionContext();
        resolver.resolveAttributes(context);
        Assert.assertTrue((boolean)context.getResolvedIdPAttributes().isEmpty());
    }

    @Test
    public void badPluginIdInitialize() throws Exception {
        ResolverDataConnectorDependency dep1 = new ResolverDataConnectorDependency("dc1");
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", new IdPAttribute("test"));
        ad1.setDependencies(Collections.singleton(dep1));
        ad1.initialize();
        ResolverAttributeDefinitionDependency dep2 = new ResolverAttributeDefinitionDependency("ad1");
        MockAttributeDefinition ad0 = new MockAttributeDefinition("ad0", new IdPAttribute("test"));
        ad0.setDependencies(Collections.singleton(dep2));
        ad0.initialize();
        LazySet definitions = new LazySet();
        definitions.add((Object)ad0);
        definitions.add((Object)ad1);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        try {
            resolver.initialize();
            Assert.fail((String)"invalid resolver configuration didn't fail initialization");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        ResolverAttributeDefinitionDependency dep3 = new ResolverAttributeDefinitionDependency("ad0");
        ad0 = new MockAttributeDefinition("ad0", new IdPAttribute("test"));
        ad0.setDependencies(Collections.singleton(dep3));
        definitions = new LazySet();
        definitions.add((Object)ad0);
        ad0.initialize();
        resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        try {
            resolver.initialize();
            Assert.fail((String)"invalid resolver configuration didn't fail initialization");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void badPluginIdInitializeOld() throws Exception {
        ResolverPluginDependency dep1 = new ResolverPluginDependency("dc1");
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", new IdPAttribute("test"));
        ad1.setDependencies(Collections.singleton(dep1));
        ad1.initialize();
        ResolverPluginDependency dep2 = new ResolverPluginDependency("ad1");
        MockAttributeDefinition ad0 = new MockAttributeDefinition("ad0", new IdPAttribute("test"));
        ad0.setDependencies(Collections.singleton(dep2));
        ad0.initialize();
        LazySet definitions = new LazySet();
        definitions.add((Object)ad0);
        definitions.add((Object)ad1);
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        try {
            resolver.initialize();
            Assert.fail((String)"invalid resolver configuration didn't fail initialization");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        ResolverPluginDependency dep3 = new ResolverPluginDependency("ad0");
        ad0 = new MockAttributeDefinition("ad0", new IdPAttribute("test"));
        ad0.setDependencies(Collections.singleton(dep3));
        definitions = new LazySet();
        definitions.add((Object)ad0);
        ad0.initialize();
        resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        try {
            resolver.initialize();
            Assert.fail((String)"invalid resolver configuration didn't fail initialization");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void circularDependencyInitializeOld() throws Exception {
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", new IdPAttribute("test"));
        ad1.setDependencies(Collections.singleton(new ResolverPluginDependency("ad1")));
        LazySet definitions = new LazySet();
        definitions.add((Object)ad1);
        ad1.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        try {
            resolver.initialize();
            Assert.fail((String)"invalid resolver configuration didn't fail initialization.");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        MockDataConnector dc1 = new MockDataConnector("dc1", null, Collections.singleton(new ResolverPluginDependency("ad0")));
        ad1 = new MockAttributeDefinition("ad1", new IdPAttribute("test"));
        ad1.setDependencies(Collections.singleton(new ResolverPluginDependency("dc1")));
        ad1.initialize();
        MockAttributeDefinition ad2 = new MockAttributeDefinition("ad2", new IdPAttribute("test"));
        ad2.setDependencies(Collections.singleton(new ResolverPluginDependency("dc1")));
        ad2.initialize();
        MockAttributeDefinition ad0 = new MockAttributeDefinition("ad0", new IdPAttribute("test"));
        ad0.setDependencies(new HashSet<ResolverPluginDependency>(Arrays.asList(new ResolverPluginDependency("ad1"), new ResolverPluginDependency("ad2"))));
        ad0.initialize();
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        definitions = new LazySet();
        definitions.add((Object)ad0);
        definitions.add((Object)ad1);
        definitions.add((Object)ad2);
        resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        try {
            resolver.initialize();
            Assert.fail((String)"invalid resolver configuration didn't fail initialization");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void circularDependencyInitialize() throws Exception {
        MockAttributeDefinition ad1 = new MockAttributeDefinition("ad1", new IdPAttribute("test"));
        ad1.setDependencies(Collections.singleton(new ResolverAttributeDefinitionDependency("ad1")));
        LazySet definitions = new LazySet();
        definitions.add((Object)ad1);
        ad1.initialize();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        try {
            resolver.initialize();
            Assert.fail((String)"invalid resolver configuration didn't fail initialization.");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        MockDataConnector dc1 = new MockDataConnector("dc1", null, Collections.singleton(new ResolverAttributeDefinitionDependency("ad0")));
        ad1 = new MockAttributeDefinition("ad1", new IdPAttribute("test"));
        ad1.setDependencies(Collections.singleton(new ResolverDataConnectorDependency("dc1")));
        ad1.initialize();
        MockAttributeDefinition ad2 = new MockAttributeDefinition("ad2", new IdPAttribute("test"));
        ad2.setDependencies(Collections.singleton(new ResolverDataConnectorDependency("dc1")));
        ad2.initialize();
        MockAttributeDefinition ad0 = new MockAttributeDefinition("ad0", new IdPAttribute("test"));
        ad0.setDependencies(new HashSet<ResolverPluginDependency>(Arrays.asList(new ResolverAttributeDefinitionDependency("ad1"), new ResolverAttributeDefinitionDependency("ad2"))));
        ad0.initialize();
        LazySet connectors = new LazySet();
        connectors.add((Object)dc1);
        definitions = new LazySet();
        definitions.add((Object)ad0);
        definitions.add((Object)ad1);
        definitions.add((Object)ad2);
        resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, (Collection<DataConnector>)connectors, null);
        try {
            resolver.initialize();
            Assert.fail((String)"invalid resolver configuration didn't fail initialization");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testPrincipalConnector() throws ComponentInitializationException, ResolutionException {
        LazySet definitions = new LazySet();
        AttributeResolverImpl resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, null);
        resolver.initialize();
        Assert.assertNull((Object)resolver.canonicalize(null));
        resolver = AttributeResolverImplTest.newAttributeResolverImpl("foo", (Collection<AttributeDefinition>)definitions, null, new LegacyPrincipalDecoder(){

            @Nullable
            public String canonicalize(SubjectCanonicalizationContext context) throws ResolutionException {
                return "Principal";
            }

            public boolean hasValidConnectors() {
                return true;
            }
        });
        resolver.initialize();
        Assert.assertEquals((String)resolver.canonicalize(null), (String)"Principal");
    }

    public static AttributeResolverImpl newAttributeResolverImpl(@Nonnull @NotEmpty String resolverId, @Nullable @NullableElements Collection<AttributeDefinition> definitions, @Nullable @NullableElements Collection<DataConnector> connectors, @Nullable LegacyPrincipalDecoder principalResolver) {
        AttributeResolverImpl result = new AttributeResolverImpl();
        result.setId(resolverId);
        result.setAttributeDefinitions(definitions);
        result.setDataConnectors(connectors);
        result.setPrincipalDecoder(principalResolver);
        return result;
    }
}

