/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextDerivedAttributeDefinition
extends AbstractAttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(ContextDerivedAttributeDefinition.class);
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> prcLookupStrategy = new ParentContextLookup();
    @Nonnull
    private Function<ProfileRequestContext, List<IdPAttributeValue<?>>> attributeValuesFunction;

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.prcLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    public void setAttributeValuesFunction(@Nonnull Function<ProfileRequestContext, List<IdPAttributeValue<?>>> function) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeValuesFunction = (Function)Constraint.isNotNull(function, (String)"Attribute Function cannot be null");
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ProfileRequestContext prc = (ProfileRequestContext)this.prcLookupStrategy.apply((Object)resolutionContext);
        List results = (List)this.attributeValuesFunction.apply((Object)prc);
        if (null == results) {
            this.log.debug("{} Generated no values.", (Object)this.getLogPrefix());
            return null;
        }
        this.log.debug("{} Generated {} values.", (Object)this.getLogPrefix(), (Object)results.size());
        this.log.trace("{} Values:", (Object)this.getLogPrefix(), (Object)results);
        IdPAttribute attribute = new IdPAttribute(this.getId());
        attribute.setValues((Collection)results);
        return attribute;
    }

    protected void doInitialize() throws ComponentInitializationException {
        Constraint.isNotNull(this.prcLookupStrategy, (String)"ProfileRequestContext lookup strategy cannot be null");
        Constraint.isNotNull(this.attributeValuesFunction, (String)"AttributeValue Function cannot be null");
        super.doInitialize();
    }
}

