/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import com.google.common.base.Function;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ad.impl.ContextDerivedAttributeDefinition;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectDerivedAttributeValuesFunction
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, List<IdPAttributeValue<?>>> {
    private final Logger log = LoggerFactory.getLogger(ContextDerivedAttributeDefinition.class);
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> scLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @Nonnull
    private Function<Principal, List<IdPAttributeValue<?>>> attributesValueFunction;

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void setAttributeValuesFunction(@Nonnull Function<Principal, List<IdPAttributeValue<?>>> engine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributesValueFunction = (Function)Constraint.isNotNull(engine, (String)"Attribute Engine cannot be null");
    }

    @Nullable
    public List<IdPAttributeValue<?>> apply(@Nullable ProfileRequestContext prc) {
        SubjectContext cs = (SubjectContext)this.scLookupStrategy.apply((Object)prc);
        ArrayList results = new ArrayList(1);
        for (Subject subject : cs.getSubjects()) {
            for (Principal principal : subject.getPrincipals()) {
                List values = (List)this.attributesValueFunction.apply((Object)principal);
                if (null == values || values.isEmpty()) continue;
                results.addAll(values);
            }
        }
        if (results.isEmpty()) {
            this.log.info("{} generated no values, attribute no resolved.", (Object)this.getLogPrefix());
            return null;
        }
        this.log.debug("{} Generated {} values.", (Object)this.getLogPrefix(), (Object)results.size());
        this.log.trace("{} Values:", (Object)this.getLogPrefix(), results);
        return results;
    }

    protected void doInitialize() throws ComponentInitializationException {
        Constraint.isNotNull(this.scLookupStrategy, (String)"SubjectContext lookup strategy cannot be null");
        Constraint.isNotNull(this.attributesValueFunction, (String)"Attribute Engine cannot be null");
        super.doInitialize();
    }

    private String getLogPrefix() {
        return "SubjectDerivedAttributeDefinition" + this.getId();
    }
}

